/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.WWindowPeer;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.windows.WindowsFlags;
import sun.security.action.GetPropertyAction;

public class Win32GraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    ColorModel dynamicColorModel;
    ColorModel colorModel;
    protected GraphicsConfiguration[] configs;
    protected GraphicsConfiguration defaultConfig;
    private final String idString;
    protected String descString;
    private boolean valid;
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    protected static boolean pfDisabled;
    private static AWTPermission fullScreenExclusivePermission;
    private DisplayMode defaultDisplayMode;
    private WindowListener fsWindowListener;
    private float scaleX;
    private float scaleY;

    private static native void initIDs();

    native void initDevice(int var1);

    native void initNativeScale(int var1);

    native void setNativeScale(int var1, float var2, float var3);

    native float getNativeScaleX(int var1);

    native float getNativeScaleY(int var1);

    public Win32GraphicsDevice(int n) {
        this.screen = n;
        this.idString = "\\Display" + this.screen;
        this.descString = "Win32GraphicsDevice[screen=" + this.screen;
        this.valid = true;
        this.initDevice(n);
        this.initScaleFactors();
    }

    @Override
    public int getType() {
        return 0;
    }

    public int getScreen() {
        return this.screen;
    }

    public float getDefaultScaleX() {
        return this.scaleX;
    }

    public float getDefaultScaleY() {
        return this.scaleY;
    }

    private void initScaleFactors() {
        if (SunGraphicsEnvironment.isUIScaleEnabled()) {
            if (Win32GraphicsEnvironment.debugScaleX > 0.0f && Win32GraphicsEnvironment.debugScaleY > 0.0f) {
                this.scaleX = Win32GraphicsEnvironment.debugScaleX;
                this.scaleY = Win32GraphicsEnvironment.debugScaleY;
                this.setNativeScale(this.screen, this.scaleX, this.scaleY);
            } else {
                this.initNativeScale(this.screen);
                this.scaleX = this.getNativeScaleX(this.screen);
                this.scaleY = this.getNativeScaleY(this.screen);
            }
        } else {
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    protected void invalidate(int n) {
        this.valid = false;
        this.screen = n;
    }

    @Override
    public String getIDstring() {
        return this.idString;
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            if (WindowsFlags.isOGLEnabled() && this.isDefaultDevice()) {
                this.defaultConfig = this.getDefaultConfiguration();
                if (this.defaultConfig != null) {
                    this.configs = new GraphicsConfiguration[1];
                    this.configs[0] = this.defaultConfig;
                    return (GraphicsConfiguration[])this.configs.clone();
                }
            }
            int n = this.getMaxConfigs(this.screen);
            int n2 = this.getDefaultPixID(this.screen);
            Vector<GraphicsConfiguration> vector = new Vector<GraphicsConfiguration>(n);
            if (n2 == 0) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, n2);
                vector.addElement(this.defaultConfig);
            } else {
                for (int i = 1; i <= n; ++i) {
                    if (!this.isPixFmtSupported(i, this.screen)) continue;
                    if (i == n2) {
                        this.defaultConfig = Win32GraphicsConfig.getConfig(this, i);
                        vector.addElement(this.defaultConfig);
                        continue;
                    }
                    vector.addElement(Win32GraphicsConfig.getConfig(this, i));
                }
            }
            this.configs = new GraphicsConfiguration[vector.size()];
            vector.copyInto(this.configs);
        }
        return (GraphicsConfiguration[])this.configs.clone();
    }

    protected int getMaxConfigs(int n) {
        if (pfDisabled) {
            return 1;
        }
        return this.getMaxConfigsImpl(n);
    }

    private native int getMaxConfigsImpl(int var1);

    protected native boolean isPixFmtSupported(int var1, int var2);

    protected int getDefaultPixID(int n) {
        if (pfDisabled) {
            return 0;
        }
        return this.getDefaultPixIDImpl(n);
    }

    private native int getDefaultPixIDImpl(int var1);

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            if (WindowsFlags.isOGLEnabled() && this.isDefaultDevice()) {
                int n = WGLGraphicsConfig.getDefaultPixFmt(this.screen);
                this.defaultConfig = WGLGraphicsConfig.getConfig(this, n);
                if (WindowsFlags.isOGLVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, 0);
            }
        }
        return this.defaultConfig;
    }

    public String toString() {
        return this.valid ? this.descString + "]" : this.descString + ", removed]";
    }

    private boolean isDefaultDevice() {
        return this == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    private static boolean isFSExclusiveModeAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                securityManager.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFullScreenSupported() {
        return Win32GraphicsDevice.isFSExclusiveModeAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setFullScreenWindow(Window window) {
        WWindowPeer wWindowPeer;
        WWindowPeer wWindowPeer2;
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        if (!this.isFullScreenSupported()) {
            super.setFullScreenWindow(window);
            return;
        }
        if (window2 != null) {
            if (this.defaultDisplayMode != null) {
                this.setDisplayMode(this.defaultDisplayMode);
                this.defaultDisplayMode = null;
            }
            if ((wWindowPeer2 = (WWindowPeer)window2.getPeer()) != null) {
                wWindowPeer2.setFullScreenExclusiveModeState(false);
                wWindowPeer = wWindowPeer2;
                synchronized (wWindowPeer) {
                    this.exitFullScreenExclusive(this.screen, wWindowPeer2);
                }
            }
            this.removeFSWindowListener(window2);
        }
        super.setFullScreenWindow(window);
        if (window != null) {
            this.defaultDisplayMode = this.getDisplayMode();
            this.addFSWindowListener(window);
            wWindowPeer2 = (WWindowPeer)window.getPeer();
            if (wWindowPeer2 != null) {
                wWindowPeer = wWindowPeer2;
                synchronized (wWindowPeer) {
                    this.enterFullScreenExclusive(this.screen, wWindowPeer2);
                }
                wWindowPeer2.setFullScreenExclusiveModeState(true);
            }
            wWindowPeer2.updateGC();
        }
    }

    protected native void enterFullScreenExclusive(int var1, WindowPeer var2);

    protected native void exitFullScreenExclusive(int var1, WindowPeer var2);

    @Override
    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    @Override
    public synchronized void setDisplayMode(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(displayMode);
            return;
        }
        if (displayMode == null || (displayMode = this.getMatchingDisplayMode(displayMode)) == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (this.getDisplayMode().equals(displayMode)) {
            return;
        }
        Window window = this.getFullScreenWindow();
        if (window == null) {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
        this.configDisplayMode(this.screen, wWindowPeer, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        Rectangle rectangle = this.getDefaultConfiguration().getBounds();
        window.setBounds(rectangle.x, rectangle.y, displayMode.getWidth(), displayMode.getHeight());
    }

    protected native DisplayMode getCurrentDisplayMode(int var1);

    protected native void configDisplayMode(int var1, WindowPeer var2, int var3, int var4, int var5, int var6);

    protected native void enumDisplayModes(int var1, ArrayList var2);

    @Override
    public synchronized DisplayMode getDisplayMode() {
        DisplayMode displayMode = this.getCurrentDisplayMode(this.screen);
        return displayMode;
    }

    @Override
    public synchronized DisplayMode[] getDisplayModes() {
        ArrayList arrayList = new ArrayList();
        this.enumDisplayModes(this.screen, arrayList);
        int n = arrayList.size();
        DisplayMode[] displayModeArray = new DisplayMode[n];
        for (int i = 0; i < n; ++i) {
            displayModeArray[i] = (DisplayMode)arrayList.get(i);
        }
        return displayModeArray;
    }

    protected synchronized DisplayMode getMatchingDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray;
        if (!this.isDisplayChangeSupported()) {
            return null;
        }
        for (DisplayMode displayMode2 : displayModeArray = this.getDisplayModes()) {
            if (!displayMode.equals(displayMode2) && (displayMode.getRefreshRate() != 0 || displayMode.getWidth() != displayMode2.getWidth() || displayMode.getHeight() != displayMode2.getHeight() || displayMode.getBitDepth() != displayMode2.getBitDepth())) continue;
            return displayMode2;
        }
        return null;
    }

    @Override
    public void displayChanged() {
        this.dynamicColorModel = null;
        this.defaultConfig = null;
        this.configs = null;
        this.initScaleFactors();
        this.topLevels.notifyListeners();
    }

    @Override
    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    private native ColorModel makeColorModel(int var1, boolean var2);

    public ColorModel getDynamicColorModel() {
        if (this.dynamicColorModel == null) {
            this.dynamicColorModel = this.makeColorModel(this.screen, true);
        }
        return this.dynamicColorModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen, false);
        }
        return this.colorModel;
    }

    protected void addFSWindowListener(final Window window) {
        this.fsWindowListener = new Win32FSWindowAdapter(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.addWindowListener(Win32GraphicsDevice.this.fsWindowListener);
            }
        });
    }

    protected void removeFSWindowListener(Window window) {
        window.removeWindowListener(this.fsWindowListener);
        this.fsWindowListener = null;
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.nopixfmt"));
        pfDisabled = string != null;
        Win32GraphicsDevice.initIDs();
    }

    private static class Win32FSWindowAdapter
    extends WindowAdapter {
        private Win32GraphicsDevice device;
        private DisplayMode dm;

        Win32FSWindowAdapter(Win32GraphicsDevice win32GraphicsDevice) {
            this.device = win32GraphicsDevice;
        }

        private void setFSWindowsState(Window window, int n) {
            GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            if (window != null) {
                for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                    if (window != graphicsDevice.getFullScreenWindow()) continue;
                    return;
                }
            }
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                Window window2 = graphicsDevice.getFullScreenWindow();
                if (!(window2 instanceof Frame)) continue;
                ((Frame)window2).setExtendedState(n);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            this.setFSWindowsState(windowEvent.getOppositeWindow(), 1);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            this.setFSWindowsState(windowEvent.getOppositeWindow(), 0);
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
            DisplayMode displayMode = this.device.defaultDisplayMode;
            if (displayMode != null) {
                this.dm = this.device.getDisplayMode();
                this.device.setDisplayMode(displayMode);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
            if (this.dm != null) {
                this.device.setDisplayMode(this.dm);
                this.dm = null;
            }
        }
    }
}

