/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import sun.plugin2.main.client.JVMHealthData;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.PluginMessage;
import sun.plugin2.message.Serializer;

public class HeartbeatMessage
extends PluginMessage {
    public static final int ID = 15;
    public static final long DEFAULT_INTERVAL = 1000L;
    public static final long DEFAULT_TIMEOUT = 10000L;
    private static long INTERVAL_TIMEOUT_SAFETY = 1000L;
    private static long MINIMAL_TIMEOUT = 2000L;
    private JVMHealthData healthData;
    private long timeout = 10000L;
    private long interval = 1000L;

    public HeartbeatMessage(Conversation c) {
        this(c, null);
    }

    public HeartbeatMessage(Conversation c, JVMHealthData data) {
        super(15, c);
        this.healthData = data != null ? data.clone() : new JVMHealthData();
    }

    public HeartbeatMessage(Conversation c, long interval, long timeout) {
        this(c);
        this.interval = interval;
        this.timeout = timeout;
    }

    public void updateHealthData() {
        this.healthData = JVMHealthData.getCurrent();
    }

    public JVMHealthData getHealthData() {
        return this.healthData.clone();
    }

    public void adjustTiming(long interval, long timeout) {
        if (timeout < MINIMAL_TIMEOUT) {
            timeout = MINIMAL_TIMEOUT;
        }
        this.interval = interval > this.timeout - INTERVAL_TIMEOUT_SAFETY ? this.timeout - INTERVAL_TIMEOUT_SAFETY : interval;
        this.timeout = timeout < this.interval + INTERVAL_TIMEOUT_SAFETY ? this.interval + INTERVAL_TIMEOUT_SAFETY : timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void writeFields(Serializer ser) throws IOException {
        HeartbeatMessage.writeJVMHealthData(ser, this.healthData);
        ser.writeLong(this.timeout);
        ser.writeLong(this.interval);
    }

    @Override
    public void readFields(Serializer ser) throws IOException {
        this.healthData = HeartbeatMessage.readJVMHealthData(ser);
        this.timeout = ser.readLong();
        this.interval = ser.readLong();
    }

    static void writeJVMHealthData(Serializer ser, JVMHealthData data) throws IOException {
        long maxHeap = data == null ? -1L : data.getMaxHeapSize();
        long heap = data == null ? -1L : data.getHeapSize();
        long freeHeap = data == null ? -1L : data.getFreeHeapSize();
        int threadCount = data == null ? -1 : data.getAppletThreadCount();
        ser.writeLong(maxHeap);
        ser.writeLong(heap);
        ser.writeLong(freeHeap);
        ser.writeInt(threadCount);
    }

    static JVMHealthData readJVMHealthData(Serializer ser) throws IOException {
        long maxHeap = ser.readLong();
        long heap = ser.readLong();
        long freeHeap = ser.readLong();
        int threadCount = ser.readInt();
        return new JVMHealthData(maxHeap, heap, freeHeap, threadCount);
    }

    public String toString() {
        String s = this.getConversation() + " ";
        return s + (this.healthData == null ? "{healthData: null }" : this.healthData.toString());
    }
}

