/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.trace.Trace;
import java.applet.Applet;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.PropertyPermission;
import sun.net.www.ParseUtil;
import sun.plugin.com.Dispatch;
import sun.plugin.com.DispatchClient;
import sun.plugin.com.Dispatcher;
import sun.plugin.com.JavaClass;
import sun.plugin.com.Utils;
import sun.plugin.javascript.ocx.JSObject;
import sun.plugin.security.PluginClassLoader;
import sun.plugin.viewer.context.IExplorerAppletContext;
import sun.plugin2.liveconnect.JavaScriptProtectionDomain;

public class DispatchImpl
implements Dispatch {
    JavaClass targetClass = null;
    Object targetObj = null;
    private int handle = 0;
    private int wndHandle = 0;
    AccessControlContext context = null;
    boolean isBridge = false;

    public DispatchImpl(Object obj, int id) {
        this.targetObj = obj;
        this.handle = id;
    }

    @Override
    public Object invoke(final int flag, final int index, final Object[] params) throws Exception {
        try {
            if (this.isBridge) {
                return this.invokeImpl(flag, index, params);
            }
            if (this.context == null) {
                this.context = this.createContext();
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return DispatchImpl.this.invokeImpl(flag, index, params);
                }
            }, this.context);
        }
        catch (Exception exc) {
            Throwable cause = exc.getCause();
            if (cause == null) {
                cause = exc;
            }
            Trace.liveConnectPrintException((Throwable)cause);
            throw new Exception(cause.toString());
        }
    }

    public AccessControlContext createContext() {
        try {
            ProtectionDomain[] domains = new ProtectionDomain[1];
            ProtectionDomain pd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    return DispatchImpl.this.targetObj.getClass().getProtectionDomain();
                }
            });
            CodeSource cs = null;
            URL url = null;
            if (pd != null) {
                cs = pd.getCodeSource();
            }
            if (cs != null) {
                url = cs.getLocation();
            }
            domains[0] = DispatchImpl.getJSProtectionDomain(url, this.targetObj.getClass());
            return new AccessControlContext(domains);
        }
        catch (Exception exc) {
            Trace.liveConnectPrintException((Throwable)exc);
            return null;
        }
    }

    public Object invokeImpl(int flag, int index, Object[] params) throws Exception {
        Object retObj = null;
        Dispatcher disp = null;
        try {
            if (params != null) {
                this.convertParams(params);
            }
            if ((disp = this.targetClass.getDispatcher(flag, index, params)) != null && (retObj = disp.invoke(this.targetObj, params)) != null) {
                retObj = Utils.convertReturn(disp.getReturnType(), retObj, this.handle);
            }
            return retObj;
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            Trace.liveConnectPrintException((Throwable)cause);
            throw new Exception(cause.toString());
        }
    }

    @Override
    public Object getWrappedObject() {
        return this.targetObj;
    }

    public JavaClass getTargetClass() {
        if (this.targetClass == null && this.targetObj != null) {
            this.targetClass = new JavaClass(this.targetObj.getClass());
        }
        return this.targetClass;
    }

    @Override
    public int getReturnType(int flag, int index, Object[] params) {
        Class<?> clazz = null;
        try {
            Dispatcher dispatcher = null;
            if (params != null) {
                this.convertParams(params);
            }
            if ((dispatcher = this.targetClass.getDispatcher(flag, index, params)) != null) {
                clazz = dispatcher.getReturnType();
            }
        }
        catch (InvocationTargetException e) {
            Trace.liveConnectPrintException((Throwable)e);
            clazz = null;
        }
        return Utils.getType(clazz);
    }

    @Override
    public int getIdForName(final String name) throws Exception {
        try {
            if (this.isBridge) {
                return this.getIdForNameImpl(name);
            }
            if (this.context == null) {
                this.context = this.createContext();
            }
            Integer retVal = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return DispatchImpl.this.getIdForNameImpl(name);
                }
            }, this.context);
            return retVal;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return -1;
        }
    }

    public int getIdForNameImpl(String name) throws Exception {
        int id = -1;
        if (this.targetClass == null && this.targetObj != null) {
            this.targetClass = new JavaClass(this.targetObj.getClass());
        }
        if (this.targetClass != null) {
            id = this.targetClass.getIdForName(name);
        }
        return id;
    }

    private void convertParams(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null && params[i] instanceof DispatchImpl) {
                params[i] = ((DispatchImpl)params[i]).getWrappedObject();
                continue;
            }
            if (params[i] == null || !(params[i] instanceof DispatchClient)) continue;
            JSObject jsObj = null;
            if (!this.isBridge) {
                jsObj = new JSObject((DispatchClient)params[i]);
                jsObj.setIExplorerAppletContext((IExplorerAppletContext)((Applet)this.targetObj).getAppletContext());
            } else {
                jsObj = new JSObject((DispatchClient)params[i], this.handle);
            }
            params[i] = jsObj;
        }
    }

    public static ProtectionDomain getJSProtectionDomain(URL url, Class<?> clazz) throws MalformedURLException {
        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        CodeSource cs = new CodeSource(null, (Certificate[])null);
        PermissionCollection pc = policy.getPermissions(cs);
        pc.add(new PropertyPermission("http.agent", "read"));
        if (url != null) {
            Permission p;
            Object path = null;
            try {
                p = url.openConnection().getPermission();
            }
            catch (IOException ioe) {
                p = null;
            }
            if (p instanceof FilePermission) {
                path = p.getName();
            } else if (p == null && url.getProtocol().equals("file")) {
                path = url.getFile().replace('/', File.separatorChar);
                path = ParseUtil.decode((String)path);
            } else if (p instanceof SocketPermission) {
                String host = url.getHost();
                pc.add(new SocketPermission(host, "connect,accept"));
                pc.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)url)));
            }
            if (path != null && clazz.getClassLoader() instanceof PluginClassLoader) {
                if (((String)path).endsWith(File.separator)) {
                    path = (String)path + "-";
                } else {
                    int endIndex = ((String)path).lastIndexOf(File.separatorChar);
                    if (endIndex != -1) {
                        path = ((String)path).substring(0, endIndex + 1) + "-";
                    }
                }
                pc.add(new FilePermission((String)path, "read"));
            }
        }
        return new JavaScriptProtectionDomain(pc);
    }

    public String toString() {
        if (this.targetObj != null) {
            return this.targetObj.toString();
        }
        return null;
    }

    public int getWindowHandle() {
        if (this.wndHandle == 0) {
            this.wndHandle = this.getWindowHandle(this.handle);
        }
        return this.wndHandle;
    }

    protected void setBridge() {
        this.isBridge = true;
    }

    native int getWindowHandle(int var1);
}

