/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.JARDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFileCallBack;
import sun.plugin.util.JarCacheUtil;

public class PluginURLJarFileCallBack
implements URLJarFileCallBack {
    private static int BUF_SIZE = 8192;

    private URLConnection connect(URL url, boolean useCompression) throws IOException {
        URLConnection conn = url.openConnection();
        if (useCompression && !HttpUtils.hasGzipOrPack200Encoding((URLConnection)conn)) {
            conn.setRequestProperty("accept-encoding", "pack200-gzip, gzip");
        }
        conn.setRequestProperty("content-type", "application/x-java-archive");
        conn.connect();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadJAR(URLConnection conn) throws IOException {
        try (InputStream is = null;){
            is = conn.getInputStream();
            if (is != null && !(is instanceof FileInputStream)) {
                is = new BufferedInputStream(is);
                byte[] buf = new byte[BUF_SIZE];
                while (is.read(buf) != -1) {
                }
            }
        }
    }

    @Override
    public JarFile retrieve(final URL url) throws IOException {
        JarFile result = null;
        final boolean isPackEnabled = PluginURLJarFileCallBack.isPackEnable(url);
        URL u = url;
        if (isPackEnabled) {
            u = URLUtil.getPack200URL((URL)url, (boolean)true);
        }
        final URLConnection conn = this.connect(u, true);
        try {
            result = AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws IOException {
                    URL urlNoQuery = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                    String jarVersion = (String)ToolkitStore.get().getAppContext().get((Object)("deploy-" + urlNoQuery.toString()));
                    JarFile jf = null;
                    if (ResourceProvider.get().canCache(urlNoQuery)) {
                        block9: {
                            URLConnection conn2;
                            try {
                                try {
                                    PluginURLJarFileCallBack.this.downloadJAR(conn);
                                }
                                catch (FileNotFoundException fnfe) {
                                    if (isPackEnabled) {
                                        HttpUtils.cleanupConnection((URLConnection)conn);
                                        URLUtil.clearPack200Original();
                                        conn2 = PluginURLJarFileCallBack.this.connect(url, true);
                                        PluginURLJarFileCallBack.this.downloadJAR(conn2);
                                        break block9;
                                    }
                                    throw fnfe;
                                }
                            }
                            catch (IOException ioe) {
                                Trace.ignoredException((Exception)ioe);
                                HttpUtils.cleanupConnection((URLConnection)conn);
                                conn2 = PluginURLJarFileCallBack.this.connect(url, false);
                                PluginURLJarFileCallBack.this.downloadJAR(conn2);
                            }
                        }
                        jf = ResourceProvider.get().getCachedJarFile(jarVersion == null ? url : urlNoQuery, jarVersion);
                    }
                    if (jf == null) {
                        int contentType = 256;
                        if (isPackEnabled) {
                            contentType |= 0x1000;
                        }
                        Resource r = ResourceProvider.get().getResource(jarVersion == null ? url : urlNoQuery, jarVersion, true, contentType, null);
                        JarFile jarFile = jf = r != null ? r.getJarFile() : null;
                    }
                    if (ResourceProvider.get().isInternalUse()) {
                        return jf;
                    }
                    return JarCacheUtil.cloneJarFile(jf);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        finally {
            if (isPackEnabled) {
                URLUtil.clearPack200Original();
            }
        }
        return result;
    }

    private static boolean isPackEnable(URL url) {
        try {
            JARDesc jd;
            JNLPClassLoaderIf clif = JNLPClassLoaderUtil.getInstance();
            if (clif != null && (jd = clif.getJarDescFromURL(url)) != null) {
                return jd.isPack200Enabled();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Property.isPackEnabled();
    }
}

