/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CeilingPolicy;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.javaws.Globals;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.PropertyPermission;

public class AppPolicy {
    private String _host = null;
    private File _extensionDir = null;
    private static AppPolicy _instance = null;

    public static AppPolicy getInstance() {
        return _instance;
    }

    public static AppPolicy createInstance(String string) {
        if (_instance == null) {
            _instance = new AppPolicy(string);
        }
        return _instance;
    }

    private AppPolicy(String string) {
        this._host = string;
        this._extensionDir = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public boolean addPermissions(JNLPClassLoaderIf jNLPClassLoaderIf, PermissionCollection permissionCollection, CodeSource codeSource, boolean bl) throws ExitException {
        Trace.println((String)("JAVAWS AppPolicy Permission requested for: " + codeSource.getLocation()), (TraceLevel)TraceLevel.SECURITY);
        DeploymentRuleSet deploymentRuleSet = jNLPClassLoaderIf.getDeploymentRuleSet(codeSource.getLocation());
        JARDesc jARDesc = jNLPClassLoaderIf.getJarDescFromURL(codeSource.getLocation());
        LaunchDesc launchDesc = null;
        int n = 0;
        boolean bl2 = false;
        if (jARDesc != null && jARDesc.getParent() != null) {
            launchDesc = jARDesc.getParent().getParent();
            if (launchDesc != null) {
                n = launchDesc.getSecurityModel();
            }
        } else {
            launchDesc = jNLPClassLoaderIf.getLaunchDesc();
            if (codeSource.getCertificates() == null) {
                n = 0;
            } else if (launchDesc != null) {
                n = launchDesc.getSecurityModel();
            }
        }
        if (bl) {
            if (n == 0) {
                this.grantRestrictedAccess(launchDesc, deploymentRuleSet, codeSource, jNLPClassLoaderIf.getPreloader());
            } else {
                this.grantUnrestrictedAccess(launchDesc, deploymentRuleSet, codeSource, jNLPClassLoaderIf.getPreloader(), false);
                bl2 = true;
                if (n == 1) {
                    CeilingPolicy.addTrustedPermissions((PermissionCollection)permissionCollection);
                } else {
                    this.addJ2EEApplicationClientPermissionsObject(permissionCollection);
                }
            }
        }
        if (!permissionCollection.implies(new AllPermission())) {
            this.addSandboxPermissionsObject(permissionCollection, launchDesc != null && launchDesc.getLaunchType() == 2);
        }
        if (launchDesc != null && !launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (!Config.isSecureProperty((String)string2, (String)(string = properties.getProperty(string2))) && !launchDesc.isSigned()) continue;
                PropertyPermission propertyPermission = new PropertyPermission(string2, "write");
                PermissionCollection permissionCollection2 = Policy.getPolicy().getPermissions(codeSource);
                if (permissionCollection.implies(propertyPermission) || permissionCollection2.implies(propertyPermission)) {
                    System.setProperty(string2, string);
                    continue;
                }
                Trace.ignoredException((Exception)new AccessControlException("access denied " + propertyPermission, propertyPermission));
            }
            launchDesc.setPropsSet(true);
        }
        return bl2;
    }

    private boolean isSuspiciousProperty(String string) {
        if ("javaplugin.user.profile".equals(string)) {
            Trace.println((String)"Property javaplugin.user.profile can not be set as trusted", (TraceLevel)TraceLevel.SECURITY);
            return true;
        }
        return false;
    }

    private void setUnrestrictedProps(LaunchDesc launchDesc) {
        if (!launchDesc.arePropsSet()) {
            Properties properties = launchDesc.getResources().getResourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            URL uRL = launchDesc.getLocation() != null ? launchDesc.getLocation() : launchDesc.getSourceURL();
            DeploymentRuleSet deploymentRuleSet = null;
            AppRef appRef = new AppRef(AppRef.Type.DOCBASE, null, uRL, null, (URL)null, launchDesc.getHash());
            deploymentRuleSet = DeploymentRuleSet.findDRS((CodeInstance)new CodeInstance(appRef, new CodeRef(null, null, false, false)));
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                if (Config.isSecureProperty((String)string2, (String)(string = properties.getProperty(string2))) || launchDesc.isSigned() || deploymentRuleSet != null && deploymentRuleSet.allowInsecureProperties() && !Globals.isNoCodebaseMode()) {
                    if (this.isSuspiciousProperty(string2)) continue;
                    System.setProperty(string2, string);
                    continue;
                }
                Trace.println((String)("Insecure property: (" + string2 + ", " + string + ") specified in unsigned jnlp file will not be set."));
            }
            launchDesc.setPropsSet(true);
        }
    }

    public void grantRestrictedAccess(LaunchDesc launchDesc, DeploymentRuleSet deploymentRuleSet, CodeSource codeSource, Preloader preloader) throws ExitException {
        if (launchDesc != null) {
            AppInfo appInfo = launchDesc.getAppInfo();
            try {
                SandboxSecurity.isPermissionGranted((CodeSource)codeSource, (AppInfo)appInfo, (DeploymentRuleSet)deploymentRuleSet, (Preloader)preloader, null);
            }
            catch (Exception exception) {
                throw new ExitException("Sandbox permissions not granted", exception, 0);
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
                throw new ExitException("Problem granting sandbox permissions", null, 0);
            }
        }
    }

    public long grantUnrestrictedAccess(LaunchDesc launchDesc, DeploymentRuleSet deploymentRuleSet, CodeSource codeSource, Preloader preloader, boolean bl) throws ExitException {
        try {
            return this.grantAllPermissions(launchDesc, deploymentRuleSet, codeSource, preloader, bl);
        }
        catch (JARSigningException jARSigningException) {
            BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)launchDesc.getAppInfo(), (Exception)((Object)jARSigningException));
            Main.systemExit(-1);
            return 0L;
        }
    }

    protected void setupAppInfoDTI(AppInfo appInfo, LaunchDesc launchDesc) {
        boolean bl = false;
        if (launchDesc.isApplicationDescriptor()) {
            ShortcutDesc shortcutDesc;
            LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
            if (localInstallHandler.isLocalInstallSupported() && (shortcutDesc = ResourceProvider.get().getLocalApplicationProperties(launchDesc.getCanonicalHome(), null, true)) != null && !shortcutDesc.getAskedForInstall()) {
                bl = true;
            }
            if (bl) {
                shortcutDesc = launchDesc.getInformation().getShortcut();
                String string = launchDesc.getInformation().getTitle();
                switch (Config.getShortcutValue()) {
                    default: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (shortcutDesc != null && string != null && string.length() > 0) {
                            appInfo.setDesktopHint(shortcutDesc.getDesktop());
                            appInfo.setMenuHint(shortcutDesc.getMenu());
                            appInfo.setSubmenu(shortcutDesc.getSubmenu());
                            break;
                        }
                        appInfo.setDesktopHint(false);
                        appInfo.setMenuHint(false);
                    }
                }
                if (localInstallHandler.isAssociationSupported() && Config.getAssociationValue() == 4) {
                    appInfo.setAssociations(launchDesc.getInformation().getAssociations());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long grantAllPermissions(LaunchDesc launchDesc, DeploymentRuleSet deploymentRuleSet, CodeSource codeSource, Preloader preloader, boolean bl) throws ExitException, JARSigningException {
        try {
            DeployManifestChecker.verify((DeploymentRuleSet)deploymentRuleSet, (URL)codeSource.getLocation(), (boolean)true, (AppInfo)launchDesc.getAppInfo());
        }
        catch (SecurityException securityException) {
            Trace.ignored((Throwable)securityException);
            BlockedDialog.show((AppInfo)launchDesc.getAppInfo(), null, null, (Exception)securityException, (CodeSource)codeSource, (DeploymentRuleSet)deploymentRuleSet);
        }
        AppInfo appInfo = null;
        try {
            long l;
            if (Globals.isSecureMode() && launchDesc.isInstaller()) {
                this.setUnrestrictedProps(launchDesc);
                long l2 = 0L;
                return l2;
            }
            appInfo = launchDesc.getAppInfo();
            this.setupAppInfoDTI(appInfo, launchDesc);
            if (appInfo != null && bl) {
                appInfo.setPermissionAttrOverride();
            }
            if ((l = TrustDecider.isAllPermissionGranted((CodeSource)codeSource, (AppInfo)appInfo, (DeploymentRuleSet)deploymentRuleSet, (Preloader)preloader)) != 0L) {
                this.setUnrestrictedProps(launchDesc);
                if (l != 1L) {
                    long l3 = l;
                    return l3;
                }
                long l4 = 0L;
                return l4;
            }
            if (codeSource.getCertificates() != null) {
                Trace.println((String)"We were not granted permission, exiting", (TraceLevel)TraceLevel.SECURITY);
            } else {
                String string = JarVerifier.getWeakAlgorithmMessage();
                UnsignedAccessViolationException unsignedAccessViolationException = new UnsignedAccessViolationException(launchDesc, codeSource.getLocation(), true, string);
                BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)appInfo, (Exception)unsignedAccessViolationException);
            }
        }
        catch (BlockedException blockedException) {
            throw blockedException;
        }
        catch (CertificateException certificateException) {
            if (certificateException.getCause() != null && certificateException.getCause() instanceof JARSigningException) {
                throw (JARSigningException)certificateException.getCause();
            }
            if (certificateException instanceof CertificateRevokedException) {
                BlockedException blockedException = new BlockedException(ResourceManager.getString((String)"security.badcert.blocked.revoked.reason"), (Throwable)certificateException, codeSource, appInfo);
                if (Environment.isJavaPlugin()) {
                    throw blockedException;
                }
                BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)appInfo, (Exception)((Object)blockedException));
            } else {
                BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)appInfo, (Exception)certificateException);
            }
        }
        catch (Exception exception) {
            BadCertificateDialog.showDialog((CodeSource)codeSource, (AppInfo)appInfo, (Exception)exception);
        }
        finally {
            if (appInfo != null) {
                appInfo.unsetPermissionAttrOverride();
            }
        }
        Main.systemExit(-1);
        return 0L;
    }

    private void addJ2EEApplicationClientPermissionsObject(PermissionCollection permissionCollection) {
        Trace.println((String)"Creating J2EE-application-client-permisisons object", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new AWTPermission("accessClipboard"));
        permissionCollection.add(new AWTPermission("accessEventQueue"));
        permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        permissionCollection.add(new RuntimePermission("exitVM"));
        permissionCollection.add(new RuntimePermission("loadLibrary"));
        permissionCollection.add(new RuntimePermission("queuePrintJob"));
        permissionCollection.add(new SocketPermission("*", "connect"));
        permissionCollection.add(new SocketPermission("localhost:1024-", "accept,listen"));
        permissionCollection.add(new FilePermission("*", "read,write"));
        permissionCollection.add(new PropertyPermission("*", "read"));
    }

    private void addSandboxPermissionsObject(PermissionCollection permissionCollection, boolean bl) {
        String[] stringArray;
        Trace.println((String)"Add sandbox permissions", (TraceLevel)TraceLevel.SECURITY);
        permissionCollection.add(new PropertyPermission("java.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vendor.url", "read"));
        permissionCollection.add(new PropertyPermission("java.class.version", "read"));
        permissionCollection.add(new PropertyPermission("os.name", "read"));
        permissionCollection.add(new PropertyPermission("os.arch", "read"));
        permissionCollection.add(new PropertyPermission("os.version", "read"));
        permissionCollection.add(new PropertyPermission("file.separator", "read"));
        permissionCollection.add(new PropertyPermission("path.separator", "read"));
        permissionCollection.add(new PropertyPermission("line.separator", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.specification.name", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.version", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.vendor", "read"));
        permissionCollection.add(new PropertyPermission("java.vm.name", "read"));
        permissionCollection.add(new PropertyPermission("mrj.version", "read"));
        permissionCollection.add(new PropertyPermission("javawebstart.version", "read"));
        if (JNLPClassLoaderUtil.getInstance() instanceof JNLPClassLoader) {
            permissionCollection.add(new RuntimePermission("exitVM"));
        }
        String string = "Java " + (bl ? "Applet" : "Application") + " Window";
        if (Config.getBooleanProperty((String)"deployment.security.sandbox.awtwarningwindow")) {
            System.setProperty("awt.appletWarning", string);
        } else {
            permissionCollection.add(new AWTPermission("showWindowWithoutWarningBanner"));
        }
        permissionCollection.add(new PropertyPermission("jnlp.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javaws.*", "read,write"));
        permissionCollection.add(new PropertyPermission("javapi.*", "read,write"));
        for (String string2 : stringArray = Config.getSecureProperties()) {
            permissionCollection.add(new PropertyPermission(string2, "read,write"));
        }
        String[] stringArray2 = Globals.getApplicationArgs();
        if (stringArray2 != null && stringArray2.length == 2) {
            if (stringArray2[0].equals("-open")) {
                permissionCollection.add(new FilePermission(stringArray2[1], "read, write"));
            } else if (stringArray2[0].equals("-print")) {
                permissionCollection.add(new FilePermission(stringArray2[1], "read, write"));
                permissionCollection.add(new RuntimePermission("queuePrintJob"));
            }
        }
    }
}

