/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String ANY_JRE_VERSION = "0+";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JREInfo selectJRE(LaunchDesc launchDesc, JREMatcher jREMatcher) {
        JREMatcher jREMatcher2 = jREMatcher;
        synchronized (jREMatcher2) {
            if (!jREMatcher.hasBeenRun()) {
                jREMatcher.beginTraversal(launchDesc);
                ResourcesDesc resourcesDesc = launchDesc.getRawResources();
                if (resourcesDesc != null) {
                    ResourcesDesc resourcesDesc2 = new ResourcesDesc();
                    resourcesDesc2.addNested(resourcesDesc);
                    LaunchSelection.selectJREDescHelper(launchDesc, jREMatcher);
                    JREDesc jREDesc = jREMatcher.getSelectedJREDesc();
                    if (jREDesc != null) {
                        resourcesDesc2.addNested(jREDesc.getNestedResources());
                    }
                    if (!launchDesc.isInstaller()) {
                        LaunchSelection.collectJVMProperties(resourcesDesc2, jREMatcher);
                    }
                }
                jREMatcher.endTraversal(launchDesc);
            }
            return jREMatcher.getSelectedJREInfo();
        }
    }

    protected static boolean addNestedResourcesForRunningJRE(LaunchDesc launchDesc) {
        boolean bl = false;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            JREMatcher jREMatcher = new JREMatcher();
            jREMatcher.beginTraversal(launchDesc);
            LaunchSelection.selectJREDescHelper(launchDesc, jREMatcher);
            JREDesc jREDesc = jREMatcher.getRunningJREDesc();
            if (jREDesc != null) {
                resourcesDesc.addNested(jREDesc.getNestedResources());
                bl = true;
            }
            jREMatcher.endTraversal(launchDesc);
        }
        return bl;
    }

    private static void selectJREDescHelper(final LaunchDesc launchDesc, JREMatcher jREMatcher) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitJREDesc(JREDesc jREDesc) {
                if (launchDesc.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
                } else {
                    arrayList.add(jREDesc);
                }
            }
        });
        JREDesc jREDesc = null;
        JREInfo jREInfo = null;
        boolean bl = false;
        for (JREDesc jREDesc2 : arrayList) {
            JREInfo jREInfo2;
            if (!(jREInfo != null && bl || (jREInfo2 = LaunchSelection.selectJRE(jREDesc2, jREMatcher, launchDesc.needFX())) == null)) {
                jREInfo = jREInfo2;
                jREDesc = jREDesc2;
            }
            if (jREMatcher.getRunningJREDesc() != null || !jREMatcher.isVersionMatch(JREInfo.getHomeJRE(), jREDesc2)) continue;
            jREMatcher.setRunningJREDesc(jREDesc2);
            bl = true;
        }
        if (jREInfo == null) {
            if (arrayList.isEmpty()) {
                jREDesc = new JREDesc(ANY_JRE_VERSION, -1L, -1L, null, null, new ResourcesDesc(), null);
                jREInfo = LaunchSelection.selectJRE(jREDesc, jREMatcher, launchDesc.needFX());
            } else {
                jREDesc = (JREDesc)arrayList.get(0);
            }
        }
        jREMatcher.digest(jREDesc, jREInfo);
    }

    private static void collectJVMProperties(ResourcesDesc resourcesDesc, JREMatcher jREMatcher) {
        if (resourcesDesc == null) {
            return;
        }
        jREMatcher.digest(resourcesDesc);
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            @Override
            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }
        });
        for (ExtensionDesc extensionDesc : arrayList) {
            LaunchDesc launchDesc = extensionDesc.getExtensionDesc();
            if (launchDesc == null || launchDesc.isInstaller()) continue;
            LaunchSelection.collectJVMProperties(launchDesc.getResources(), jREMatcher);
        }
    }

    public static JREInfo selectJRE(URL uRL, String string) {
        JREDesc jREDesc = new JREDesc(string, -1L, -1L, null, uRL, new ResourcesDesc(), null);
        return LaunchSelection.selectJRE(jREDesc, new JREMatcher(), false);
    }

    public static JREInfo selectJRE(JREDesc jREDesc, JREMatcher jREMatcher, boolean bl) {
        JREInfo[] jREInfoArray = JREInfo.getValidSorted();
        if (jREInfoArray == null) {
            return null;
        }
        for (int i = 0; i < jREInfoArray.length; ++i) {
            if (!jREInfoArray[i].isEnabled() || !jREMatcher.isVersionMatch(jREInfoArray[i], jREDesc) || bl && jREInfoArray[i].getJfxRuntime() == null) continue;
            return jREInfoArray[i];
        }
        JREInfo jREInfo = JREInfo.getHomeJRE();
        if (jREMatcher.isVersionMatch(jREInfo, jREDesc) && (!bl || jREInfo.getJfxRuntime() != null)) {
            return jREInfo;
        }
        return null;
    }
}

