/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.ui.ManageSelection;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Highlighter;

public class UITextArea
extends JTextArea {
    private static final long serialVersionUID = 6512803283442088990L;
    private int preferred_width = 360;
    private Image backgroundImage = null;
    private Highlighter highlighter = null;
    private boolean isSelectable = false;

    public UITextArea() {
        JLabel jLabel = new JLabel();
        this.setBorder(new EmptyBorder(new Insets(0, 5, 0, 0)));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setFont(jLabel.getFont());
        this.setRows(0);
        this.highlighter = this.getHighlighter();
        this.setHighlighter(null);
        this.invalidate();
    }

    public UITextArea(String string) {
        this();
        this.setText(string);
    }

    public UITextArea(int n, int n2, boolean bl) {
        this();
        this.preferred_width = n2;
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont();
        Font font2 = bl ? font.deriveFont(1, n) : font.deriveFont((float)n);
        this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.setFont(font2);
        this.invalidate();
    }

    public void setSelectable() {
        this.setHighlighter(this.highlighter);
        this.isSelectable = true;
        ManageSelection manageSelection = new ManageSelection(this);
        this.addFocusListener(manageSelection);
        this.addMouseListener(manageSelection);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isSelectable;
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.invalidate();
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        boolean bl = this.backgroundImage == null;
        this.setOpaque(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.backgroundImage != null) {
            graphics.drawImage(this.backgroundImage, 0, 0, this);
        } else {
            this.setBackground(new Color(this.getParent().getBackground().getRGB()));
        }
        super.paintComponent(graphics);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        if (this.backgroundImage != null) {
            dimension = new Dimension(this.backgroundImage.getWidth(this), this.backgroundImage.getHeight(this));
        } else if (this.getRows() == 0 && this.getColumns() == 0) {
            int n = this.preferred_width / this.getColumnWidth();
            this.setColumns(n);
            dimension = super.getPreferredSize();
            this.setColumns(0);
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }
}

