/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Platform;
import com.sun.deploy.security.MSCryptoDSAPrivateKey;
import com.sun.deploy.security.MSCryptoPrivateKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class WIExplorerMyKeyStore
extends KeyStoreSpi {
    private Collection<KeyEntry> keyEntries = new ArrayList<KeyEntry>();

    @Override
    public Enumeration<String> engineAliases() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (cArray != null && cArray.length > 0) {
            throw new UnrecoverableKeyException("Password is not required for WIExplorer MY keystore.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        for (KeyEntry keyEntry : this.keyEntries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            return keyEntry.getPrivateKey();
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        for (KeyEntry keyEntry : this.keyEntries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            Certificate[] certificateArray = new X509Certificate[x509CertificateArray.length];
            System.arraycopy(x509CertificateArray, 0, certificateArray, 0, x509CertificateArray.length);
            return certificateArray;
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        for (KeyEntry keyEntry : this.keyEntries) {
            if (!string.equals(keyEntry.getAlias())) continue;
            X509Certificate[] x509CertificateArray = keyEntry.getCertificateChain();
            return x509CertificateArray[0];
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given key to the given alias.");
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        throw new KeyStoreException("Cannot assign the given certificate to the given alias.");
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        throw new KeyStoreException("WIExplorer does not support alias removal.");
    }

    public Iterator<KeyEntry> keyIterator() {
        return this.keyEntries.iterator();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        Iterator<KeyEntry> iterator = this.keyIterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().getAlias();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int engineSize() {
        return this.keyEntries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return string.startsWith("MSCryptoRSAPrivateKey") || string.startsWith("MSCryptoDSAPrivateKey");
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        for (KeyEntry keyEntry : this.keyEntries) {
            if (keyEntry.certChain == null || !keyEntry.certChain[0].equals(certificate)) continue;
            return keyEntry.getAlias();
        }
        return null;
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException("WIExplorer cert store cannot be stored into stream.");
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("authProvider.SunDeploy-MSCrypto"));
        }
        if (inputStream != null) {
            throw new IOException("WIExplorer cert store cannot be loaded from stream.");
        }
        this.keyEntries.clear();
        this.loadKeysAndCertificateChains(this.getName(), this.keyEntries);
    }

    private native void loadKeysAndCertificateChains(String var1, Collection<KeyEntry> var2);

    private void generateDSAKeyAndCertificateChain(int n, int n2, int n3, Collection<X509Certificate> collection, Collection<KeyEntry> collection2) {
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[collection.size()];
            int n4 = 0;
            Object object = collection.iterator();
            while (object.hasNext()) {
                x509CertificateArray[n4] = object.next();
                ++n4;
            }
            object = new KeyEntry(new MSCryptoDSAPrivateKey(n, n2, n3), x509CertificateArray);
            collection2.add((KeyEntry)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void generateCertificate(byte[] byArray, Collection<X509Certificate> collection) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection2 = certificateFactory.generateCertificates(byteArrayInputStream);
            for (X509Certificate x509Certificate : collection2) {
                collection.add(x509Certificate);
            }
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected String getName() {
        return "MY";
    }

    static {
        Platform.get().loadDeployNativeLib();
    }

    class KeyEntry {
        private MSCryptoPrivateKey privateKey;
        private X509Certificate[] certChain;

        KeyEntry(MSCryptoPrivateKey mSCryptoPrivateKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = mSCryptoPrivateKey;
            this.certChain = x509CertificateArray;
        }

        String getAlias() {
            return this.privateKey.toString();
        }

        Key getPrivateKey() {
            return this.privateKey;
        }

        X509Certificate[] getCertificateChain() {
            return this.certChain;
        }
    }
}

