/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Base64Wrapper;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.util.Date;

public class CachedCertificatesHelper {
    private static final boolean DEBUG = Config.getDebug();
    private final CertPath path;
    private final Date tm;
    private final boolean signedJNLP;

    public CachedCertificatesHelper(Date date, CertPath certPath) {
        this(date, certPath, false);
    }

    public CachedCertificatesHelper(Date date, CertPath certPath, boolean bl) {
        this.tm = date != null ? new Date(date.getTime()) : null;
        this.path = certPath;
        this.signedJNLP = bl;
    }

    public static CachedCertificatesHelper create(Date date, String string, boolean bl) {
        block4: {
            if (string == null) {
                return null;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                byte[] byArray = Base64Wrapper.decodeFromString(string);
                CertPath certPath = certificateFactory.generateCertPath(new ByteArrayInputStream(byArray));
                if (certPath != null) {
                    return new CachedCertificatesHelper(date, certPath, bl);
                }
            }
            catch (Exception exception) {
                String string2 = ResourceManager.getString("launch.error.embedded.cert", exception.getLocalizedMessage());
                if (!DEBUG) break block4;
                Trace.println(string2, TraceLevel.SECURITY);
            }
        }
        return null;
    }

    public boolean isSignedJNLP() {
        return this.signedJNLP;
    }

    public CertPath getCertPath() {
        return this.path;
    }

    public String exportCertificatesToBase64() {
        if (this.path != null) {
            try {
                return Base64Wrapper.encodeToString(this.path.getEncoded());
            }
            catch (Exception exception) {
                Trace.println("Failed to export certificats in BASE64 form", TraceLevel.SECURITY);
            }
        }
        return null;
    }

    public Date getTimestamp() {
        if (this.tm != null) {
            return new Date(this.tm.getTime());
        }
        return null;
    }
}

