/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheJarAccessImpl;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceProviderImpl
extends ResourceProvider {
    private SessionLoadedResourceStorage sessionLoadedResourceStorage = new SessionLoadedResourceStorage();

    @Override
    public void setBackgroundUpdateRequest(boolean bl) {
        DownloadEngine._setBackgroundUpdateRequest(bl);
    }

    @Override
    public boolean isBackgroundUpdateRequest() {
        return DownloadEngine.isBackgroundUpdateRequest();
    }

    @Override
    public int incrementInternalUse() {
        return DownloadEngine._incrementInternalUse();
    }

    @Override
    public void decrementInternalUse(int n) {
        DownloadEngine._decrementInternalUse(n);
    }

    @Override
    public boolean isUpdateAvailable(URL uRL, String string, int n, Map<String, List<String>> map) throws IOException {
        if (this.isUpdateDisabledPerPolicy()) {
            return false;
        }
        if (UpdateTracker.isUpdated(uRL.toString())) {
            return false;
        }
        URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
        if (!DownloadEngine.isBackgroundUpdateRequest() && ResourceProviderImpl.isInBackgroundUpdateCheckList(uRL)) {
            return false;
        }
        CacheEntry cacheEntry = null;
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(string == null ? uRL : uRL2, string);
        }
        if (cacheEntry == null) {
            return true;
        }
        if (string != null) {
            return false;
        }
        if (!this.isValidationRequired(cacheEntry)) {
            return false;
        }
        if (cacheEntry.getLastModified() == 0L) {
            return true;
        }
        return this.checkUpdateAvailable(uRL, cacheEntry, n, map);
    }

    @Override
    public boolean checkUpdateAvailable(URL uRL, Resource resource, int n, Map<String, List<String>> map) throws IOException {
        String string = resource.getVersion();
        if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (DeployOfflineManager.isGlobalOffline()) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, false, null);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        long l = -1L;
        l = resource.getLastModified();
        URL uRL3 = null;
        if (DownloadEngine.isPackContentType(n)) {
            uRL3 = URLUtil.getPack200URL(uRL2, false);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = map.keySet().toArray(new String[0]);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                List<String> list = map.get(stringArray[i]);
                if (list == null || !(list instanceof List)) continue;
                stringArray2[i] = list.get(0);
            }
        }
        try {
            httpResponse = httpRequest.doGetRequestEX(uRL3 != null ? uRL3 : uRL2, stringArray, stringArray2, l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (uRL3 == null) {
                throw fileNotFoundException;
            }
            httpResponse = httpRequest.doGetRequestEX(uRL2, l);
        }
        if (httpResponse == null) {
            return true;
        }
        int n2 = httpResponse.getStatusCode();
        httpResponse.disconnect();
        boolean bl = true;
        if (n2 == 304) {
            bl = false;
        } else if (n2 == 200) {
            int n3 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            if (l2 == l && n3 == resource.getContentLength()) {
                bl = false;
            }
            Trace.println("CacheEntry[" + uRL + "]: updateAvailable=" + bl + ",lastModified=" + new Date(l) + ",length=" + resource.getContentLength(), TraceLevel.DEFAULT);
        }
        if (!bl) {
            UpdateTracker.checkDone(uRL.toString());
            long l3 = HttpUtils.getEffectiveExpiration(httpResponse);
            if (l3 != 0L && resource instanceof CacheEntry) {
                ((CacheEntry)resource).updateExpirationInIndexFile(l3);
            }
        }
        return bl;
    }

    @Override
    public Resource getResource(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        return this.getResource(uRL, string, bl, n, downloadDelegate, false, null);
    }

    private Resource getFromMemory(URL uRL, String string) {
        Resource resource = null;
        Object object = MemoryCache.getLoadedResource(uRL.toString());
        if (object instanceof Resource) {
            resource = (Resource)object;
        }
        if (resource != null && CacheEntry.matchesVersionString(resource, string, true)) {
            return resource;
        }
        return null;
    }

    private Resource getResource(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate, boolean bl2, String string2) throws IOException {
        boolean bl3;
        if (uRL == null) {
            return null;
        }
        Resource resource = null;
        if (this.sessionLoadedResourceStorage.isLoaded(uRL, string)) {
            resource = this.getFromMemory(uRL, string);
            if (resource == null && Cache.isCacheEnabled()) {
                resource = Cache.getCacheEntry(uRL, string, n);
            }
            if (resource != null) {
                return resource;
            }
        }
        boolean bl4 = bl3 = bl && !DeployOfflineManager.isGlobalOffline() && this.isUpdateAvailable(uRL, string, n, null);
        if (!bl3 && (resource = this.getFromMemory(uRL, string)) != null) {
            return resource;
        }
        if (Cache.isCacheEnabled()) {
            resource = Cache.getCacheEntry(uRL, string, n);
        } else {
            Object object = MemoryCache.getLoadedResource(uRL.toString());
            if (object instanceof Resource) {
                resource = (Resource)object;
            }
        }
        if (bl && (resource == null || this.isValidationRequired(resource))) {
            resource = DownloadEngine.downloadResource(resource, uRL, string, downloadDelegate, bl2, string2, n, true);
            this.sessionLoadedResourceStorage.addLoaded(uRL, string);
            if (resource != null) {
                Trace.println("Downloaded " + uRL + ": " + resource.getResourceFilename(), TraceLevel.NETWORK);
                MemoryCache.addLoadedResource(uRL.toString(), resource);
            }
            if (resource != null && Cache.isCacheEnabled()) {
                Cache.touch(new File(resource.getResourceFilename() + Cache.getIndexFileExtension()));
            }
        }
        return resource;
    }

    @Override
    public Resource downloadUpdate(URL uRL, String string, int n, boolean bl) throws IOException {
        return DownloadEngine.downloadResource(null, uRL, string, null, false, null, n, bl);
    }

    @Override
    public void markReady(Resource[] resourceArray) throws IOException {
        for (Resource resource : resourceArray) {
            if (!(resource instanceof CacheEntry)) continue;
            CacheEntry cacheEntry = (CacheEntry)resource;
            URL uRL = new URL(cacheEntry.getURL());
            CacheEntry cacheEntry2 = Cache.getCacheEntry(uRL, cacheEntry.getVersion());
            Cache.processNewCacheEntry(uRL, true, cacheEntry, cacheEntry2);
        }
    }

    private boolean isValidationRequired(Resource resource) {
        if (!(resource instanceof CacheEntry)) {
            return true;
        }
        CacheEntry cacheEntry = (CacheEntry)resource;
        boolean bl = true;
        if (!cacheEntry.isExpired()) {
            Trace.println("Resource " + cacheEntry.getURL() + " has future expires: " + new Date(cacheEntry.getExpirationDate()) + " update check skipped.", TraceLevel.CACHE);
            bl = false;
        } else if (Trace.isEnabled(TraceLevel.CACHE)) {
            Trace.println("Resource " + cacheEntry.getURL() + " has expired.", TraceLevel.CACHE);
        }
        if (cacheEntry.isHttpNoCacheEnabled()) {
            bl = true;
            if (Trace.isEnabled(TraceLevel.CACHE)) {
                Trace.println("Resource " + cacheEntry.getURL() + " has cache control: no-cache.", TraceLevel.CACHE);
            }
        }
        return bl;
    }

    @Override
    public Resource getJreResource(URL uRL, String string, boolean bl, boolean bl2, String string2) throws IOException {
        return this.getResource(uRL, string, bl, 1, null, bl2, string2);
    }

    @Override
    public void markRetired(Resource resource, boolean bl) {
        if (!(resource instanceof CacheEntry)) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)resource;
        if (bl) {
            Cache.removeCacheEntry(cacheEntry);
        } else {
            Cache.markResourceIncomplete(cacheEntry);
        }
    }

    @Override
    public File getShortcutImage(URL uRL, String string, boolean bl) throws IOException {
        Resource resource = this.getResource(uRL, string, bl, 1, null, false, null);
        if (resource instanceof CacheEntry) {
            ((CacheEntry)resource).generateShortcutImage();
            return resource.getDataFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLibraryDirForJar(String string, URL uRL, String string2) throws IOException {
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            File file;
            Resource resource = this.getCachedResource(uRL, string2);
            if (resource == null) {
                resource = this.getResource(uRL, string2, true, 272, null);
            }
            File file2 = file = resource != null ? resource.getDataFile() : null;
            if (file != null) {
                String string3 = file.getPath() + "-n";
                File file3 = new File(string3, string);
                Trace.println("Looking up native library in: " + file3, TraceLevel.CACHE);
                if (file3.exists()) {
                    String string4 = string3;
                    return string4;
                }
            }
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n);
        }
        return null;
    }

    @Override
    public Resource getSystemResource(URL uRL, String string) {
        return Cache.getSystemCacheEntry(uRL, string);
    }

    @Override
    public boolean isInternalUse() {
        return DownloadEngine.isInternalUse();
    }

    @Override
    public void decrementsInternalUse(int n) {
        DownloadEngine._decrementInternalUse(n);
    }

    @Override
    public LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, boolean bl) {
        return Cache.getLocalApplicationProperties(uRL, string, bl);
    }

    @Override
    public boolean canCache(URL uRL) {
        if (uRL == null) {
            return Cache.isCacheEnabled();
        }
        if (Cache.isCacheEnabled() && Cache.isSupportedProtocol(uRL)) {
            boolean bl = HttpUtils.resourceNotCached(uRL.toString());
            return !bl;
        }
        return false;
    }

    @Override
    public File getCacheDir() {
        return Cache.getCacheDir();
    }

    @Override
    public String getCurrentVersion(URL uRL) {
        return Cache.getCacheEntryVersion(uRL);
    }

    @Override
    public ResourceObject getResourceObject(String string) {
        String string2 = string + ".idx";
        File file = new File(string2);
        final CacheEntry cacheEntry = Cache.getCacheEntryFromFileIncludeTempJNLP(file);
        if (cacheEntry == null) {
            return null;
        }
        if (!cacheEntry.isJNLPFile() && cacheEntry.getJarFile() instanceof ResourceObject) {
            return (ResourceObject)((Object)cacheEntry.getJarFile());
        }
        return new ResourceObject(){

            @Override
            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            @Override
            public URL getResourceURL() {
                try {
                    return new URL(cacheEntry.getURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored(malformedURLException);
                    return null;
                }
            }

            @Override
            public String getResourceVersion() {
                return cacheEntry.getVersion();
            }

            @Override
            public void doClose() throws IOException {
                this.close();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    @Override
    public DeployCacheJarAccess getJarAccess() {
        return DeployCacheJarAccessImpl.getJarAccess();
    }

    @Override
    public boolean hasEnhancedJarAccess() {
        return CacheEntry.hasEnhancedJarAccess();
    }

    @Override
    public String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        return Cache.getCachedResourceFilePath(uRL, string);
    }

    private static class SessionLoadedResourceStorage
    implements SessionState.Client {
        private Set<Pair> storage = new HashSet<Pair>();
        private final String STORAGE_FILE_NAME = "sessionLoadedResourceStorage";

        public SessionLoadedResourceStorage() {
            SessionState.register(this);
        }

        @Override
        public synchronized void importState(File file) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(file, "sessionLoadedResourceStorage"));
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                this.storage = (Set)objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }

        @Override
        public synchronized void exportState(File file) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "sessionLoadedResourceStorage"));
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(this.storage);
                objectOutputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
        }

        public synchronized boolean isLoaded(URL uRL, String string) {
            return this.storage.contains(new Pair(uRL, string));
        }

        public synchronized void addLoaded(URL uRL, String string) {
            this.storage.add(new Pair(uRL, string));
        }

        private static class Pair
        implements Serializable {
            private static final long serialVersionUID = 3823723107031361215L;
            private String location;
            private String version;

            public String toString() {
                return "Pair{location=" + this.location + ", version=" + this.version + '}';
            }

            public Pair(URL uRL, String string) {
                this.location = uRL != null ? uRL.toString() : null;
                this.version = string;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Pair pair = (Pair)object;
                if (this.location != null ? !this.location.equals(pair.location) : pair.location != null) {
                    return false;
                }
                return !(this.version != null ? !this.version.equals(pair.version) : pair.version != null);
            }

            public int hashCode() {
                int n = this.location != null ? this.location.hashCode() : 0;
                n = 31 * n + (this.version != null ? this.version.hashCode() : 0);
                return n;
            }
        }
    }
}

