/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SessionState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Properties;
import java.util.PropertyPermission;

public class SessionProperties
extends Properties
implements SessionState.Client {
    private static final long serialVersionUID = 497074925397848464L;
    private String _filename;
    private static final AccessControlContext ACC_SESSION_INSTANCE;

    public SessionProperties(String string) {
        this._filename = string;
    }

    @Override
    public void importState(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block6: {
                        try {
                            File file2 = new File(file, SessionProperties.this._filename);
                            if (!file2.exists()) break block6;
                            try (FileInputStream fileInputStream = new FileInputStream(file2);){
                                SessionProperties.this.load(fileInputStream);
                            }
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                    }
                    return null;
                }
            }, ACC_SESSION_INSTANCE);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    @Override
    public void exportState(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    block6: {
                        try {
                            File file2 = new File(file, SessionProperties.this._filename);
                            file.mkdirs();
                            FileOutputStream fileOutputStream = new FileOutputStream(file2);
                            if (fileOutputStream == null) break block6;
                            try {
                                SessionProperties.this.store(fileOutputStream, "Session Data");
                            }
                            finally {
                                if (fileOutputStream != null) {
                                    fileOutputStream.flush();
                                    fileOutputStream.close();
                                }
                            }
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                    }
                    return null;
                }
            }, ACC_SESSION_INSTANCE);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)permissions).add(filePermission);
        PropertyPermission propertyPermission = new PropertyPermission("*", "read,write");
        ((PermissionCollection)permissions).add(propertyPermission);
        ACC_SESSION_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }
}

