/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.BasicPermissionCollection;
import java.net.URI;
import java.net.URL;
import java.security.BasicPermission;
import java.security.PermissionCollection;

public final class SecureCookiePermission
extends BasicPermission {
    private static final long serialVersionUID = 1769533200015971019L;
    static String ORIGIN_PREFIX = "origin.";

    public SecureCookiePermission(String string) {
        super(string);
    }

    public SecureCookiePermission(URI uRI) {
        super(SecureCookiePermission.getURIOriginString(uRI));
    }

    public SecureCookiePermission(String string, String string2) {
        super(string, string2);
    }

    public static String getURIOriginString(URI uRI) {
        if (uRI == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(ORIGIN_PREFIX);
        stringBuffer.append(uRI.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(uRI.getHost());
        stringBuffer.append(":");
        int n = uRI.getPort();
        if (n == -1) {
            try {
                n = uRI.toURL().getDefaultPort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static String getURLOriginString(URL uRL) {
        if (uRL == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(ORIGIN_PREFIX);
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(":");
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }
}

