/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;

public final class DeploySigningCertStore
implements CertStore {
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private static String _sandboxFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private long _sandLastModified = 0L;
    private KeyStore _deploymentUserCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSandboxCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPassphrase = new char[0];
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    private DeploySigningCertStore(int n) {
        this.certStoreType = n;
    }

    public static CertStore getCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(3));
    }

    public static CertStore getUserCertStore() {
        return new DeploySigningCertStore(1);
    }

    public static CertStore getSystemCertStore() {
        return new ImmutableCertStore(new DeploySigningCertStore(2));
    }

    public static CertStore getSandboxCertStore() {
        return new DeploySigningCertStore(4);
    }

    public static boolean checkStoredCertificates(int n, int n2, boolean bl, boolean bl2) {
        DeploySigningCertStore deploySigningCertStore = new DeploySigningCertStore(n);
        try {
            deploySigningCertStore.load();
            return deploySigningCertStore.checkCertificateTimestamps(n2, bl, bl2);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
            return false;
        }
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long l;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (l = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserCerts = this.loadCertStore(_userFilename, bl);
            this._userLastModified = l;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (l = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemCerts = this.loadCertStore(_systemFilename, bl);
            this._sysLastModified = l;
        }
        if ((this.certStoreType & 4) == 4 && _sandboxFilename != null && (l = CertUtils.getFileLastModified(_sandboxFilename)) != this._sandLastModified) {
            this._deploymentSandboxCerts = this.loadCertStore(_sandboxFilename, bl);
            this._sandLastModified = l;
        }
    }

    private boolean checkCertificateTimestamps(long l, boolean bl, boolean bl2) {
        KeyStore keyStore = null;
        if (this.certStoreType == 1) {
            keyStore = this._deploymentUserCerts;
        } else if (this.certStoreType == 4) {
            keyStore = this._deploymentSandboxCerts;
        } else {
            return false;
        }
        if (bl && bl2) {
            return false;
        }
        Date date = new Date();
        ArrayList<Object> arrayList = new ArrayList();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            if (l == 0L && enumeration.hasMoreElements()) {
                if (!bl && !bl2) {
                    return true;
                }
                arrayList = Collections.list(enumeration);
            } else {
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    long l2 = keyStore.getCreationDate(string).getTime();
                    if (date.getTime() - l2 <= l * 24L * 60L * 60L * 1000L) continue;
                    if (!bl && !bl2) {
                        return true;
                    }
                    arrayList.add(string);
                }
            }
            for (String string : arrayList) {
                if (bl) {
                    keyStore.deleteEntry(string);
                    continue;
                }
                Certificate certificate = keyStore.getCertificate(string);
                keyStore.setCertificateEntry(string, certificate);
            }
            if (!arrayList.isEmpty()) {
                this.save();
                return true;
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        return false;
    }

    private KeyStore loadCertStore(String string, final boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("deploycertstore.cert.loading", new Object[]{string});
        final File file = new File(string);
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        if (bl) {
                            DeploySigningCertStore.this.cancelFlag = false;
                            keyStore.load(bufferedInputStream, new char[0]);
                        } else {
                            keyStore.load(bufferedInputStream, null);
                        }
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                if (bl) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    CredentialInfo credentialInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getString("password.dialog.title"), ResourceManager.getString("deploycertstore.password.dialog.text"), false, false, null, false, null);
                    if (credentialInfo != null) {
                        this.cancelFlag = false;
                        this.keyPassphrase = credentialInfo.getPassword();
                        keyStore.load(bufferedInputStream, this.keyPassphrase);
                    } else {
                        this.cancelFlag = true;
                    }
                    bufferedInputStream.close();
                    fileInputStream.close();
                }
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        final String string = this.certStoreType == 4 ? _sandboxFilename : _userFilename;
        final KeyStore keyStore = this.certStoreType == 4 ? this._deploymentSandboxCerts : this._deploymentUserCerts;
        Trace.msgSecurityPrintln("deploycertstore.cert.saving", new Object[]{string});
        try {
            if (Platform.get().isNativeSandbox()) {
                File file = new File(string);
                OutputStream outputStream = Platform.get().getNativeSandboxBroker().getOutputStream(file, false);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                keyStore.store(bufferedOutputStream, this.keyPassphrase);
                bufferedOutputStream.close();
                outputStream.close();
            } else {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                        File file = new File(string);
                        file.getParentFile().mkdirs();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        keyStore.store(bufferedOutputStream, DeploySigningCertStore.this.keyPassphrase);
                        bufferedOutputStream.close();
                        fileOutputStream.close();
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.saved", new Object[]{string});
    }

    @Override
    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    @Override
    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        KeyStore keyStore;
        String string2;
        if (this.certStoreType == 4) {
            string2 = "deploymentsandboxcert";
            keyStore = this._deploymentSandboxCerts;
        } else {
            string2 = "deploymentusercert";
            keyStore = this._deploymentUserCerts;
        }
        return CertUtils.add(keyStore, string2, certificate, string, bl);
    }

    @Override
    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        if (this.cancelFlag) {
            return false;
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removing");
        KeyStore keyStore = this.certStoreType == 4 ? this._deploymentSandboxCerts : this._deploymentUserCerts;
        String string = keyStore.getCertificateAlias(certificate);
        if (string != null) {
            keyStore.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("deploycertstore.cert.removed", new Object[]{string});
        return true;
    }

    @Override
    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    @Override
    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        if (this.certStoreType == 4) {
            return CertUtils.contains(this._deploymentSandboxCerts, certificate, string, bl);
        }
        return CertUtils.contains(this._deploymentUserCerts, certificate, string, bl) || CertUtils.contains(this._deploymentSystemCerts, certificate, string, bl);
    }

    @Override
    public boolean verify(Certificate certificate) {
        Trace.msgSecurityPrintln("deploycertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        if ((this.certStoreType & 1) == 1) {
            hashSet.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            hashSet.addAll(this.getCertificates(2));
        }
        if ((this.certStoreType & 4) == 4) {
            hashSet.addAll(this.getCertificates(4));
        }
        return hashSet;
    }

    private Collection<X509Certificate> getCertificates(int n) throws KeyStoreException {
        Trace.msgSecurityPrintln("deploycertstore.cert.getcertificates");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        KeyStore keyStore = null;
        keyStore = n == 4 ? this._deploymentSandboxCerts : (n == 1 ? this._deploymentUserCerts : this._deploymentSystemCerts);
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            treeSet.add(string);
        }
        for (String string : treeSet) {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    static {
        _userFilename = Config.getUserTrustedCertificateFile();
        _systemFilename = Config.getSystemTrustedCertificateFile();
        _sandboxFilename = Config.getSandboxTrustedCertificateFile();
    }
}

