/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.AuthCacheBridge;
import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public class CredentialManager {
    public static final long LOGIN_SESSION_INVALID = -1L;
    private static final String DELIM = ",";
    static CredentialManager instance = null;
    private CredentialCache credCache = new CredentialCache();
    private CredentialPersistor persistor = new CredentialPersistor();
    private Map<String, CredentialInfo> serverMap = CredentialPersistor.access$000(this.persistor);
    private SessionProperties sessionProps = new SessionProperties("session.credentials");
    private static final AccessControlContext ACC_FILE_INSTANCE;

    CredentialManager() {
        SessionState.register(this.sessionProps);
        if (!this.sessionProps.isEmpty()) {
            Set<String> set = this.sessionProps.stringPropertyNames();
            for (String string : set) {
                String string2 = this.sessionProps.getProperty(string);
                try {
                    String[] stringArray = string.split(DELIM, 3);
                    if (stringArray.length != 3) continue;
                    CredentialInfo credentialInfo = new CredentialInfo();
                    credentialInfo.setUserName(new String(Base64Wrapper.decodeFromString(stringArray[0])));
                    credentialInfo.setDomain(new String(Base64Wrapper.decodeFromString(stringArray[1])));
                    credentialInfo.setSessionId(this.getLoginSessionId());
                    credentialInfo.setPassword(this.decryptPassword(Base64Wrapper.decodeFromString(string2)));
                    this.serverMap.put(new String(Base64Wrapper.decodeFromString(stringArray[2])), credentialInfo);
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        }
        if (this.persistor.getSavedCredentialCount() > this.serverMap.size()) {
            this.persistor.persistAllCredentials(this.serverMap);
        }
        AuthCacheValue.setAuthCache((AuthCache)this.credCache);
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new CredentialManager();
        }
        return instance;
    }

    protected long getLoginSessionId() {
        return -1L;
    }

    protected boolean isPasswordEncryptionSupported() {
        return false;
    }

    protected boolean isPasswordStorageSupported() {
        return this.isPasswordEncryptionSupported();
    }

    protected byte[] encryptPassword(char[] cArray) {
        return new byte[0];
    }

    protected char[] decryptPassword(byte[] byArray) {
        return new char[0];
    }

    public void saveCredential(AuthKey authKey, CredentialInfo credentialInfo) {
        credentialInfo.setSessionId(this.getLoginSessionId());
        CredentialInfo credentialInfo2 = (CredentialInfo)credentialInfo.clone();
        String string = CredentialManager.buildConnectionKey(authKey);
        if (this.isPasswordEncryptionSupported()) {
            byte[] byArray = this.encryptPassword(credentialInfo.getPassword());
            if (credentialInfo2.isPasswordSaveApproved()) {
                credentialInfo2.setEncryptedPassword(byArray);
            } else if (byArray.length > 0) {
                String string2 = credentialInfo2.getUserName();
                String string3 = string2 == null ? "" : Base64Wrapper.encodeToString(string2.getBytes());
                String string4 = credentialInfo2.getDomain();
                String string5 = string4 == null ? "" : Base64Wrapper.encodeToString(string4.getBytes());
                String string6 = Base64Wrapper.encodeToString(string.getBytes());
                String string7 = this.escapeForPropertyKey(string3 + DELIM + string5 + DELIM + string6);
                String string8 = Base64Wrapper.encodeToString(byArray);
                this.sessionProps.setProperty(string7, string8);
            }
        } else {
            credentialInfo2.setPassword(null);
        }
        this.serverMap.put(string, credentialInfo2);
        this.persistor.persistCredential(string);
    }

    private String escapeForPropertyKey(String string) {
        return string.replaceAll("=", "\\=");
    }

    public boolean isCredentialValid(CredentialInfo credentialInfo) {
        boolean bl = false;
        if (credentialInfo.getUserName().length() > 0 && credentialInfo.getPassword().length > 0 && credentialInfo.getSessionId() != -1L && credentialInfo.getSessionId() == this.getLoginSessionId()) {
            bl = true;
        }
        return bl;
    }

    public static void removePersistantCredentials() {
        try {
            File file = new File(Config.getUserAuthFile());
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
    }

    public void clearCredentialPassword(AuthKey authKey) {
        String string = CredentialManager.buildConnectionKey(authKey);
        CredentialInfo credentialInfo = this.findServerCredential(string);
        if (!this.serverMap.containsKey(string) && credentialInfo != null) {
            credentialInfo.setPassword(null);
            this.saveCredential(authKey, credentialInfo);
        }
        this.persistor.persistCredential(string);
    }

    protected CredentialInfo getCredential(AuthKey authKey) {
        byte[] byArray;
        String string = CredentialManager.buildConnectionKey(authKey);
        CredentialInfo credentialInfo = this.serverMap.get(string);
        if ((credentialInfo == null || credentialInfo != null && credentialInfo.isCredentialEmpty()) && (credentialInfo = this.findServerCredential(string)) == null) {
            credentialInfo = new CredentialInfo();
        }
        if (credentialInfo.getPassword().length == 0 && (byArray = credentialInfo.getEncryptedPassword()).length > 0) {
            credentialInfo.setPassword(this.decryptPassword(byArray));
        }
        return credentialInfo;
    }

    private CredentialInfo findServerCredential(String string) {
        Set<String> set = this.serverMap.keySet();
        for (String string2 : set) {
            CredentialInfo credentialInfo;
            if (!CredentialManager.getServerFromKey(string).equals(CredentialManager.getServerFromKey(string2)) || (credentialInfo = this.serverMap.get(string2)) == null || credentialInfo.isCredentialEmpty() || credentialInfo.getPassword().length <= 0 && credentialInfo.getEncryptedPassword().length <= 0) continue;
            return credentialInfo;
        }
        return null;
    }

    private static String getServerFromKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        return stringTokenizer.nextToken();
    }

    public static String buildConnectionKey(AuthKey authKey) {
        StringBuffer stringBuffer = new StringBuffer();
        if (authKey.isProxy()) {
            stringBuffer.append("p:");
        } else {
            stringBuffer.append("s:");
        }
        stringBuffer.append(authKey.getProtocolScheme());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getHost());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getPort());
        stringBuffer.append(':');
        stringBuffer.append(authKey.getPath());
        return stringBuffer.toString().toLowerCase();
    }

    static {
        Permissions permissions = new Permissions();
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)permissions).add(filePermission);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    private class CredentialPersistor {
        private int credentialCount = 0;

        private int getSavedCredentialCount() {
            return this.credentialCount;
        }

        private synchronized void persistCredential(String string) {
            ObjectOutputStream objectOutputStream = null;
            try {
                CredentialInfo credentialInfo = (CredentialInfo)CredentialManager.this.serverMap.get(string);
                if (credentialInfo != null) {
                    OutputStream outputStream = this.openOutputFile(true);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    objectOutputStream.writeObject(string);
                    credentialInfo.writeExternal(objectOutputStream);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        private synchronized void deleteCredentials() {
            try {
                File file = new File(Config.getUserAuthFile());
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void persistAllCredentials(Map<String, CredentialInfo> map) {
            ObjectOutputStream objectOutputStream = null;
            OutputStream outputStream = null;
            try {
                outputStream = this.openOutputFile(false);
                Set<String> set = map.keySet();
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    objectOutputStream = new ObjectOutputStream(outputStream);
                    String string = iterator.next();
                    CredentialInfo credentialInfo = map.get(string);
                    objectOutputStream.writeObject(string);
                    credentialInfo.writeExternal(objectOutputStream);
                    objectOutputStream.flush();
                }
            }
            catch (Throwable throwable) {
                Trace.securityPrintException(throwable);
            }
            finally {
                try {
                    if (objectOutputStream != null) {
                        objectOutputStream.flush();
                    }
                    outputStream.flush();
                    outputStream.close();
                }
                catch (Exception exception) {
                    Trace.securityPrintException(exception);
                }
            }
        }

        private synchronized void getPersistedCredential(ObjectInputStream objectInputStream, String string) {
            try {
                CredentialInfo credentialInfo = new CredentialInfo();
                credentialInfo.readExternal(objectInputStream);
                CredentialManager.this.serverMap.put(string, credentialInfo);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }

        private synchronized InputStream openInputStream() {
            InputStream inputStream = null;
            try {
                final File file = new File(Config.getUserAuthFile());
                inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        return new BufferedInputStream(new FileInputStream(file));
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
            return inputStream;
        }

        private synchronized OutputStream openOutputFile(final boolean bl) {
            OutputStream outputStream = null;
            try {
                final File file = new File(Config.getUserAuthFile());
                outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                    @Override
                    public OutputStream run() throws IOException {
                        if (!file.exists()) {
                            file.getParentFile().mkdirs();
                            file.createNewFile();
                        }
                        return new BufferedOutputStream(new FileOutputStream(file, bl));
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
            return outputStream;
        }

        private synchronized Map<String, CredentialInfo> getAllPersistedCredentials() {
            ObjectInputStream objectInputStream = null;
            InputStream inputStream = null;
            HashMap<String, CredentialInfo> hashMap = null;
            try {
                hashMap = new HashMap<String, CredentialInfo>();
                inputStream = this.openInputStream();
                objectInputStream = new ObjectInputStream(inputStream);
                while (objectInputStream != null) {
                    String string = (String)objectInputStream.readObject();
                    CredentialInfo credentialInfo = new CredentialInfo();
                    credentialInfo.readExternal(objectInputStream);
                    hashMap.put(string, credentialInfo);
                    ++this.credentialCount;
                    objectInputStream = new ObjectInputStream(inputStream);
                }
                inputStream.close();
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
                try {
                    inputStream.close();
                    if (this.credentialCount > 0) {
                        this.persistAllCredentials(hashMap);
                    }
                }
                catch (Exception exception2) {
                    Trace.securityPrintException(exception);
                }
            }
            return hashMap;
        }

        static /* synthetic */ Map access$000(CredentialPersistor credentialPersistor) {
            return credentialPersistor.getAllPersistedCredentials();
        }
    }

    private class CredentialCache
    extends AuthCacheImpl {
        HashMap<String, LinkedList<AuthCacheValue>> map = new HashMap();

        public CredentialCache() {
            this.setMap(this.map);
        }

        @Override
        public void remove(String string, AuthCacheValue authCacheValue) {
            try {
                super.remove(string, authCacheValue);
                AuthKey authKey = AuthCacheBridge.create(authCacheValue);
                CredentialManager.getInstance().clearCredentialPassword(authKey);
            }
            catch (Exception exception) {
                Trace.securityPrintException(exception);
            }
        }
    }
}

