/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.applet2.preloader.CancelException;
import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.Resource;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.CanceledDownloadException;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.MessageHeader;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_JFX_VERSION_ID = "jfx-version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    private static InheritableThreadLocal<Boolean> backgroundUpdateThreadLocal;
    private static ThreadLocal<Boolean> processingState;
    private static final ThreadLocal<Integer> internalUse;
    private static Hashtable<String, URL> redirectURLs;
    private static Hashtable<String, String> knownRedirectHostTable;

    public static boolean haveDownloadInProgress() {
        return processingState.get() != null;
    }

    private static void setDownloadInProgress(boolean bl) {
        if (bl) {
            processingState.set(Boolean.TRUE);
        } else {
            processingState.set(null);
        }
    }

    public static boolean isBackgroundUpdateRequest() {
        return (Boolean)backgroundUpdateThreadLocal.get();
    }

    public static void _setBackgroundUpdateRequest(boolean bl) {
        backgroundUpdateThreadLocal.set(bl);
    }

    public static int _incrementInternalUse() {
        int n = DownloadEngine.getInternalUseLevel() + 1;
        SystemUtils.setThreadLocalInt(internalUse, n);
        return n;
    }

    public static void _decrementInternalUse(int n) {
        int n2 = DownloadEngine.getInternalUseLevel();
        if (n2 != n) {
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.ignored(new Exception("WARNING: unbalanced internalUse level: expect=" + n + " : got=" + n2));
            }
            n2 = n;
        }
        --n2;
        if (n2 < 0) {
            n2 = 0;
        }
        SystemUtils.setThreadLocalInt(internalUse, n2);
    }

    public static boolean isInternalUse() {
        return DownloadEngine.getInternalUseLevel() > 0;
    }

    private static int getInternalUseLevel() {
        return SystemUtils.getThreadLocalInt(internalUse);
    }

    public static boolean isNativeContentType(int n) {
        return DownloadEngine.hasBit(n, 16);
    }

    public static boolean isJarContentType(int n) {
        return DownloadEngine.hasBit(n, 256);
    }

    public static boolean isPackContentType(int n) {
        return DownloadEngine.hasBit(n, 4096);
    }

    private static boolean isVersionContentType(int n) {
        return DownloadEngine.hasBit(n, 65536);
    }

    private static boolean hasBit(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".jar") || string2.endsWith(".jarjar") || string2.endsWith(".zip");
    }

    static void createRedirectURLEntry(String string, URL uRL) {
        redirectURLs.put(string, uRL);
    }

    public static URL getRedirectURL(URL uRL) {
        return redirectURLs.get(uRL.toString());
    }

    public static void addKnownRedirectHost(String string, String string2) {
        knownRedirectHostTable.put(string, string2);
    }

    public static boolean isKnownRedirectedHost(String string, String string2) {
        String string3 = knownRedirectHostTable.get(string);
        return string2.equals(string3);
    }

    public static URL getKnownRedirectFinalURL(URL uRL) {
        URL uRL2 = null;
        Object object = MemoryCache.getLoadedResource(uRL.toString());
        if (object instanceof Resource) {
            try {
                uRL2 = new URL(((Resource)object).getURL());
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
            }
        }
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static void clearRedirectURLs() {
        redirectURLs.clear();
    }

    private static Resource downloadResourceToTempDir(URL uRL, String string, URL uRL2, HttpResponse httpResponse, HttpDownloadListener httpDownloadListener, int n, DownloadDelegate downloadDelegate) throws IOException {
        boolean bl = DownloadEngine.isJarContentType(n);
        String string2 = bl ? "jar_cache" : "tmp_cache";
        File file = File.createTempFile(string2, null);
        file.deleteOnExit();
        String string3 = httpResponse.getContentEncoding();
        if (DownloadEngine.isPackContentType(n)) {
            string3 = "pack200-gzip";
        }
        boolean bl2 = DownloadEngine.isInternalUse();
        try {
            BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
            MessageHeader messageHeader = DownloadEngine.getHttpDownloadImpl().download(httpResponse.getContentLength(), httpResponse.getRequest(), bufferedInputStream, string3, file, httpDownloadListener, n, bl2);
            messageHeader = MessageHeader.merge(httpResponse.getHeaders(), messageHeader);
            if (!bl) {
                bl = HttpUtils.isJarFile(uRL.toString(), messageHeader.getHeaders());
            }
            Resource resource = DownloadEngine.createTemporaryResource(uRL, string, uRL2, bl, httpResponse, file, messageHeader, downloadDelegate);
            return resource;
        }
        catch (CanceledDownloadException canceledDownloadException) {
            throw new IOException(canceledDownloadException.getLocalizedMessage());
        }
        finally {
            httpResponse.disconnect();
        }
    }

    private static Resource createTemporaryResource(final URL uRL, final String string, URL uRL2, final boolean bl, final HttpResponse httpResponse, final File file, MessageHeader messageHeader, DownloadDelegate downloadDelegate) throws IOException {
        if (uRL == null || file == null) {
            return null;
        }
        final Map<Object, Object> map = messageHeader != null ? messageHeader.getHeaders() : Collections.emptyMap();
        final JarFile jarFile = bl ? JarVerifier.getValidatedJarFile(file, uRL, uRL2, string, downloadDelegate) : null;
        final long l = System.currentTimeMillis();
        return new Resource(){
            JarSigningData jarSigningData = null;

            @Override
            public String getURL() {
                return uRL.toString();
            }

            @Override
            public String getVersion() {
                return string;
            }

            @Override
            public long getLastModified() {
                return httpResponse == null ? 0L : httpResponse.getLastModified();
            }

            @Override
            public long getExpirationDate() {
                return httpResponse == null ? 0L : httpResponse.getExpiration();
            }

            @Override
            public int getContentLength() {
                return httpResponse == null ? 0 : httpResponse.getContentLength();
            }

            @Override
            public Map<String, List<String>> getHeaders() {
                return map;
            }

            @Override
            public long getSize() {
                Long l2 = AccessController.doPrivileged(new PrivilegedAction<Long>(){

                    @Override
                    public Long run() {
                        return file.length();
                    }
                });
                return l2;
            }

            @Override
            public File getDataFile() {
                return file;
            }

            @Override
            public int getState() {
                return 1;
            }

            @Override
            public JarFile getJarFile() {
                return jarFile;
            }

            public long getValidationTimestamp() {
                return l;
            }

            @Override
            public String getResourceFilename() {
                return file.getPath();
            }

            @Override
            public boolean isJNLPFile() {
                return false;
            }

            @Override
            public boolean isJarFile() {
                return bl;
            }

            @Override
            public CodeSigner[] getCodeSigners() {
                JarSigningData jarSigningData = this.getJarSigningData();
                if (jarSigningData != null) {
                    return jarSigningData.getCodeSigners();
                }
                return new CodeSigner[0];
            }

            @Override
            public Certificate[] getCertificates() {
                JarSigningData jarSigningData = this.getJarSigningData();
                if (jarSigningData != null) {
                    return jarSigningData.getCertificates();
                }
                return new Certificate[0];
            }

            private JarSigningData getJarSigningData() {
                JarVerifier jarVerifier;
                if (this.jarSigningData == null && (jarVerifier = JarVerifier.create(uRL, string, file, null)) != null) {
                    try {
                        jarVerifier.validate(null);
                        this.jarSigningData = JarSigningData.create(jarVerifier);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                return this.jarSigningData;
            }
        };
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    public static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate, String string2) throws FailedDownloadException {
        JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
        File file3 = new File(string2);
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            outputStream = Platform.get().getNativeSandboxBroker().getOutputStream(file3, true);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    @Override
                    public void patching(int n) throws CancelException {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new FailedDownloadException(uRL, string, iOException);
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw new FailedDownloadException(uRL, string, iOException);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (!bl) {
                Platform.get().getNativeSandboxBroker().deleteFile(file3);
            }
            Platform.get().getNativeSandboxBroker().deleteFile(file2);
            if (downloadDelegate != null && !bl) {
                try {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                catch (CancelException cancelException) {
                    throw new FailedDownloadException(uRL, string, cancelException);
                }
            }
        }
        return file3;
    }

    public static boolean isJnlpURL(URL uRL) {
        try {
            HttpResponse httpResponse = DownloadEngine.getHttpRequestImpl().doHeadRequest(uRL);
            return JNLP_MIME_TYPE.equals(httpResponse.getContentType());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static Resource actionDownload(Resource resource, final URL uRL, URL uRL2, String string, final DownloadDelegate downloadDelegate, int n, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = false;
        int n2 = -1;
        String string2 = null;
        if (resource != null && string != null) {
            long l;
            if (resource.getVersion() != null && new VersionString(string).contains(new VersionID(resource.getVersion()))) {
                return resource;
            }
            if (Environment.isJavaPlugin() && (l = resource.getExpirationDate()) != 0L && new Date().after(new Date(l))) {
                resource = null;
            }
        }
        if (resource != null) {
            string2 = resource.getVersion();
        }
        try {
            int n3;
            Object object;
            boolean bl4;
            Object object2;
            DownloadEngine.setDownloadInProgress(true);
            HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
            HttpResponse httpResponse = null;
            long l = 0L;
            if (resource != null) {
                l = resource.getLastModified();
            }
            URL uRL3 = uRL2;
            if (DownloadEngine.isVersionContentType(n)) {
                uRL3 = URLUtil.getEmbeddedVersionURL(uRL3, string);
            }
            if (DownloadEngine.isPackContentType(n)) {
                uRL3 = URLUtil.getPack200URL(uRL3, false);
            }
            try {
                try {
                    httpResponse = httpRequest.doGetRequestEX(uRL3, l);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (uRL2.toString().equals(uRL3.toString())) {
                        throw fileNotFoundException;
                    }
                    httpResponse = httpRequest.doGetRequestEX(uRL2, l);
                    bl3 = true;
                    n2 = n;
                    if (DownloadEngine.isPackContentType(n) && (DownloadEngine.isNativeContentType(n) || DownloadEngine.isJarContentType(n))) {
                        n2 &= 0xFFFFEFFF;
                    }
                    if (DownloadEngine.isVersionContentType(n)) {
                        n2 &= 0xFFFEFFFF;
                    }
                }
            }
            catch (FailedDownloadException failedDownloadException) {
                throw failedDownloadException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                httpResponse = httpRequest.doGetRequest(uRL2, false);
            }
            int n4 = httpResponse.getStatusCode();
            if (n4 == 404) {
                throw new FailedDownloadException(uRL, string, new IOException("HTTP response 404"));
            }
            if (n4 == 304) {
                httpResponse.disconnect();
                Resource resource2 = resource;
                return resource2;
            }
            int n5 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            long l3 = httpResponse.getExpiration();
            boolean bl5 = HttpUtils.isJNLPFile(uRL.toString(), httpResponse.getHeaders());
            if (!bl5 && Environment.isImportMode() && Environment.getImportModeExpiration() != null && l3 != 0L) {
                object2 = new Date(l3);
                if (((Date)object2).before(Environment.getImportModeExpiration())) {
                    httpResponse.disconnect();
                    Resource resource3 = null;
                    return resource3;
                }
            } else if (!bl5 && Environment.isImportMode() && Environment.getImportModeTimestamp() != null && l2 != 0L && ((Date)(object2 = new Date(l2))).before(Environment.getImportModeTimestamp())) {
                httpResponse.disconnect();
                Resource resource4 = null;
                return resource4;
            }
            object2 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            if (string != null && object2 == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(string).isSimpleVersion()) {
                object2 = string;
            }
            if (resource != null) {
                if (object2 != null && new VersionString((String)object2).contains(string2)) {
                    httpResponse.disconnect();
                    Resource resource5 = resource;
                    return resource5;
                }
                if (n5 == resource.getContentLength() && l2 == l && string2 == null) {
                    httpResponse.disconnect();
                    Resource resource6 = resource;
                    return resource6;
                }
            }
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n5);
            }
            if (object2 == null && (Environment.isJavaPlugin() || DownloadEngine.isVersionContentType(bl3 ? n2 : n))) {
                object2 = string;
            }
            Object object3 = object2;
            String string3 = httpResponse.getContentType();
            boolean bl6 = bl4 = string3 != null && string3.equalsIgnoreCase(JARDIFF_MIME_TYPE);
            if (Trace.isEnabled(TraceLevel.NETWORK)) {
                Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(n5), new Date(l2).toString(), object2, string3), TraceLevel.NETWORK);
            }
            if (string3 != null && string3.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string4 = bufferedReader.readLine();
                bufferedReader.close();
                throw new FailedDownloadException(uRL2, string, new IOException("Error returned: " + string4));
            }
            if (object2 == null && string != null && !DownloadEngine.isVersionContentType(bl3 ? n2 : n)) {
                throw new FailedDownloadException(uRL, string, new IOException("missing version response from server"));
            }
            if (object2 != null && string != null && !bl) {
                if (!new VersionString(string).contains((String)object2)) {
                    throw new FailedDownloadException(uRL, string, new IOException("bad version response from server:" + (String)object2));
                }
                object = new VersionID((String)object2);
                if (!((VersionID)object).isSimpleVersion()) {
                    throw new FailedDownloadException(uRL, string, new IOException("bad version response from server:" + (String)object2));
                }
            }
            Object object4 = object = downloadDelegate == null ? null : new HttpDownloadListener((String)object3){
                final /* synthetic */ String val$responseVersion;
                {
                    this.val$responseVersion = string;
                }

                @Override
                public boolean downloadProgress(int n, int n2) throws CancelException {
                    downloadDelegate.downloading(uRL, this.val$responseVersion, n, n2, false);
                    return true;
                }
            };
            if (bl5 && !Cache.isCacheEnabled()) {
                bl2 = false;
            }
            int n6 = n3 = bl3 ? n2 : n;
            if (bl2) {
                if (HttpUtils.isResourceCacheable(uRL2.toString(), httpResponse.getHeaders(), false)) {
                    CacheEntry cacheEntry = Cache.downloadResourceToCache(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, uRL2, bl4, n3);
                    return cacheEntry;
                }
                Resource resource7 = DownloadEngine.downloadResourceToTempDir(uRL, (String)object2, uRL2, httpResponse, (HttpDownloadListener)object, n3, downloadDelegate);
                return resource7;
            }
            CacheEntry cacheEntry = Cache.downloadResourceToTempFile(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, uRL2, bl4, bl3 ? n2 : n);
            cacheEntry.setBusy(1);
            cacheEntry.setIncomplete(1);
            cacheEntry.updateIndexHeaderOnDisk();
            CacheEntry cacheEntry2 = cacheEntry;
            return cacheEntry2;
        }
        catch (Exception exception) {
            if (exception instanceof JARSigningException) {
                throw (JARSigningException)exception;
            }
            if (exception instanceof FailedDownloadException) {
                throw (FailedDownloadException)exception;
            }
            Trace.ignored(exception);
            throw new FailedDownloadException(uRL2, string, exception);
        }
        finally {
            DownloadEngine.setDownloadInProgress(false);
        }
    }

    private static void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
        try {
            stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.ignoredException(unsupportedEncodingException);
        }
    }

    public static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3) {
        int n = string == null ? 1 : 2;
        return DownloadEngine.getRequestURL(uRL, string, string2, bl, string3, n);
    }

    private static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3, int n, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null && string != null) {
            string2 = Cache.getCacheEntryVersion(uRL);
        }
        if (string != null && n == 2) {
            DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string);
            if (string2 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_CURRENT_VERSION_ID, string2);
            }
        }
        if (string != null && n == 3) {
            if (bl) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_PLATFORM_VERSION_ID, string);
            } else {
                DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string);
            }
            DownloadEngine.addURLArgument(stringBuffer, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(stringBuffer, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(stringBuffer, ARG_LOCALE, defaultLocaleString);
            if (string3 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_KNOWN_PLATFORMS, string3);
            }
            if (string4 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_JFX_VERSION_ID, string4);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '?');
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + stringBuffer);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
    }

    public static URL getRequestURL(URL uRL, String string, String string2, boolean bl, String string3, int n) {
        return DownloadEngine.getRequestURL(uRL, string, string2, bl, string3, n, null);
    }

    public static Resource downloadResource(Resource resource, URL uRL, String string, DownloadDelegate downloadDelegate, boolean bl, String string2, int n, boolean bl2) throws IOException {
        int n2 = 1;
        if (string2 != null) {
            n2 = 3;
        } else if (string != null) {
            n2 = 2;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, bl, string2, n2);
        return DownloadEngine.actionDownload(resource, uRL, uRL2, string, downloadDelegate, n, bl, bl2);
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        return DownloadEngine.getAvailableVersion(uRL, string, bl, string2, null);
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2, String string3) {
        int n = string2 != null ? 3 : 2;
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, bl, string2, n, string3);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        String string4 = null;
        try {
            HttpResponse httpResponse = httpRequest.doGetRequest(uRL2);
            if (httpResponse != null) {
                string4 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                httpResponse.disconnect();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return string4;
    }

    static boolean isJarHeaderValid(byte[] byArray) {
        return DownloadEngine.get32(byArray, 0) == 67324752L;
    }

    private static int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static long get32(byte[] byArray, int n) {
        return (long)DownloadEngine.get16(byArray, n) | (long)DownloadEngine.get16(byArray, n + 2) << 16;
    }

    static {
        backgroundUpdateThreadLocal = new InheritableThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        processingState = new ThreadLocal();
        internalUse = new ThreadLocal();
        redirectURLs = new Hashtable();
        knownRedirectHostTable = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
    }
}

