/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.PlatformFactory;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.nativesandbox.NoSandboxBroker;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.IcoEncoder;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.SecurityBaseline;
import java.awt.AWTPermission;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;

public abstract class Platform {
    protected static final boolean DEBUG = Config.getDebug();
    private static Platform _platform;
    private static final AccessControlContext ACC_SHOW_INSTANCE;
    private static final AccessControlContext ACC_FILEPROP_INSTANCE;
    private static final AccessControlContext ACC_FILE_INSTANCE;
    protected static final String UPGRADE_FILENAME = "CacheUpgrade.properties";
    protected AutoUpdater auInstance;
    protected IconEncoder ieInstance;
    protected NativeSandboxBroker sandboxBroker;

    public static void setInstance(Platform platform) {
        _platform = platform;
    }

    public static Platform get() {
        if (_platform == null) {
            Platform.setInstance(PlatformFactory.newInstance());
        }
        return _platform;
    }

    public abstract void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public abstract void cacheSecurityBaseline(String var1, String var2);

    public abstract String getNativeLibPath();

    public abstract void addRemoveProgramsRemove(String var1, boolean var2);

    public abstract boolean canAutoDownloadJRE();

    public boolean canUseAlternateJREs() {
        return true;
    }

    public abstract String getBrowserPath();

    public abstract String getBrowserHomePath();

    public abstract String getDefaultSystemCache();

    public abstract String getFireFoxUserProfileDirectory();

    public abstract boolean canBecomeAdmin();

    public abstract boolean hasAdminPrivileges();

    public abstract List<JREInfo> getInstalledJREList();

    public abstract String getLibrarySufix();

    public abstract String getLibraryPrefix();

    public abstract String getMozillaUserProfileDirectory();

    public abstract long getNativePID();

    public abstract String getSessionSpecificString();

    public abstract String getSystemJavawsPath();

    public abstract int[] getIconSizes();

    public abstract int getSystemShortcutIconSize(boolean var1);

    public abstract int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract int updateShortcut(String var1, String var2);

    public abstract String getShortcutJnlpName(String var1);

    public boolean isAutoUpdateAvailable() {
        return false;
    }

    public abstract boolean isBrowserFireFox();

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isNativeModalDialogUp();

    public abstract boolean isPlatformIconType(String var1);

    public abstract void loadDeployNativeLib();

    public abstract void setUserHomeOverride(String var1);

    public boolean updateJava(String string) {
        return this.showDocument(string);
    }

    public boolean showDocument(URL uRL) {
        if (uRL == null) {
            return false;
        }
        return this.showDocument(uRL.toExternalForm());
    }

    public boolean showDocument(final String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    try {
                        Desktop.getDesktop().browse(new URL(string).toURI());
                        return Boolean.TRUE;
                    }
                    catch (Exception exception) {
                        Trace.ignoredException(exception);
                        return Boolean.FALSE;
                    }
                }
            }, ACC_SHOW_INSTANCE);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return false;
        }
    }

    public abstract void openControlPanel(String[] var1);

    public boolean getSponsorOffersDisabledSettings() {
        return false;
    }

    public void enableSponsorOffering(boolean bl) {
    }

    public void enableRoamingProfile(boolean bl) {
    }

    public abstract boolean systemLookAndFeelDefault();

    public abstract String getUserHome();

    public String getLocalStorageDir() {
        return this.getUserHome();
    }

    public abstract String getRoamingUserHome();

    public abstract void cacheCurrentConfig(Properties var1);

    public abstract String getUserHomeOverride();

    public abstract String getOSHome();

    public abstract String getSystemHome();

    public abstract String getPlatformSpecificJavaName();

    public abstract String getPlatformExtension();

    public abstract String getDebugJavaPath(String var1);

    public abstract String getLongPathName(String var1);

    public abstract boolean samePaths(String var1, String var2);

    public abstract int getPlatformMaxCommandLineLength();

    public abstract boolean useAltFileSystemView();

    public abstract String toExecArg(String var1);

    public abstract void onLoad(Object var1);

    public abstract void onSave(Object var1);

    public abstract boolean shouldPromptForAutoCheck();

    public abstract void handleUserResponse(int var1);

    public abstract void resetJavaHome();

    public abstract String getSecureLauncherName();

    public String findSecureLauncher(File file) {
        String string = this.getSecureLauncherName();
        String string2 = file == null ? Environment.getDeploymentHomePath() : file.toString();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (new File(string2 = string2 + "bin" + File.separator + string).exists()) {
            return string2;
        }
        return null;
    }

    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
    }

    public String getJucheckPath() {
        return null;
    }

    public String getPlatformNativeEncoding() {
        return "UTF-8";
    }

    public void storeCacheUpgradeInfo(final Properties properties) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws IOException {
                    if (properties == null) {
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (file.exists()) {
                            file.delete();
                        }
                        return null;
                    }
                    try (OutputStream outputStream = null;){
                        Properties properties2 = Platform.this.getCacheUpgradeProperties();
                        properties2.putAll((Map<?, ?>)properties);
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        outputStream = new FileOutputStream(file);
                        properties2.store(outputStream, "");
                    }
                    return null;
                }
            }, ACC_FILEPROP_INSTANCE);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = this.getCacheUpgradeProperties();
        Properties properties2 = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = properties.getProperty(stringArray[i]);
            if (string == null) continue;
            properties2.put(stringArray[i], string);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getCacheUpgradeProperties() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            final File file = new File(this.getUserHome(), UPGRADE_FILENAME);
            inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    if (file.isFile()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        }
        return properties;
    }

    public abstract String getLoadedNativeLibPath(String var1);

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new AutoUpdater();
        }
        return this.auInstance;
    }

    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new IcoEncoder();
        }
        return this.ieInstance;
    }

    public String getPlatformIconType() {
        return "ico";
    }

    public boolean isGTKAvailable(int n, int n2, int n3) {
        return false;
    }

    public String getDefaultIconPath() {
        return null;
    }

    public Properties getPendingConfigProperties() {
        return null;
    }

    public static void validateProcessBuilder(List<String> list) {
        int n = Config.getMaxCommandLineLength();
        if (n > 0) {
            int n2 = list.size() * 3;
            for (String string : list) {
                n2 += string.length();
            }
            if (n2 >= Config.getMaxCommandLineLength()) {
                String string = ResourceManager.getString("launch.error.cmd.max.len", n2, n, null);
                Trace.println("Error: " + (String)string, TraceLevel.BASIC);
                throw new RuntimeException(string);
            }
        }
    }

    public Process startProcessBuilder(ProcessBuilder processBuilder) throws IOException {
        Platform.validateProcessBuilder(processBuilder.command());
        return processBuilder.start();
    }

    public void verifyPermissionsForFileSystem() {
    }

    public void setRunInNativeSandbox(boolean bl) {
    }

    public boolean getRunInNativeSandbox() {
        return false;
    }

    public void checkAndUpdateSandboxWindow(boolean bl) {
    }

    public boolean isNativeSandbox() {
        return false;
    }

    public boolean getUseNativeSandboxWindow() {
        return false;
    }

    public long createNativeWindowSandboxHandle(long l) {
        return 0L;
    }

    public void setNativeSandboxWindowSize(long l, int n, int n2) {
    }

    private synchronized boolean initNativeSandboxBroker() {
        if (this.sandboxBroker == null) {
            this.sandboxBroker = new NoSandboxBroker();
        }
        return true;
    }

    public NativeSandboxBroker getNativeSandboxBroker() {
        if (this.initNativeSandboxBroker()) {
            return this.sandboxBroker;
        }
        return null;
    }

    public void setNativeSandboxJNLPService(NativeSandboxJNLPService nativeSandboxJNLPService) {
    }

    public void addParentWindow(int n, long l) {
    }

    public void waitForNativeSandboxProcess() {
    }

    public boolean isScreenLocked() {
        return false;
    }

    long getUserDeploymentPropCacheTimestamp() {
        return -1L;
    }

    long getSysDeploymentPropCacheTimestamp() {
        return -1L;
    }

    public abstract WebJavaSwitch getWebJavaSwitch();

    public boolean isCompatibleArch(String string, String string2) {
        return string.equals(string2);
    }

    static {
        Permissions permissions = new Permissions();
        Permission permission = new AWTPermission("showWindowWithoutWarningBanner");
        ((PermissionCollection)permissions).add(permission);
        FilePermission filePermission = new FilePermission("<<ALL FILES>>", "execute");
        ((PermissionCollection)permissions).add(filePermission);
        PropertyPermission propertyPermission = new PropertyPermission("os.version", "read");
        ((PermissionCollection)permissions).add(propertyPermission);
        ACC_SHOW_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        permissions = new Permissions();
        permission = new PropertyPermission("*", "read,write");
        ((PermissionCollection)permissions).add(permission);
        filePermission = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)permissions).add(filePermission);
        ACC_FILEPROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        permissions = new Permissions();
        permission = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)permissions).add(permission);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
    }

    public static abstract class WebJavaSwitch {
        protected abstract void setSystemWebJavaEnabled(boolean var1);

        protected abstract boolean isSystemWebJavaEnabled();

        public WebJavaState queryWebJavaState() {
            if (!this.isSystemWebJavaEnabled()) {
                return WebJavaState.DISABLED;
            }
            if (!this.isUserWebJavaEnabled()) {
                return WebJavaState.USER_DISABLED;
            }
            return WebJavaState.ENABLED;
        }

        public void setWebJavaEnabled(boolean bl) {
            try {
                this.setUserWebJavaEnabled(bl);
            }
            finally {
                this.setSystemWebJavaEnabled(bl);
            }
        }

        private void setUserWebJavaEnabled(boolean bl) {
            String string = "undefined";
            if (OSType.isUnix() && !Platform.get().isGTKAvailable(2, 14, 0)) {
                string = bl ? "later" : "block";
            }
            Config.setStringProperty("deployment.expiration.decision." + SecurityBaseline.getDeployVersion(), string);
            Config.setBooleanProperty("deployment.webjava.enabled", bl);
            Config.get().storeIfNeeded();
        }

        private boolean isUserWebJavaEnabled() {
            boolean bl;
            String string = "deployment.expiration.decision." + SecurityBaseline.getDeployVersion();
            boolean bl2 = "block".equals(Config.getStringProperty(string));
            boolean bl3 = Config.getBooleanProperty("deployment.webjava.enabled");
            if (bl3 != (bl = this.isSystemWebJavaEnabled())) {
                long l = Platform.get().getUserDeploymentPropCacheTimestamp();
                long l2 = Platform.get().getSysDeploymentPropCacheTimestamp();
                if (l != -1L && l2 != -1L && l2 >= l) {
                    this.setUserWebJavaEnabled(bl);
                    bl3 = bl;
                }
            }
            return bl3 && !bl2;
        }

        public boolean isWebJavaEnabled() {
            return this.queryWebJavaState() == WebJavaState.ENABLED;
        }

        public static final class WebJavaState {
            public static final WebJavaState ENABLED = new WebJavaState();
            public static final WebJavaState DISABLED = new WebJavaState();
            public static final WebJavaState USER_DISABLED = new WebJavaState();

            private WebJavaState() {
            }
        }
    }
}

