/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.Path2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import sun.java2d.ReentrantContext;
import sun.java2d.marlin.ArrayCache;
import sun.java2d.marlin.ByteArrayCache;
import sun.java2d.marlin.CollinearSimplifier;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.Dasher;
import sun.java2d.marlin.FloatArrayCache;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinRenderingEngine;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererStats;
import sun.java2d.marlin.Stroker;
import sun.java2d.marlin.TransformingPathConsumer2D;

final class RendererContext
extends ReentrantContext
implements MarlinConst {
    private static final AtomicInteger CTX_COUNT = new AtomicInteger(1);
    final RendererStats stats = DO_STATS ? RendererStats.getInstance() : null;
    private static final boolean USE_CACHE_HARD_REF = DO_STATS || MarlinRenderingEngine.REF_TYPE == 2;
    final String name;
    final Object cleanerObj = new Object();
    boolean dirty = false;
    WeakReference<ArrayCachesHolder> refArrayCaches = null;
    ArrayCachesHolder hardRefArrayCaches = null;
    final float[] float6 = new float[6];
    final Curve curve = new Curve();
    final MarlinRenderingEngine.NormalizingPathIterator nPCPathIterator;
    final MarlinRenderingEngine.NormalizingPathIterator nPQPathIterator;
    final TransformingPathConsumer2D transformerPC2D;
    Path2D.Float p2d = null;
    final Renderer renderer;
    final Stroker stroker;
    final CollinearSimplifier simplifier = new CollinearSimplifier();
    final Dasher dasher;
    final MarlinTileGenerator ptg;
    final MarlinCache cache;
    int stroking = 0;

    static RendererContext createContext() {
        RendererContext rendererContext = new RendererContext("ctx" + Integer.toString(CTX_COUNT.getAndIncrement()));
        if (DO_STATS) {
            RendererStats.ALL_CONTEXTS.add(rendererContext);
        }
        return rendererContext;
    }

    RendererContext(String string) {
        if (LOG_CREATE_CONTEXT) {
            MarlinUtils.logInfo("new RendererContext = " + string);
        }
        this.name = string;
        this.nPCPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelCenter(this.float6);
        this.nPQPathIterator = new MarlinRenderingEngine.NormalizingPathIterator.NearestPixelQuarter(this.float6);
        this.transformerPC2D = new TransformingPathConsumer2D();
        this.cache = new MarlinCache(this);
        this.renderer = new Renderer(this);
        this.ptg = new MarlinTileGenerator(this.renderer);
        this.stroker = new Stroker(this);
        this.dasher = new Dasher(this);
    }

    void dispose() {
        this.stroking = 0;
        if (!USE_CACHE_HARD_REF) {
            this.hardRefArrayCaches = null;
        }
        if (this.dirty) {
            this.nPCPathIterator.dispose();
            this.nPQPathIterator.dispose();
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    ArrayCachesHolder getArrayCachesHolder() {
        ArrayCachesHolder arrayCachesHolder = this.hardRefArrayCaches;
        if (arrayCachesHolder == null) {
            ArrayCachesHolder arrayCachesHolder2 = arrayCachesHolder = this.refArrayCaches != null ? (ArrayCachesHolder)this.refArrayCaches.get() : null;
            if (arrayCachesHolder == null) {
                if (LOG_CREATE_CONTEXT) {
                    MarlinUtils.logInfo("new ArrayCachesHolder for RendererContext = " + this.name);
                }
                arrayCachesHolder = new ArrayCachesHolder();
                if (USE_CACHE_HARD_REF) {
                    this.hardRefArrayCaches = arrayCachesHolder;
                } else {
                    this.refArrayCaches = new WeakReference<ArrayCachesHolder>(arrayCachesHolder);
                }
            }
        }
        return arrayCachesHolder;
    }

    ByteArrayCache getDirtyByteArrayCache(int n) {
        int n2 = ArrayCache.getBucketDirtyBytes(n);
        return this.getArrayCachesHolder().dirtyByteArrayCaches[n2];
    }

    byte[] getDirtyByteArray(int n) {
        if (n <= ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE) {
            return this.getDirtyByteArrayCache(n).getArray();
        }
        if (DO_STATS) {
            ArrayCache.incOversize();
        }
        if (DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("getDirtyByteArray[oversize]: length=\t" + n);
        }
        return new byte[n];
    }

    void putDirtyByteArray(byte[] byArray) {
        int n = byArray.length;
        if ((n & 1) == 0 && n <= ArrayCache.MAX_DIRTY_BYTE_ARRAY_SIZE) {
            this.getDirtyByteArrayCache(n).putDirtyArray(byArray, n);
        }
    }

    byte[] widenDirtyByteArray(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        if (DO_CHECKS && n3 >= n2) {
            return byArray;
        }
        if (DO_STATS) {
            ArrayCache.incResizeDirtyByte();
        }
        byte[] byArray2 = this.getDirtyByteArray(ArrayCache.getNewSize(n, n2));
        System.arraycopy(byArray, 0, byArray2, 0, n);
        this.putDirtyByteArray(byArray);
        if (DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("widenDirtyByteArray[" + byArray2.length + "]: usedSize=\t" + n + "\tlength=\t" + n3 + "\tneeded length=\t" + n2);
        }
        return byArray2;
    }

    IntArrayCache getIntArrayCache(int n) {
        int n2 = ArrayCache.getBucket(n);
        return this.getArrayCachesHolder().intArrayCaches[n2];
    }

    int[] getIntArray(int n) {
        if (n <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getIntArrayCache(n).getArray();
        }
        if (DO_STATS) {
            ArrayCache.incOversize();
        }
        if (DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("getIntArray[oversize]: length=\t" + n);
        }
        return new int[n];
    }

    int[] widenIntArray(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        if (DO_CHECKS && n4 >= n2) {
            return nArray;
        }
        if (DO_STATS) {
            ArrayCache.incResizeInt();
        }
        int[] nArray2 = this.getIntArray(ArrayCache.getNewSize(n, n2));
        System.arraycopy(nArray, 0, nArray2, 0, n);
        this.putIntArray(nArray, 0, n3);
        if (DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("widenIntArray[" + nArray2.length + "]: usedSize=\t" + n + "\tlength=\t" + n4 + "\tneeded length=\t" + n2);
        }
        return nArray2;
    }

    void putIntArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if ((n3 & 1) == 0 && n3 <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getIntArrayCache(n3).putArray(nArray, n3, n, n2);
        }
    }

    IntArrayCache getDirtyIntArrayCache(int n) {
        int n2 = ArrayCache.getBucket(n);
        return this.getArrayCachesHolder().dirtyIntArrayCaches[n2];
    }

    int[] getDirtyIntArray(int n) {
        if (n <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getDirtyIntArrayCache(n).getArray();
        }
        if (DO_STATS) {
            ArrayCache.incOversize();
        }
        if (DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("getDirtyIntArray[oversize]: length=\t" + n);
        }
        return new int[n];
    }

    int[] widenDirtyIntArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        if (DO_CHECKS && n3 >= n2) {
            return nArray;
        }
        if (DO_STATS) {
            ArrayCache.incResizeDirtyInt();
        }
        int[] nArray2 = this.getDirtyIntArray(ArrayCache.getNewSize(n, n2));
        System.arraycopy(nArray, 0, nArray2, 0, n);
        this.putDirtyIntArray(nArray);
        if (DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("widenDirtyIntArray[" + nArray2.length + "]: usedSize=\t" + n + "\tlength=\t" + n3 + "\tneeded length=\t" + n2);
        }
        return nArray2;
    }

    void putDirtyIntArray(int[] nArray) {
        int n = nArray.length;
        if ((n & 1) == 0 && n <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getDirtyIntArrayCache(n).putDirtyArray(nArray, n);
        }
    }

    FloatArrayCache getDirtyFloatArrayCache(int n) {
        int n2 = ArrayCache.getBucket(n);
        return this.getArrayCachesHolder().dirtyFloatArrayCaches[n2];
    }

    float[] getDirtyFloatArray(int n) {
        if (n <= ArrayCache.MAX_ARRAY_SIZE) {
            return this.getDirtyFloatArrayCache(n).getArray();
        }
        if (DO_STATS) {
            ArrayCache.incOversize();
        }
        if (DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("getDirtyFloatArray[oversize]: length=\t" + n);
        }
        return new float[n];
    }

    float[] widenDirtyFloatArray(float[] fArray, int n, int n2) {
        int n3 = fArray.length;
        if (DO_CHECKS && n3 >= n2) {
            return fArray;
        }
        if (DO_STATS) {
            ArrayCache.incResizeDirtyFloat();
        }
        float[] fArray2 = this.getDirtyFloatArray(ArrayCache.getNewSize(n, n2));
        System.arraycopy(fArray, 0, fArray2, 0, n);
        this.putDirtyFloatArray(fArray);
        if (DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("widenDirtyFloatArray[" + fArray2.length + "]: usedSize=\t" + n + "\tlength=\t" + n3 + "\tneeded length=\t" + n2);
        }
        return fArray2;
    }

    void putDirtyFloatArray(float[] fArray) {
        int n = fArray.length;
        if ((n & 1) == 0 && n <= ArrayCache.MAX_ARRAY_SIZE) {
            this.getDirtyFloatArrayCache(n).putDirtyArray(fArray, n);
        }
    }

    static final class ArrayCachesHolder {
        final IntArrayCache[] intArrayCaches = new IntArrayCache[4];
        final IntArrayCache[] dirtyIntArrayCaches = new IntArrayCache[4];
        final FloatArrayCache[] dirtyFloatArrayCaches = new FloatArrayCache[4];
        final ByteArrayCache[] dirtyByteArrayCaches = new ByteArrayCache[4];

        ArrayCachesHolder() {
            for (int i = 0; i < 4; ++i) {
                this.intArrayCaches[i] = new IntArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyIntArrayCaches[i] = new IntArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyFloatArrayCaches[i] = new FloatArrayCache(ArrayCache.ARRAY_SIZES[i]);
                this.dirtyByteArrayCaches[i] = new ByteArrayCache(ArrayCache.DIRTY_BYTE_ARRAY_SIZES[i]);
            }
        }
    }
}

