/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class FloatArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<float[]> floatArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("FloatArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.floatArrays.size());
        }
    }

    FloatArrayCache(int n) {
        this.arraySize = n;
        this.floatArrays = new ArrayDeque(6);
    }

    float[] getArray() {
        float[] fArray;
        if (DO_STATS) {
            ++this.getOp;
        }
        if ((fArray = this.floatArrays.pollLast()) != null) {
            return fArray;
        }
        if (DO_STATS) {
            ++this.createOp;
        }
        return new float[this.arraySize];
    }

    void putDirtyArray(float[] fArray, int n) {
        if (n != this.arraySize) {
            if (DO_CHECKS) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (DO_STATS) {
            ++this.returnOp;
        }
        this.floatArrays.addLast(fArray);
    }

    void putArray(float[] fArray, int n, int n2, int n3) {
        if (n != this.arraySize) {
            if (DO_CHECKS) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (DO_STATS) {
            ++this.returnOp;
        }
        FloatArrayCache.fill(fArray, n2, n3, 0.0f);
        this.floatArrays.addLast(fArray);
    }

    static void fill(float[] fArray, int n, int n2, float f) {
        if (n2 != 0) {
            Arrays.fill(fArray, n, n2, f);
        }
        if (DO_CHECKS) {
            FloatArrayCache.check(fArray, n, n2, f);
        }
    }

    static void check(float[] fArray, int n, int n2, float f) {
        if (DO_CHECKS) {
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] == f) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + fArray[i] + " from: " + n + " to: " + n2 + "\n" + Arrays.toString(fArray), new Throwable());
                Arrays.fill(fArray, f);
                return;
            }
        }
    }
}

