/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.windows.GDIWindowSurfaceData;

public class Win32GraphicsConfig
extends GraphicsConfiguration
implements DisplayChangedListener,
SurfaceManager.ProxiedGraphicsConfig {
    protected Win32GraphicsDevice screen;
    protected int visual;
    protected RenderLoops solidloops;
    private SurfaceType sTypeOrig = null;

    private static native void initIDs();

    public static Win32GraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        return new Win32GraphicsConfig(win32GraphicsDevice, n);
    }

    @Deprecated
    public Win32GraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (Win32GraphicsDevice)graphicsDevice;
        this.visual = n;
        ((Win32GraphicsDevice)graphicsDevice).addDisplayChangedListener(this);
    }

    @Override
    public Win32GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    @Override
    public Object getProxyKey() {
        return this.screen;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null || this.sTypeOrig != surfaceType) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
            this.sTypeOrig = surfaceType;
        }
        return this.solidloops;
    }

    @Override
    public synchronized ColorModel getColorModel() {
        return this.screen.getColorModel();
    }

    public ColorModel getDeviceColorModel() {
        return this.screen.getDynamicColorModel();
    }

    @Override
    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        double d = this.screen.getDefaultScaleX();
        double d2 = this.screen.getDefaultScaleY();
        return AffineTransform.getScaleInstance(d, d2);
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        Win32GraphicsEnvironment win32GraphicsEnvironment = (Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        double d = (double)win32GraphicsEnvironment.getXResolution() / 72.0;
        double d2 = (double)win32GraphicsEnvironment.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    public String toString() {
        return super.toString() + "[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    @Override
    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    @Override
    public synchronized void displayChanged() {
        this.solidloops = null;
    }

    @Override
    public void paletteChanged() {
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        return GDIWindowSurfaceData.createData(wComponentPeer);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        throw new AWTException("The operation requested is not supported");
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        if (flipContents == BufferCapabilities.FlipContents.COPIED || flipContents == BufferCapabilities.FlipContents.UNDEFINED) {
            Graphics graphics = wComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
            }
            finally {
                graphics.dispose();
            }
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics graphics = volatileImage.getGraphics();
            try {
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                graphics.dispose();
            }
        }
    }

    @Override
    public boolean isTranslucencyCapable() {
        return true;
    }

    static {
        Win32GraphicsConfig.initIDs();
    }
}

