/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class Utilities {
    static JComponent getJComponent(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) instanceof JComponent) {
            return (JComponent)container;
        }
        return null;
    }

    @Deprecated
    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        return Utilities.drawTabbedText(null, segment, n, n2, graphics, tabExpander, n3);
    }

    public static final float drawTabbedText(Segment segment, float f, float f2, Graphics2D graphics2D, TabExpander tabExpander, int n) {
        return Utilities.drawTabbedText(segment, (int)f, (int)f2, (Graphics)graphics2D, tabExpander, n);
    }

    static final int drawTabbedText(View view, Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        return Utilities.drawTabbedText(view, segment, n, n2, graphics, tabExpander, n3, null);
    }

    static final int drawTabbedText(View view, Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3, int[] nArray) {
        return (int)Utilities.drawTabbedText(view, segment, n, n2, graphics, tabExpander, n3, nArray, false);
    }

    static final float drawTabbedText(View view, Segment segment, float f, float f2, Graphics graphics, TabExpander tabExpander, int n, int[] nArray, boolean bl) {
        int n2;
        JComponent jComponent = Utilities.getJComponent(view);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        float f3 = f;
        char[] cArray = segment.array;
        int n3 = segment.offset;
        int n4 = 0;
        int n5 = segment.offset;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        if (nArray != null) {
            n2 = -n + n3;
            View view2 = null;
            if (view != null && (view2 = view.getParent()) != null) {
                n2 += view2.getStartOffset();
            }
            n6 = nArray[0];
            n7 = nArray[1] + n2;
            n8 = nArray[2] + n2;
            n9 = nArray[3] + n2;
        }
        n2 = segment.offset + segment.count;
        for (int i = n3; i < n2; ++i) {
            if (cArray[i] == '\t' || (n6 != 0 || i <= n7) && cArray[i] == ' ' && n8 <= i && i <= n9) {
                if (n4 > 0) {
                    f3 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n5, n4, f, f2);
                    n4 = 0;
                }
                n5 = i + 1;
                if (cArray[i] == '\t') {
                    f3 = tabExpander != null ? tabExpander.nextTabStop(f3, n + i - n3) : (f3 += SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl));
                } else if (cArray[i] == ' ') {
                    f3 += SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl);
                    f3 += (float)n6;
                    if (i <= n7) {
                        f3 += 1.0f;
                    }
                }
                f = f3;
                continue;
            }
            if (cArray[i] == '\n' || cArray[i] == '\r') {
                if (n4 > 0) {
                    f3 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n5, n4, f, f2, bl);
                    n4 = 0;
                }
                n5 = i + 1;
                f = f3;
                continue;
            }
            ++n4;
        }
        if (n4 > 0) {
            f3 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n5, n4, f, f2, bl);
        }
        return f3;
    }

    @Deprecated
    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        return Utilities.getTabbedTextWidth(null, segment, fontMetrics, n, tabExpander, n2, null);
    }

    public static final float getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, float f, TabExpander tabExpander, int n) {
        return Utilities.getTabbedTextWidth(null, segment, fontMetrics, f, tabExpander, n, null);
    }

    static final int getTabbedTextWidth(View view, Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2, int[] nArray) {
        return (int)Utilities.getTabbedTextWidth(view, segment, fontMetrics, n, tabExpander, n2, nArray, false);
    }

    static final float getTabbedTextWidth(View view, Segment segment, FontMetrics fontMetrics, float f, TabExpander tabExpander, int n, int[] nArray) {
        return Utilities.getTabbedTextWidth(view, segment, fontMetrics, f, tabExpander, n, nArray, true);
    }

    static final float getTabbedTextWidth(View view, Segment segment, FontMetrics fontMetrics, float f, TabExpander tabExpander, int n, int[] nArray, boolean bl) {
        int n2;
        float f2 = f;
        char[] cArray = segment.array;
        int n3 = segment.offset;
        int n4 = segment.offset + segment.count;
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        if (nArray != null) {
            n2 = -n + n3;
            View view2 = null;
            if (view != null && (view2 = view.getParent()) != null) {
                n2 += view2.getStartOffset();
            }
            n6 = nArray[0];
            n7 = nArray[1] + n2;
            n8 = nArray[2] + n2;
            n9 = nArray[3] + n2;
        }
        for (n2 = n3; n2 < n4; ++n2) {
            if (cArray[n2] == '\t' || (n6 != 0 || n2 <= n7) && cArray[n2] == ' ' && n8 <= n2 && n2 <= n9) {
                f2 += (float)fontMetrics.charsWidth(cArray, n2 - n5, n5);
                n5 = 0;
                if (cArray[n2] == '\t') {
                    if (tabExpander != null) {
                        f2 = tabExpander.nextTabStop(f2, n + n2 - n3);
                        continue;
                    }
                    f2 += SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl);
                    continue;
                }
                if (cArray[n2] != ' ') continue;
                float f3 = SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl);
                f2 += f3 + (float)n6;
                if (n2 > n7) continue;
                f2 += 1.0f;
                continue;
            }
            if (cArray[n2] == '\n') {
                f2 += SwingUtilities2.getFontCharsWidth(cArray, n2 - n5, n5, fontMetrics, bl);
                n5 = 0;
                continue;
            }
            ++n5;
        }
        return (f2 += SwingUtilities2.getFontCharsWidth(cArray, n4 - n5, n5, fontMetrics, bl)) - f;
    }

    @Deprecated
    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    static final int getTabbedTextOffset(View view, Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, int[] nArray) {
        return Utilities.getTabbedTextOffset(view, segment, fontMetrics, n, n2, tabExpander, n3, true, nArray, false);
    }

    @Deprecated
    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        return Utilities.getTabbedTextOffset(null, segment, fontMetrics, n, n2, tabExpander, n3, bl, null, false);
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, float f, float f2, TabExpander tabExpander, int n, boolean bl) {
        return Utilities.getTabbedTextOffset(null, segment, fontMetrics, f, f2, tabExpander, n, bl, null, true);
    }

    static final int getTabbedTextOffset(View view, Segment segment, FontMetrics fontMetrics, float f, float f2, TabExpander tabExpander, int n, boolean bl, int[] nArray, boolean bl2) {
        int n2;
        if (f >= f2) {
            return 0;
        }
        float f3 = f;
        char[] cArray = segment.array;
        int n3 = segment.offset;
        int n4 = segment.count;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        if (nArray != null) {
            n2 = -n + n3;
            View view2 = null;
            if (view != null && (view2 = view.getParent()) != null) {
                n2 += view2.getStartOffset();
            }
            n5 = nArray[0];
            n6 = nArray[1] + n2;
            n7 = nArray[2] + n2;
            n8 = nArray[3] + n2;
        }
        n2 = segment.offset + segment.count;
        for (int i = segment.offset; i < n2; ++i) {
            int n9;
            if (cArray[i] == '\t' || (n5 != 0 || i <= n6) && cArray[i] == ' ' && n7 <= i && i <= n8) {
                if (cArray[i] == '\t') {
                    f3 = tabExpander != null ? tabExpander.nextTabStop(f3, n + i - n3) : (f3 += SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl2));
                } else if (cArray[i] == ' ') {
                    float f4 = SwingUtilities2.getFontCharWidth(' ', fontMetrics, bl2);
                    f3 += f4 + (float)n5;
                    if (i <= n6) {
                        f3 += 1.0f;
                    }
                }
            } else {
                f3 += SwingUtilities2.getFontCharWidth(cArray[i], fontMetrics, bl2);
            }
            if (!(f2 < f3)) continue;
            if (bl) {
                float f5 = f2 - f;
                n9 = i + 1 - n3;
                float f6 = SwingUtilities2.getFontCharsWidth(cArray, n3, n9, fontMetrics, bl2);
                if (f5 < f6) {
                    while (n9 > 0) {
                        float f7;
                        float f8 = SwingUtilities2.getFontCharsWidth(cArray, n3, n9 - 1, fontMetrics, bl2);
                        float f9 = f7 = n9 > 1 ? f8 : 0.0f;
                        if (f5 >= f7) {
                            if (!(f5 - f7 < f6 - f5)) break;
                            --n9;
                            break;
                        }
                        f6 = f7;
                        --n9;
                    }
                }
            } else {
                for (n9 = i - n3; n9 > 0 && SwingUtilities2.getFontCharsWidth(cArray, n3, n9, fontMetrics, bl2) > f2 - f; --n9) {
                }
            }
            return n9;
        }
        return n4;
    }

    @Deprecated
    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getBreakLocation(segment, fontMetrics, n, n2, tabExpander, n3, false);
    }

    static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, float f, float f2, TabExpander tabExpander, int n, boolean bl) {
        char[] cArray = segment.array;
        int n2 = segment.offset;
        int n3 = segment.count;
        int n4 = Utilities.getTabbedTextOffset(null, segment, fontMetrics, f, f2, tabExpander, n, false, null, bl);
        if (n4 >= n3 - 1) {
            return n3;
        }
        for (int i = n2 + n4; i >= n2; --i) {
            char c = cArray[i];
            if (c < '\u0100') {
                if (!Character.isWhitespace(c)) continue;
                n4 = i - n2 + 1;
                break;
            }
            BreakIterator breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(segment);
            int n5 = breakIterator.preceding(i + 1);
            if (n5 <= n2) break;
            n4 = n5 - n2;
            break;
        }
        return n4;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, float f, float f2, TabExpander tabExpander, int n) {
        return Utilities.getBreakLocation(segment, fontMetrics, f, f2, tabExpander, n, false);
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        if (rectangle == null) {
            return -1;
        }
        int n2 = n;
        int n3 = rectangle.y;
        while (rectangle != null && n3 == rectangle.y) {
            if (rectangle.height != 0) {
                n = n2;
            }
            rectangle = --n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        }
        return n;
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle2D rectangle2D = jTextComponent.modelToView2D(n);
        if (rectangle2D == null) {
            return -1;
        }
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = n;
        double d = rectangle2D.getY();
        while (rectangle2D != null && d == rectangle2D.getY()) {
            if (rectangle2D.getHeight() != 0.0) {
                n = n3;
            }
            rectangle2D = ++n3 <= n2 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    @Deprecated
    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        return Utilities.getPositionAbove(jTextComponent, n, n2, false);
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, float f) throws BadLocationException {
        return Utilities.getPositionAbove(jTextComponent, n, f, true);
    }

    static final int getPositionAbove(JTextComponent jTextComponent, int n, float f, boolean bl) throws BadLocationException {
        int n2 = Utilities.getRowStart(jTextComponent, n) - 1;
        if (n2 < 0) {
            return -1;
        }
        double d = 2.147483647E9;
        double d2 = 0.0;
        RectangularShape rectangularShape = null;
        if (n2 >= 0) {
            rectangularShape = bl ? jTextComponent.modelToView2D(n2) : jTextComponent.modelToView(n2);
            d2 = rectangularShape.getY();
        }
        while (rectangularShape != null && d2 == rectangularShape.getY()) {
            double d3 = Math.abs(rectangularShape.getX() - (double)f);
            if (d3 < d) {
                n = n2;
                d = d3;
            }
            if (--n2 >= 0) {
                rectangularShape = bl ? jTextComponent.modelToView2D(n2) : jTextComponent.modelToView(n2);
                continue;
            }
            rectangularShape = null;
        }
        return n;
    }

    @Deprecated
    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        return Utilities.getPositionBelow(jTextComponent, n, n2, false);
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, float f) throws BadLocationException {
        return Utilities.getPositionBelow(jTextComponent, n, f, true);
    }

    static final int getPositionBelow(JTextComponent jTextComponent, int n, float f, boolean bl) throws BadLocationException {
        int n2 = Utilities.getRowEnd(jTextComponent, n) + 1;
        if (n2 <= 0) {
            return -1;
        }
        double d = 2.147483647E9;
        int n3 = jTextComponent.getDocument().getLength();
        double d2 = 0.0;
        RectangularShape rectangularShape = null;
        if (n2 <= n3) {
            rectangularShape = bl ? jTextComponent.modelToView2D(n2) : jTextComponent.modelToView(n2);
            d2 = rectangularShape.getY();
        }
        while (rectangularShape != null && d2 == rectangularShape.getY()) {
            double d3 = Math.abs((double)f - rectangularShape.getX());
            if (d3 < d) {
                n = n2;
                d = d3;
            }
            if (++n2 <= n3) {
                rectangularShape = bl ? jTextComponent.modelToView2D(n2) : jTextComponent.modelToView(n2);
                continue;
            }
            rectangularShape = null;
        }
        return n;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n4 = segment.offset + n - n2;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n2 + breakIterator.previous() - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n4 = n - n2 + segment.offset;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            n = n2 + breakIterator.following(n4) - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getNextWordInParagraph(jTextComponent, element, n, false);
        while (n2 == -1) {
            n = element.getEndOffset();
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getNextWordInParagraph(jTextComponent, element, n, true);
        }
        return n2;
    }

    static int getNextWordInParagraph(JTextComponent jTextComponent, Element element, int n, boolean bl) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        if (n >= n3 || n < n2) {
            throw new BadLocationException("No more words", n);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (bl && breakIterator.first() == segment.offset + n - n2 && !Character.isWhitespace(segment.array[breakIterator.first()])) {
            return n;
        }
        int n4 = breakIterator.following(segment.offset + n - n2);
        if (n4 == -1 || n4 >= segment.offset + segment.count) {
            return -1;
        }
        char c = segment.array[n4];
        if (!Character.isWhitespace(c)) {
            return n2 + n4 - segment.offset;
        }
        n4 = breakIterator.next();
        if (n4 != -1 && (n = n2 + n4 - segment.offset) != n3) {
            return n;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getPrevWordInParagraph(jTextComponent, element, n);
        while (n2 == -1) {
            n = element.getStartOffset() - 1;
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getPrevWordInParagraph(jTextComponent, element, n);
        }
        return n2;
    }

    static int getPrevWordInParagraph(JTextComponent jTextComponent, Element element, int n) throws BadLocationException {
        int n2;
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        if (n > n4 || n < n3) {
            throw new BadLocationException("No more words", n);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (breakIterator.following(segment.offset + n - n3) == -1) {
            breakIterator.last();
        }
        if ((n2 = breakIterator.previous()) == segment.offset + n - n3) {
            n2 = breakIterator.previous();
        }
        if (n2 == -1) {
            return -1;
        }
        char c = segment.array[n2];
        if (!Character.isWhitespace(c)) {
            return n3 + n2 - segment.offset;
        }
        n2 = breakIterator.previous();
        if (n2 != -1) {
            return n3 + n2 - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        int n2;
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    static boolean isComposedTextElement(Document document, int n) {
        Element element = document.getDefaultRootElement();
        while (!element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n));
        }
        return Utilities.isComposedTextElement(element);
    }

    static boolean isComposedTextElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        return Utilities.isComposedTextAttributeDefined(attributeSet);
    }

    static boolean isComposedTextAttributeDefined(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    static int drawComposedText(View view, AttributeSet attributeSet, Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return (int)Utilities.drawComposedText(view, attributeSet, graphics, n, n2, n3, n4, false);
    }

    static float drawComposedText(View view, AttributeSet attributeSet, Graphics graphics, float f, float f2, int n, int n2) throws BadLocationException {
        return Utilities.drawComposedText(view, attributeSet, graphics, f, f2, n, n2, true);
    }

    static float drawComposedText(View view, AttributeSet attributeSet, Graphics graphics, float f, float f2, int n, int n2, boolean bl) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n >= n2) {
            return f;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n, n2);
        return f + SwingUtilities2.drawString(Utilities.getJComponent(view), (Graphics)graphics2D, attributedCharacterIterator, f, f2);
    }

    static void paintComposedText(Graphics graphics, Rectangle rectangle, GlyphView glyphView) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = glyphView.getStartOffset();
            int n2 = glyphView.getEndOffset();
            AttributeSet attributeSet = glyphView.getElement().getAttributes();
            AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
            int n3 = glyphView.getElement().getStartOffset();
            int n4 = rectangle.y + rectangle.height - (int)glyphView.getGlyphPainter().getDescent(glyphView);
            int n5 = rectangle.x;
            attributedString.addAttribute(TextAttribute.FONT, glyphView.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, glyphView.getForeground());
            if (StyleConstants.isBold(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (StyleConstants.isItalic(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (glyphView.isUnderline()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (glyphView.isStrikeThrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (glyphView.isSuperscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            }
            if (glyphView.isSubscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n - n3, n2 - n3);
            SwingUtilities2.drawString(Utilities.getJComponent(glyphView), (Graphics)graphics2D, attributedCharacterIterator, n5, n4);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static int getNextVisualPositionFrom(View view, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        boolean bl;
        if (view.getViewCount() == 0) {
            return n;
        }
        boolean bl2 = bl = n2 == 1 || n2 == 7;
        if (n == -1) {
            Shape shape2;
            int n4 = bl ? view.getViewCount() - 1 : 0;
            View view2 = view.getView(n4);
            n3 = view2.getNextVisualPositionFrom(n, bias, shape2 = view.getChildAllocation(n4, shape), n2, biasArray);
            if (n3 == -1 && !bl && view.getViewCount() > 1) {
                view2 = view.getView(1);
                shape2 = view.getChildAllocation(1, shape);
                n3 = view2.getNextVisualPositionFrom(-1, biasArray[0], shape2, n2, biasArray);
            }
        } else {
            int n5 = bl ? -1 : 1;
            int n6 = bias == Position.Bias.Backward && n > 0 ? view.getViewIndex(n - 1, Position.Bias.Forward) : view.getViewIndex(n, Position.Bias.Forward);
            View view3 = view.getView(n6);
            Shape shape3 = view.getChildAllocation(n6, shape);
            n3 = view3.getNextVisualPositionFrom(n, bias, shape3, n2, biasArray);
            if ((n2 == 3 || n2 == 7) && view instanceof CompositeView && ((CompositeView)view).flipEastAndWestAtEnds(n, bias)) {
                n5 *= -1;
            }
            if (n3 == -1 && (n6 += n5) >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                n3 = view3.getNextVisualPositionFrom(-1, bias, shape3 = view.getChildAllocation(n6, shape), n2, biasArray);
                if (n3 == n && biasArray[0] != bias) {
                    return Utilities.getNextVisualPositionFrom(view, n, biasArray[0], shape, n2, biasArray);
                }
            } else if (n3 != -1 && biasArray[0] != bias && (n5 == 1 && view3.getEndOffset() == n3 || n5 == -1 && view3.getStartOffset() == n3) && n6 >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                shape3 = view.getChildAllocation(n6, shape);
                Position.Bias bias2 = biasArray[0];
                int n7 = view3.getNextVisualPositionFrom(-1, bias, shape3, n2, biasArray);
                if (biasArray[0] == bias) {
                    n3 = n7;
                } else {
                    biasArray[0] = bias2;
                }
            }
        }
        return n3;
    }
}

