/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.DeployURLClassLoader;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import jdk.internal.misc.SharedSecrets;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.security.util.SecurityConstants;

public class SecurityManagerHelper {
    private static final Field fcontext;
    private static final String PRINT_DIALOG_KEY = "sun.plugin.security.printDialog";
    private static final ThreadLocal<Boolean> inThreadGroupCheck;

    static void resetHelper(final HashSet<String> hashSet) {
        hashSet.clear();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Enumeration<?> enumeration = System.getProperties().propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.startsWith("package.restrict.access.") || (string = System.getProperty(string2)) == null || !string.equalsIgnoreCase("true")) continue;
                    String string3 = string2.substring(24);
                    hashSet.add(string3);
                }
                return null;
            }
        });
    }

    static void checkAccessHelper(Thread thread, SecurityManager securityManager, ClassLoader classLoader, Class<?>[] classArray) {
        if (!SecurityManagerHelper.isThreadTerminated(thread) && !SecurityManagerHelper.inThreadGroup(securityManager, thread, classLoader, classArray)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkAccessHelper(ThreadGroup threadGroup, SecurityManager securityManager, ClassLoader classLoader, Class<?>[] classArray) {
        if (inThreadGroupCheck.get().equals(Boolean.TRUE)) {
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                inThreadGroupCheck.set(Boolean.TRUE);
                if (!SecurityManagerHelper.inThreadGroup(securityManager, threadGroup, classLoader, classArray)) {
                    securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
            }
            finally {
                inThreadGroupCheck.set(Boolean.FALSE);
            }
        }
    }

    private static boolean isThreadTerminated(Thread thread) {
        try {
            return thread.getState() == Thread.State.TERMINATED;
        }
        catch (Throwable throwable) {
            return !thread.isAlive();
        }
    }

    private static Plugin2ClassLoader currentAppletClassLoader(ClassLoader classLoader, Class<?>[] classArray) {
        if (classLoader == null || classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)((Object)classLoader);
        }
        for (Class<?> clazz : classArray) {
            classLoader = clazz.getClassLoader();
            if (!(classLoader instanceof Plugin2ClassLoader)) continue;
            return (Plugin2ClassLoader)((Object)classLoader);
        }
        for (Class<?> clazz : classArray) {
            final ClassLoader classLoader2 = clazz.getClassLoader();
            if (!(classLoader2 instanceof DeployURLClassLoader) || (classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ProtectionDomain[] protectionDomainArray = null;
                    try {
                        ProtectionDomain[] protectionDomainArray2 = ((DeployURLClassLoader)classLoader2).getAccessControlContext();
                        if (protectionDomainArray2 == null) {
                            return null;
                        }
                        if (Config.isJavaVersionAtLeast9()) {
                            protectionDomainArray = SharedSecrets.getJavaSecurityAccess().getProtectDomains((AccessControlContext)protectionDomainArray2);
                        } else if (fcontext != null) {
                            protectionDomainArray = (ProtectionDomain[])fcontext.get(protectionDomainArray2);
                        }
                        if (protectionDomainArray == null) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        throw new UnsupportedOperationException(exception);
                    }
                    for (ProtectionDomain protectionDomain : protectionDomainArray) {
                        ClassLoader classLoader = protectionDomain.getClassLoader();
                        if (!(classLoader instanceof Plugin2ClassLoader)) continue;
                        return classLoader;
                    }
                    return null;
                }
            })) == null) continue;
            return (Plugin2ClassLoader)((Object)classLoader);
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof Plugin2ClassLoader) {
            return (Plugin2ClassLoader)((Object)classLoader);
        }
        return null;
    }

    private static boolean inThreadGroup(SecurityManager securityManager, ThreadGroup threadGroup, ClassLoader classLoader, Class<?>[] classArray) {
        if (SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray) == null) {
            return false;
        }
        ThreadGroup threadGroup2 = SecurityManagerHelper.getThreadGroupHelper(securityManager, classLoader, classArray);
        if (threadGroup2 == null) {
            return false;
        }
        return threadGroup2.parentOf(threadGroup);
    }

    private static boolean inThreadGroup(SecurityManager securityManager, Thread thread, ClassLoader classLoader, Class<?>[] classArray) {
        return SecurityManagerHelper.inThreadGroup(securityManager, thread.getThreadGroup(), classLoader, classArray);
    }

    static void checkPackageAccessHelper(SecurityManager securityManager, String string, HashSet<String> hashSet) {
        securityManager.checkPackageAccess(string);
        for (String string2 : hashSet) {
            if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
            securityManager.checkPermission(new RuntimePermission("accessClassInPackage." + string));
        }
    }

    static void checkConnectHelper(SecurityManager securityManager, String string, int n, Object object, boolean bl, Class<?>[] classArray) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (CrossDomainXML.quickCheck((Class[])classArray, (String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                securityManager.checkConnect(string, n, object);
            } else {
                securityManager.checkConnect(string, n);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (n2 == -2 ? 1 : 0) != 0)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkURLPermissionHelper(SecurityManager securityManager, Permission permission, Object object, boolean bl, Class<?>[] classArray) {
        URL uRL = null;
        String string = null;
        int n = -1;
        try {
            uRL = new URL(permission.getName());
            string = uRL.getHost();
            n = uRL.getPort();
            if (n == -1) {
                n = uRL.getDefaultPort();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null || string == null || n < 0) {
            if (bl) {
                securityManager.checkPermission(permission, object);
            } else {
                securityManager.checkPermission(permission);
            }
            return;
        }
        if (CrossDomainXML.quickCheck((Class[])classArray, (String)string, (int)n)) {
            return;
        }
        try {
            if (bl) {
                securityManager.checkPermission(permission, object);
            } else {
                securityManager.checkPermission(permission);
            }
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])classArray, (URL)uRL, (String)string, (int)n, (boolean)false)) {
                return;
            }
            throw securityException;
        }
    }

    static void checkPermissionHelper(Permission permission) {
        Applet2ExecutionContext applet2ExecutionContext;
        if (permission.getName().equals("setSecurityManager") && !(applet2ExecutionContext = Plugin2Manager.getCurrentAppletExecutionContext()).requestCustomSecurityManager()) {
            throw new SecurityException("JVM Shared, not allowed to set security manager");
        }
    }

    static void checkPrintJobAccessHelper(SecurityManager securityManager) {
        try {
            securityManager.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityManagerHelper.showPrintDialog();
                    return null;
                }
            });
            return;
        }
    }

    private static void showPrintDialog() {
        int n;
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)ToolkitStore.get().getAppContext().get((Object)PRINT_DIALOG_KEY);
        LocalApplicationProperties localApplicationProperties = null;
        if (string4 == null && (localApplicationProperties = SecurityManagerHelper.getLap()) != null) {
            string4 = localApplicationProperties.get(PRINT_DIALOG_KEY);
        }
        if (!Trace.isAutomationEnabled() && string4 == null) {
            n = ToolkitStore.getUI().showMessageDialog(null, null, 7, string, null, string2, null, null, string3, null);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            n = 0;
        }
        if (n != 0 && n != 2) {
            throw new SecurityException("checkPrintJobAccess");
        }
        ToolkitStore.get().getAppContext().put((Object)PRINT_DIALOG_KEY, (Object)"skip");
        if (n == 2 && localApplicationProperties != null) {
            localApplicationProperties.put(PRINT_DIALOG_KEY, "skip");
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
    }

    private static LocalApplicationProperties getLap() {
        Plugin2Manager plugin2Manager = Plugin2Manager.getCurrentManager();
        if (plugin2Manager != null) {
            return ResourceProvider.get().getLocalApplicationProperties(plugin2Manager.getAppInfo().getLapURL(), null, true);
        }
        return null;
    }

    static void checkSecurityAccessHelper(SecurityManager securityManager, String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        securityManager.checkSecurityAccess(string);
    }

    static AppContext getAppContextHelper(ClassLoader classLoader, Class<?>[] classArray) {
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray);
        if (plugin2ClassLoader == null) {
            return null;
        }
        AppContext appContext = plugin2ClassLoader.getAppContext();
        if (appContext == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return appContext;
    }

    static ThreadGroup getThreadGroupHelper(SecurityManager securityManager, ClassLoader classLoader, Class<?>[] classArray) {
        ThreadGroup threadGroup;
        Plugin2ClassLoader plugin2ClassLoader = SecurityManagerHelper.currentAppletClassLoader(classLoader, classArray);
        ThreadGroup threadGroup2 = threadGroup = plugin2ClassLoader == null ? null : plugin2ClassLoader.getThreadGroup();
        if (threadGroup != null) {
            return threadGroup;
        }
        return securityManager.getThreadGroup();
    }

    static {
        Field field = null;
        if (!Config.isJavaVersionAtLeast9()) {
            try {
                field = AccessControlContext.class.getDeclaredField("context");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(noSuchFieldException);
            }
        }
        fcontext = field;
        inThreadGroupCheck = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
    }
}

