/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer.context;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import netscape.javascript.JSObject;
import sun.applet.AppletPanel;
import sun.plugin.viewer.AppletPanelCache;
import sun.plugin.viewer.context.AppletAudioClipFactory;
import sun.plugin.viewer.context.AppletImageFactory;
import sun.plugin.viewer.context.PluginAppletContext;

public abstract class DefaultPluginAppletContext
implements PluginAppletContext {
    private ArrayList<SoftReference<JSObject>> exported = new ArrayList();
    protected AppletPanel appletPanel;
    private static HashMap<URL, SoftReference<Image>> imageRefs = new HashMap();
    private static HashMap<URL, HashMap<URL, SoftReference<AudioClip>>> audioClipStore = new HashMap();
    private int persistStreamMaxSize = 65536;
    private static HashMap<URL, HashMap<String, byte[]>> streamStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL uRL) {
        SoftReference<AudioClip> softReference;
        if (uRL == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                softReference = uRL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                return null;
            }
            if (softReference != null) {
                securityManager.checkPermission((Permission)((Object)softReference));
            }
        }
        softReference = null;
        Object object = audioClipStore;
        synchronized (object) {
            HashMap<URL, SoftReference<AudioClip>> hashMap = audioClipStore.get(this.appletPanel.getCodeBase());
            if (hashMap == null) {
                hashMap = new HashMap();
                audioClipStore.put(this.appletPanel.getCodeBase(), hashMap);
            }
            if ((softReference = hashMap.get(uRL)) == null || softReference.get() == null) {
                softReference = new SoftReference<AudioClip>(AppletAudioClipFactory.createAudioClip(uRL));
                hashMap.put(uRL, softReference);
            }
        }
        object = softReference.get();
        Trace.msgPrintln((String)"appletcontext.audio.loaded", (Object[])new Object[]{uRL}, (TraceLevel)TraceLevel.BASIC);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage(URL uRL) {
        SoftReference<Image> softReference;
        if (uRL == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                softReference = uRL.openConnection().getPermission();
            }
            catch (IOException iOException) {
                return null;
            }
            if (softReference != null) {
                securityManager.checkPermission((Permission)((Object)softReference));
            }
        }
        softReference = null;
        Object object = imageRefs;
        synchronized (object) {
            softReference = imageRefs.get(uRL);
            if (softReference == null || softReference.get() == null) {
                softReference = new SoftReference<Image>(AppletImageFactory.createImage(uRL));
                imageRefs.put(uRL, softReference);
            }
        }
        object = softReference.get();
        Trace.msgPrintln((String)"appletcontext.image.loaded", (Object[])new Object[]{uRL}, (TraceLevel)TraceLevel.BASIC);
        return object;
    }

    @Override
    public Applet getApplet(String string) {
        Object[] objectArray;
        string = string.toLowerCase();
        for (Object object : objectArray = AppletPanelCache.getAppletPanels()) {
            AppletPanel appletPanel = (AppletPanel)object;
            if (appletPanel == null || !appletPanel.isActive() && this.appletPanel != appletPanel) continue;
            String string2 = appletPanel.getParameter("name");
            if (string2 != null) {
                string2 = string2.toLowerCase();
            }
            if (!string.equals(string2) || !appletPanel.getDocumentBase().equals(this.appletPanel.getDocumentBase())) continue;
            try {
                if (!this.checkConnect(this.appletPanel.getCodeBase().getHost(), appletPanel.getCodeBase().getHost())) {
                    return null;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                this.showStatus(invocationTargetException.getTargetException().getMessage());
                return null;
            }
            catch (Exception exception) {
                this.showStatus(exception.getMessage());
                return null;
            }
            return appletPanel.getApplet();
        }
        return null;
    }

    @Override
    public Enumeration<Applet> getApplets() {
        Object[] objectArray;
        Vector<Applet> vector = new Vector<Applet>();
        for (Object object : objectArray = AppletPanelCache.getAppletPanels()) {
            AppletPanel appletPanel = (AppletPanel)object;
            if (appletPanel == null || !appletPanel.isActive() || !appletPanel.getDocumentBase().equals(this.appletPanel.getDocumentBase())) continue;
            try {
                if (!this.checkConnect(this.appletPanel.getCodeBase().getHost(), appletPanel.getCodeBase().getHost())) continue;
                vector.addElement(appletPanel.getApplet());
            }
            catch (InvocationTargetException exception) {
                this.showStatus(exception.getTargetException().getMessage());
            }
            catch (Exception exception) {
                this.showStatus(exception.getMessage());
            }
        }
        Applet applet = this.appletPanel.getApplet();
        if (!vector.contains(applet)) {
            vector.addElement(applet);
        }
        return vector.elements();
    }

    private boolean checkConnect(String string, String string2) throws Exception {
        SocketPermission socketPermission = new SocketPermission(string, "connect");
        SocketPermission socketPermission2 = new SocketPermission(string2, "connect");
        return socketPermission.implies(socketPermission2);
    }

    @Override
    public void showDocument(URL uRL) {
        this.showDocument(uRL, "_top");
    }

    @Override
    public void showDocument(URL uRL, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('_');
        }
        this.doShowDocument(uRL, stringBuilder.toString());
    }

    public void doShowDocument(final URL uRL, final String string) {
        DefaultPluginAppletContext defaultPluginAppletContext = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSObject jSObject = DefaultPluginAppletContext.this.getJSObject();
                    if (jSObject != null) {
                        Object[] objectArray = new Object[]{uRL.toString(), string};
                        jSObject.call("open", objectArray);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }, "showDocument Thread");
        thread.start();
    }

    @Override
    public void showStatus(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf("\n");
        if (n != -1) {
            this.doShowStatus(string.substring(0, n));
        } else {
            this.doShowStatus(string);
        }
    }

    protected void doShowStatus(final String string) {
        final DefaultPluginAppletContext defaultPluginAppletContext = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSObject jSObject = defaultPluginAppletContext.getJSObject();
                    if (jSObject != null) {
                        jSObject.eval("function setStatus() { self.status='" + string + "';};void(setTimeout(\"setStatus()\", 1500))");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }, "showStatus Thread");
        thread.start();
    }

    @Override
    public void addAppletPanelInContext(AppletPanel appletPanel) {
        this.appletPanel = appletPanel;
        AppletPanelCache.add(appletPanel);
    }

    @Override
    public void removeAppletPanelFromContext(AppletPanel appletPanel) {
        AppletPanelCache.remove(appletPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setStream(String string, InputStream inputStream) throws IOException {
        HashMap<String, Object> hashMap = streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap == null) {
            hashMap = new HashMap();
            streamStore.put(this.appletPanel.getCodeBase(), hashMap);
        }
        HashMap<String, byte[]> hashMap2 = hashMap;
        synchronized (hashMap2) {
            if (inputStream != null) {
                byte[] byArray = (byte[])hashMap.get(string);
                if (byArray == null) {
                    int n = inputStream.available();
                    if (n >= this.persistStreamMaxSize) throw new IOException("Stream size exceeds the maximum limit");
                    byArray = new byte[n];
                    inputStream.read(byArray, 0, n);
                    hashMap.put(string, byArray);
                } else {
                    hashMap.remove(string);
                    this.setStream(string, inputStream);
                }
            } else {
                hashMap.remove(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStream(String string) {
        ByteArrayInputStream byteArrayInputStream = null;
        HashMap<String, byte[]> hashMap = streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap != null) {
            HashMap<String, byte[]> hashMap2 = hashMap;
            synchronized (hashMap2) {
                byte[] byArray = hashMap.get(string);
                if (byArray != null) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                }
            }
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getStreamKeys() {
        Iterator<String> iterator = null;
        HashMap<String, byte[]> hashMap = streamStore.get(this.appletPanel.getCodeBase());
        if (hashMap != null) {
            HashMap<String, byte[]> hashMap2 = hashMap;
            synchronized (hashMap2) {
                iterator = hashMap.keySet().iterator();
            }
        }
        return iterator;
    }

    private String getNameFromURL(URL uRL) {
        try {
            String string = uRL.getFile();
            int n = string.lastIndexOf(47);
            return string.substring(n + 1);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJSObjectToExportedList(JSObject jSObject) {
        ArrayList<SoftReference<JSObject>> arrayList = this.exported;
        synchronized (arrayList) {
            this.exported.add(new SoftReference<JSObject>(jSObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        ArrayList<SoftReference<JSObject>> arrayList = this.exported;
        synchronized (arrayList) {
            for (SoftReference<JSObject> softReference : this.exported) {
                JSObject jSObject;
                if (softReference == null || (jSObject = softReference.get()) == null || !(jSObject instanceof sun.plugin.javascript.JSObject)) continue;
                ((sun.plugin.javascript.JSObject)jSObject).cleanup();
            }
            this.exported.clear();
        }
    }
}

