/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemPropertyUtil;
import java.io.PrintWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import sun.applet.AppletClassLoader;
import sun.applet.AppletPanel;
import sun.plugin.security.PluginClassLoader;

public class ClassLoaderInfo {
    private URL codebase;
    private String key;
    private int references = 0;
    private HashMap<String, String> jars;
    private boolean locked;
    private boolean isCachable = true;
    private static boolean initialized;
    private static HashMap<String, ArrayList<ClassLoaderInfo>> infos;
    private static int zombieLimit;
    private static ArrayList<ClassLoaderInfo> zombies;
    private LoaderReference loaderRef = null;
    private static ReferenceQueue<Object> refQueue;
    private boolean localJarsLoaded = false;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ClassLoaderInfo.reset();
    }

    public static synchronized void reset() {
        initialized = true;
        zombieLimit = 0;
        String string = SystemPropertyUtil.getProperty((String)"javaplugin.classloader.cache.enabled");
        if (string == null || string.equals("true")) {
            zombieLimit = SystemPropertyUtil.getIntProperty((String)"javaplugin.classloader.cache.sizes", (int)4);
        }
        if (zombieLimit > 4) {
            zombieLimit = 4;
        }
    }

    public static synchronized void clearClassLoaderCache() {
        for (ClassLoaderInfo object2 : zombies) {
            if (object2 == null) continue;
            infos.remove(object2.key);
            object2.clearLoaderRef();
        }
        zombies.clear();
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        if (collection != null) {
            Iterator<ArrayList<ClassLoaderInfo>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                ClassLoaderInfo classLoaderInfo2 = null;
                ArrayList<ClassLoaderInfo> arrayList = iterator.next();
                if (arrayList == null) continue;
                for (ClassLoaderInfo classLoaderInfo2 : arrayList) {
                    if (classLoaderInfo2 == null) continue;
                    classLoaderInfo2.isCachable = false;
                }
            }
        }
        AppletPanel.flushClassLoaders();
    }

    public static synchronized void dumpClassLoaderCache(PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Dump classloader list ...\n");
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        if (collection != null) {
            for (ArrayList<ClassLoaderInfo> arrayList : collection) {
                if (arrayList == null) continue;
                for (ClassLoaderInfo classLoaderInfo : arrayList) {
                    if (classLoaderInfo == null || classLoaderInfo.loaderRef == null || classLoaderInfo.loaderRef.get() == null) continue;
                    boolean bl = zombies.contains(classLoaderInfo);
                    stringBuilder.append("    codebase=" + classLoaderInfo.codebase);
                    stringBuilder.append(", key=" + classLoaderInfo.key);
                    stringBuilder.append(", zombie=" + bl);
                    stringBuilder.append(", cache=" + classLoaderInfo.isCachable);
                    stringBuilder.append(", refcount=" + classLoaderInfo.references);
                    stringBuilder.append(", info=" + classLoaderInfo);
                    stringBuilder.append("\n");
                }
            }
        }
        stringBuilder.append("Done.");
        printWriter.println(stringBuilder.toString());
    }

    public static synchronized void markNotCachable(URL uRL, String string) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo classLoaderInfo = ClassLoaderInfo.getUsableClassLoaderInfo(string);
        if (classLoaderInfo != null) {
            classLoaderInfo.isCachable = false;
            if (zombies.remove(classLoaderInfo)) {
                ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo);
            }
            AppletPanel.flushClassLoader((String)string);
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    private static synchronized void removeClassLoaderInfo(ClassLoaderInfo classLoaderInfo) {
        ArrayList<ClassLoaderInfo> arrayList = infos.get(classLoaderInfo.key);
        if (arrayList != null) {
            arrayList.remove(classLoaderInfo);
            if (arrayList.isEmpty()) {
                infos.remove(classLoaderInfo.key);
            }
        }
        classLoaderInfo.clearLoaderRef();
    }

    private static synchronized void addClassLoaderInfo(ClassLoaderInfo classLoaderInfo) {
        ArrayList<ClassLoaderInfo> arrayList = infos.get(classLoaderInfo.key);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(classLoaderInfo);
            infos.put(classLoaderInfo.key, arrayList);
        } else {
            arrayList.add(classLoaderInfo);
        }
    }

    private static synchronized ClassLoaderInfo getUsableClassLoaderInfo(String string) {
        ArrayList<ClassLoaderInfo> arrayList = infos.get(string);
        if (arrayList != null) {
            Iterator<ClassLoaderInfo> iterator = arrayList.iterator();
            ClassLoaderInfo classLoaderInfo = null;
            while (iterator.hasNext()) {
                classLoaderInfo = iterator.next();
                if (!classLoaderInfo.isCachable) continue;
                return classLoaderInfo;
            }
        }
        return null;
    }

    public static synchronized ClassLoaderInfo find(URL uRL, String string) {
        assert (ClassLoaderInfo.checkListsValidity());
        ClassLoaderInfo.initialize();
        if (uRL == null) {
            return null;
        }
        ClassLoaderInfo classLoaderInfo = ClassLoaderInfo.getUsableClassLoaderInfo(string);
        if (classLoaderInfo != null) {
            zombies.remove(classLoaderInfo);
        } else {
            classLoaderInfo = new ClassLoaderInfo(uRL, string);
            ClassLoaderInfo.addClassLoaderInfo(classLoaderInfo);
        }
        assert (ClassLoaderInfo.checkListsValidity());
        return classLoaderInfo;
    }

    public synchronized void addReference() {
        ++this.references;
        Trace.msgPrintln((String)"classloaderinfo.referencing", (Object[])new Object[]{this, String.valueOf(this.references)}, (TraceLevel)TraceLevel.BASIC);
    }

    synchronized int removeReference() {
        --this.references;
        Trace.msgPrintln((String)"classloaderinfo.releasing", (Object[])new Object[]{this, String.valueOf(this.references)}, (TraceLevel)TraceLevel.BASIC);
        if (this.references < 0) {
            throw new Error("negative ref count???");
        }
        if (this.references == 0) {
            ClassLoaderInfo.addZombie(this);
        }
        return this.references;
    }

    private static synchronized void addZombie(ClassLoaderInfo classLoaderInfo) {
        assert (ClassLoaderInfo.checkListsValidity());
        AppletPanel.flushClassLoader((String)classLoaderInfo.key);
        if (zombieLimit == 0 || !classLoaderInfo.isCachable) {
            ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo);
        } else {
            Trace.msgPrintln((String)"classloaderinfo.caching", (Object[])new Object[]{classLoaderInfo}, (TraceLevel)TraceLevel.BASIC);
            AppletClassLoader appletClassLoader = (AppletClassLoader)classLoaderInfo.loaderRef.get();
            if (appletClassLoader != null && appletClassLoader.getExceptionStatus()) {
                classLoaderInfo.clearLoaderRef();
            }
            zombies.add(classLoaderInfo);
            ClassLoaderInfo.cleanupZombies();
            Trace.msgPrintln((String)"classloaderinfo.cachesize", (Object[])new Object[]{zombies.size()}, (TraceLevel)TraceLevel.BASIC);
            if (zombies.size() > zombieLimit) {
                ClassLoaderInfo classLoaderInfo2 = zombies.get(0);
                Trace.msgPrintln((String)"classloaderinfo.num", (Object[])new Object[]{String.valueOf(zombieLimit), classLoaderInfo2}, (TraceLevel)TraceLevel.BASIC);
                zombies.remove(0);
                ClassLoaderInfo.removeClassLoaderInfo(classLoaderInfo2);
                classLoaderInfo2.clearLoaderRef();
            }
        }
        assert (ClassLoaderInfo.checkListsValidity());
    }

    public synchronized AppletClassLoader getLoader() {
        AppletClassLoader appletClassLoader = null;
        if (this.loaderRef != null) {
            appletClassLoader = (AppletClassLoader)this.loaderRef.get();
        }
        if (appletClassLoader == null) {
            appletClassLoader = AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

                @Override
                public PluginClassLoader run() {
                    return new PluginClassLoader(ClassLoaderInfo.this.codebase);
                }
            });
            this.loaderRef = new LoaderReference((ClassLoader)appletClassLoader);
            this.jars.clear();
            this.localJarsLoaded = false;
        }
        return appletClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppletClassLoader grabClassLoader() {
        AppletClassLoader appletClassLoader = null;
        ClassLoaderInfo classLoaderInfo = this;
        synchronized (classLoaderInfo) {
            appletClassLoader = this.getLoader();
            this.addReference();
        }
        appletClassLoader.getThreadGroup();
        return appletClassLoader;
    }

    private synchronized void clearLoaderRef() {
        if (this.loaderRef != null) {
            this.loaderRef.clear();
            this.loaderRef = null;
        }
    }

    private static synchronized void cleanupZombies() {
        LoaderReference loaderReference = (LoaderReference)refQueue.poll();
        while (loaderReference != null) {
            String string = loaderReference.getKey();
            ArrayList<ClassLoaderInfo> arrayList = infos.get(string);
            if (arrayList != null) {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                for (ClassLoaderInfo classLoaderInfo : arrayList2) {
                    if (classLoaderInfo.loaderRef != loaderReference || !zombies.contains(classLoaderInfo)) continue;
                    arrayList.remove(classLoaderInfo);
                    zombies.remove(classLoaderInfo);
                }
            }
            loaderReference = (LoaderReference)refQueue.poll();
        }
    }

    private ClassLoaderInfo(URL uRL, String string) {
        this.codebase = uRL;
        this.key = string;
        this.jars = new HashMap();
    }

    synchronized void addJar(String string) {
        this.jars.put(string, string);
    }

    synchronized boolean hasJar(String string) {
        return this.jars.get(string) != null;
    }

    public boolean getLocalJarsLoaded() {
        return this.localJarsLoaded;
    }

    public void setLocalJarsLoaded(boolean bl) {
        this.localJarsLoaded = bl;
    }

    public final synchronized void lock() throws InterruptedException {
        while (this.locked) {
            this.wait();
        }
        this.locked = true;
    }

    public final synchronized void unlock() {
        this.locked = false;
        this.notifyAll();
    }

    public static synchronized boolean checkListsValidity() {
        ClassLoaderInfo classLoaderInfo2 = null;
        Collection<ArrayList<ClassLoaderInfo>> collection = infos.values();
        for (ArrayList<ClassLoaderInfo> arrayList : collection) {
            if (arrayList == null) continue;
            int n = 0;
            for (ClassLoaderInfo classLoaderInfo2 : arrayList) {
                if (classLoaderInfo2 == null || !classLoaderInfo2.isCachable) continue;
                ++n;
            }
            if (n <= true) continue;
            return false;
        }
        for (ClassLoaderInfo classLoaderInfo2 : zombies) {
            if (classLoaderInfo2 == null || classLoaderInfo2.isCachable) continue;
            return false;
        }
        return true;
    }

    static {
        infos = new HashMap();
        zombieLimit = 0;
        zombies = new ArrayList();
        refQueue = new ReferenceQueue();
    }

    private class LoaderReference
    extends SoftReference<Object> {
        public LoaderReference(ClassLoader classLoader) {
            super(classLoader, refQueue);
        }

        public String getCodebase() {
            return ClassLoaderInfo.this.codebase.toString();
        }

        public String getKey() {
            return ClassLoaderInfo.this.key;
        }
    }
}

