/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SafeThreadFactory;
import com.sun.javaws.util.JNLPUtils;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import java.awt.AWTPermission;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private static ApiDialog _apiDialog = new ApiDialog();
    private PageFormat _pageFormat = null;
    private static final AccessControlContext ACC_PRINT_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            AWTPermission perm = new AWTPermission("accessClipboard");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });
    private static final AccessControlContext ACC_FILE_INSTANCE = AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

        @Override
        public AccessControlContext run() {
            Permissions perms = new Permissions();
            FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
            ((PermissionCollection)perms).add(perm);
            return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        }
    });

    private PrintServiceImpl() {
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    public PageFormat getDefaultPage() {
        return AccessController.doPrivileged(new PrivilegedAction<PageFormat>(){

            @Override
            public PageFormat run() {
                PrinterJob sysPrinterJob = PrinterJob.getPrinterJob();
                if (sysPrinterJob != null) {
                    return sysPrinterJob.defaultPage();
                }
                return null;
            }
        }, ACC_PRINT_INSTANCE);
    }

    public PageFormat showPageFormatDialog(final PageFormat page) {
        return AccessController.doPrivileged(new PrivilegedAction<PageFormat>(){

            @Override
            public PageFormat run() {
                PrinterJob sysPrinterJob = PrinterJob.getPrinterJob();
                if (sysPrinterJob != null) {
                    PrintServiceImpl.this._pageFormat = sysPrinterJob.pageDialog(page);
                    return PrintServiceImpl.this._pageFormat;
                }
                return null;
            }
        }, ACC_PRINT_INSTANCE);
    }

    public synchronized boolean print(Pageable document) {
        return this.doPrinting(null, document);
    }

    public synchronized boolean print(Printable painter) {
        return this.doPrinting(painter, null);
    }

    private boolean doPrinting(final Printable painter, final Pageable document) {
        if (!this.askUser()) {
            return false;
        }
        boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                final PrinterJob sysPrinterJob = PrinterJob.getPrinterJob();
                if (sysPrinterJob == null) {
                    return Boolean.FALSE;
                }
                if (document != null) {
                    sysPrinterJob.setPageable(document);
                } else if (PrintServiceImpl.this._pageFormat == null) {
                    sysPrinterJob.setPrintable(painter);
                } else {
                    sysPrinterJob.setPrintable(painter, PrintServiceImpl.this._pageFormat);
                }
                if (sysPrinterJob.printDialog()) {
                    Thread t = SafeThreadFactory.createThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                sysPrinterJob.print();
                            }
                            catch (PrinterException pe) {
                                Trace.ignoredException((Exception)pe);
                            }
                        }
                    });
                    t.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, ACC_PRINT_INSTANCE);
        return result;
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return PrintServiceImpl.requestPrintPermission();
    }

    public static boolean requestPrintPermission() {
        String key;
        final LocalApplicationProperties lap = JNLPUtils.getLocalApplicationProperties();
        if (lap != null && (key = lap.get("jnlp.api.always.PrintService.print")) != null) {
            return true;
        }
        ApiDialog.DialogResult result = _apiDialog.askUser(ResourceManager.getString((String)"api.print.title"), ResourceManager.getString((String)"api.print.message"), ResourceManager.getString((String)"api.print.always"));
        if (result == ApiDialog.DialogResult.ALWAYS) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    lap.put("jnlp.api.always.PrintService.print", "skip");
                    try {
                        lap.store();
                    }
                    catch (Throwable e) {
                        Trace.ignored((Throwable)e);
                    }
                    return null;
                }
            }, ACC_FILE_INSTANCE);
        }
        return result == ApiDialog.DialogResult.OK || result == ApiDialog.DialogResult.ALWAYS;
    }
}

