/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.jnlp.FileContentsImpl;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

final class MeteredFileOutputStreamNSB
extends OutputStream {
    static String _message = null;
    private final FileContentsImpl _contents;
    private long _written = 0L;
    private final OutputStream _os;

    MeteredFileOutputStreamNSB(File file, boolean overwrite, FileContentsImpl callback) throws IOException {
        this._os = Platform.get().getNativeSandboxBroker().getOutputStream(file, overwrite);
        this._contents = callback;
        this._written = file.length();
        if (_message == null) {
            _message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkWrite(1);
        this._os.write(b);
        ++this._written;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkWrite(len);
        this._os.write(b, off, len);
        this._written += (long)len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this._os.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this._os.flush();
        super.flush();
    }

    private void checkWrite(int len) throws IOException {
        if (len < 0 || this._contents.getMaxLength() - this._written < (long)len) {
            throw new IOException(_message);
        }
    }
}

