/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.util;

import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.ui.AppInfo;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JNLPUtils {
    public static void sortResourcesForClasspath(ResourcesDesc rd, List<JARDesc> jarsInURLClassLoader, List<JARDesc> jarsNotInURLClassLoader) {
        int i;
        ArrayList<JARDesc> lazyJars = new ArrayList<JARDesc>();
        ArrayList<JARDesc> mainJars = new ArrayList<JARDesc>();
        ArrayList<JARDesc> eagerJars = new ArrayList<JARDesc>();
        HashSet<JARDesc> tmpAddedJars = new HashSet<JARDesc>();
        JARDesc[] allJarDescs = rd.getEagerOrAllJarDescs(true);
        tmpAddedJars.addAll(jarsInURLClassLoader);
        for (i = 0; i < allJarDescs.length; ++i) {
            if (allJarDescs[i].isNativeLib()) continue;
            if (allJarDescs[i].isProgressJar()) {
                JNLPUtils.addLoadedJarsEntry(tmpAddedJars, jarsInURLClassLoader, allJarDescs[i]);
                continue;
            }
            if (allJarDescs[i].isMainJarFile()) {
                mainJars.add(allJarDescs[i]);
                continue;
            }
            if (!allJarDescs[i].isLazyDownload()) {
                eagerJars.add(allJarDescs[i]);
                continue;
            }
            if (!rd.isPackagePart(allJarDescs[i].getPartName())) {
                lazyJars.add(allJarDescs[i]);
                continue;
            }
            jarsNotInURLClassLoader.add(allJarDescs[i]);
        }
        for (i = 0; i < mainJars.size(); ++i) {
            JNLPUtils.addLoadedJarsEntry(tmpAddedJars, jarsInURLClassLoader, (JARDesc)mainJars.get(i));
        }
        for (i = 0; i < eagerJars.size(); ++i) {
            JNLPUtils.addLoadedJarsEntry(tmpAddedJars, jarsInURLClassLoader, (JARDesc)eagerJars.get(i));
        }
        for (i = 0; i < lazyJars.size(); ++i) {
            JNLPUtils.addLoadedJarsEntry(tmpAddedJars, jarsInURLClassLoader, (JARDesc)lazyJars.get(i));
        }
    }

    public static LocalApplicationProperties getLocalApplicationProperties() {
        LocalApplicationProperties lap = null;
        AppInfo ai = JNLPClassLoaderUtil.getInstance().getLaunchDesc().getAppInfo();
        if (ai != null) {
            lap = ResourceProvider.get().getLocalApplicationProperties(ai.getLapURL(), null, true);
        }
        return lap;
    }

    private static void addLoadedJarsEntry(Set<JARDesc> addedJars, List<JARDesc> jarsInURLClassLoader, JARDesc jd) {
        if (!addedJars.contains(jd)) {
            jarsInURLClassLoader.add(jd);
            addedJars.add(jd);
        }
    }
}

