/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.net.DownloadException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.uitoolkit.ui.ConsoleWindow;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javaws.Globals;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsConsoleController;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.GeneralSecurityException;

public class LaunchErrorDialog {
    private static String getMoreInfo(Throwable throwable) {
        PrintWriter pw;
        StringWriter sw;
        StringBuilder sb = new StringBuilder();
        String delim = "<split>";
        JNLPException jnlpException = null;
        DownloadException dlException = null;
        Throwable wrappedThrowable = null;
        if (throwable instanceof JNLPException) {
            jnlpException = (JNLPException)throwable;
            wrappedThrowable = jnlpException.getWrappedException();
        } else if (throwable instanceof DownloadException) {
            dlException = (DownloadException)throwable;
            wrappedThrowable = dlException.getWrappedException();
        } else if (throwable instanceof ExitException) {
            wrappedThrowable = ((ExitException)throwable).getException();
        }
        sb.append(LaunchErrorDialog.getErrorDescription(throwable));
        String errorLaunchDescSource = null;
        String mainLaunchDescSource = null;
        if (jnlpException != null) {
            LaunchDesc ld;
            errorLaunchDescSource = jnlpException.getLaunchDescSource();
            if (errorLaunchDescSource == null && (ld = JNLPException.getDefaultLaunchDesc()) != null) {
                errorLaunchDescSource = ld.getSource();
            }
        } else if (JNLPException.getDefaultLaunchDesc() != null) {
            errorLaunchDescSource = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (JNLPException.getDefaultLaunchDesc() != null) {
            mainLaunchDescSource = JNLPException.getDefaultLaunchDesc().getSource();
        }
        if (mainLaunchDescSource != null && mainLaunchDescSource.equals(errorLaunchDescSource)) {
            mainLaunchDescSource = null;
        }
        if (errorLaunchDescSource != null) {
            sb.append(delim);
            sb.append(ResourceManager.getString((String)"launcherrordialog.jnlpTab"));
            sb.append(delim);
            sb.append(LaunchErrorDialog.filter(errorLaunchDescSource));
        }
        if (mainLaunchDescSource != null) {
            sb.append(delim);
            sb.append(ResourceManager.getString((String)"launcherrordialog.jnlpMainTab"));
            sb.append(delim);
            sb.append(LaunchErrorDialog.filter(mainLaunchDescSource));
        }
        if (throwable != null) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            sb.append(delim);
            sb.append(ResourceManager.getString((String)"launcherrordialog.exceptionTab"));
            sb.append(delim);
            sb.append(sw.toString());
        }
        if (wrappedThrowable != null) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            wrappedThrowable.printStackTrace(pw);
            sb.append(delim);
            sb.append(ResourceManager.getString((String)"launcherrordialog.wrappedExceptionTab"));
            sb.append(delim);
            sb.append(sw.toString());
        }
        JavawsConsoleController controller = JavawsConsoleController.getInstance();
        ConsoleWindow cw = ToolkitStore.getUI().getConsole((ConsoleController)controller);
        controller.setConsole(cw);
        if (cw != null) {
            sb.append(delim);
            sb.append(ResourceManager.getString((String)"launcherrordialog.consoleTab"));
            try {
                sb.append(delim);
                sb.append(cw.getRecentLog());
            }
            catch (Exception e) {
                Trace.ignored((Throwable)e);
            }
        }
        return sb.toString();
    }

    private static String filter(String jnlpString) {
        if (jnlpString.length() > 10240) {
            return jnlpString.substring(0, 10239) + "\njnlp file truncated after 10K\n";
        }
        return jnlpString;
    }

    public static void show(final Object owner, final Throwable throwable, boolean exit) {
        boolean showit;
        SplashScreen.hide();
        System.err.println("#### Java Web Start Error:");
        System.err.println("#### " + LaunchErrorDialog.getMessage(throwable));
        if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
            throwable.printStackTrace(System.err);
        }
        boolean bl = showit = !Globals.TCKHarnessRun && !Globals.isSilentMode();
        if (throwable instanceof ExitException && ((ExitException)throwable).getReason() == 0) {
            showit = false;
        }
        if (showit) {
            DeploySysAction action = new DeploySysAction(){

                public Object execute() {
                    Throwable _t = throwable;
                    try {
                        ExitException ee;
                        String message = null;
                        String errorKind = LaunchErrorDialog.getErrorCategory(throwable);
                        if (throwable instanceof JNLPException) {
                            message = ((JNLPException)throwable).getBriefMessage();
                        } else if (throwable instanceof ExitException && (ee = (ExitException)throwable).getReason() == 6) {
                            message = ee.getMessage();
                            _t = ee.getException();
                        }
                        if (message == null) {
                            message = Environment.isImportMode() ? (Environment.isInstallMode() ? ResourceManager.getString((String)"launcherrordialog.uninstall.brief.message") : ResourceManager.getString((String)"launcherrordialog.import.brief.message")) : ResourceManager.getString((String)"launcherrordialog.brief.message");
                        }
                        AppInfo ainfo = LaunchErrorDialog.getLaunchDesc() == null ? new AppInfo() : LaunchErrorDialog.getLaunchDesc().getAppInfo();
                        ainfo.setThrowable(_t);
                        String okBtn = ResourceManager.getString((String)"launcherrordialog.brief.ok");
                        String detailBtn = ResourceManager.getString((String)"launcherrordialog.brief.details");
                        String title = ResourceManager.getString((String)"error.default.title", (Object[])new Object[]{errorKind});
                        ToolkitStore.getUI().showMessageDialog(owner, ainfo, 0, title, null, message, LaunchErrorDialog.getMoreInfo(_t), okBtn, detailBtn, null);
                    }
                    catch (Exception ee) {
                        Trace.ignored((Throwable)ee);
                    }
                    return null;
                }
            };
            DeploySysRun.execute((DeploySysAction)action, null);
        }
        if (exit) {
            try {
                Main.systemExit(-1);
            }
            catch (ExitException ee) {
                Trace.println((String)("systemExit: " + ee), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)ee);
            }
        }
    }

    private static String getErrorCategory(Throwable e) {
        String errorKind = ResourceManager.getString((String)"launch.error.category.unexpected");
        if (e instanceof JNLPException) {
            JNLPException je = (JNLPException)e;
            errorKind = je.getCategory();
        } else if (e instanceof SecurityException || e instanceof GeneralSecurityException) {
            errorKind = ResourceManager.getString((String)"launch.error.category.security");
        } else if (e instanceof OutOfMemoryError) {
            errorKind = ResourceManager.getString((String)"launch.error.category.memory");
        } else if (e instanceof DownloadException) {
            errorKind = ResourceManager.getString((String)"launch.error.category.download");
        }
        return errorKind;
    }

    private static String getErrorDescription(Throwable e) {
        String errorDescription = LaunchErrorDialog.getMessage(e);
        if (errorDescription == null) {
            errorDescription = ResourceManager.getString((String)"launcherrordialog.genericerror", (Object[])new Object[]{e.getClass().getName()});
        }
        return errorDescription;
    }

    private static String getMessage(Throwable t) {
        if (t instanceof Exception) {
            if (t.getCause() != null) {
                return t.getMessage() + " from: " + t.getCause().getMessage();
            }
            return t.getMessage();
        }
        return t.getClass().getName() + ": " + t.getMessage();
    }

    private static LaunchDesc getLaunchDesc() {
        return JNLPException.getDefaultLaunchDesc();
    }
}

