/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.PluginMessage;
import sun.plugin2.message.Serializer;

public class SetJVMIDMessage
extends PluginMessage {
    public static final int ID = 1;
    private int jvmID;
    private int browserType;
    private boolean separateJVM;
    private String[][] properties;
    private String userHome;
    private boolean htmlJavaArgs;
    private boolean isModalityDisabled;

    public SetJVMIDMessage(Conversation c) {
        super(1, c);
    }

    public SetJVMIDMessage(Conversation c, int jvmID, int browserType, boolean separateJVM, boolean isModalityDisabled, boolean htmlJavaArgs, String userHome, String[][] params) {
        super(1, c);
        this.jvmID = jvmID;
        this.browserType = browserType;
        this.separateJVM = separateJVM;
        this.isModalityDisabled = isModalityDisabled;
        this.htmlJavaArgs = htmlJavaArgs;
        this.userHome = userHome;
        this.properties = new String[params.length][];
        for (int i = 0; i < params.length; ++i) {
            this.properties[i] = (String[])params[i].clone();
        }
    }

    @Override
    public void writeFields(Serializer ser) throws IOException {
        ser.writeInt(this.jvmID);
        ser.writeInt(this.browserType);
        ser.writeBoolean(this.separateJVM);
        ser.writeBoolean(this.isModalityDisabled);
        ser.writeBoolean(this.htmlJavaArgs);
        ser.writeUTF(this.userHome);
        ser.writeInt(this.properties.length);
        for (String[] property : this.properties) {
            ser.writeUTFArray(property);
        }
    }

    @Override
    public void readFields(Serializer ser) throws IOException {
        this.jvmID = ser.readInt();
        this.browserType = ser.readInt();
        this.separateJVM = ser.readBoolean();
        this.isModalityDisabled = ser.readBoolean();
        this.htmlJavaArgs = ser.readBoolean();
        this.userHome = ser.readUTF();
        int numberOfArray = ser.readInt();
        this.properties = new String[numberOfArray][];
        for (int i = 0; i < this.properties.length; ++i) {
            this.properties[i] = ser.readUTFArray();
        }
    }

    public int getJVMID() {
        return this.jvmID;
    }

    public int getBrowserType() {
        return this.browserType;
    }

    public boolean isSeparateJVM() {
        return this.separateJVM;
    }

    public boolean isModalityDisabled() {
        return this.isModalityDisabled;
    }

    public boolean isHtmlJavaArgs() {
        return this.htmlJavaArgs;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public String[][] getParameters() {
        String[][] outParams = new String[this.properties.length][];
        for (int idx = 0; idx < this.properties.length; ++idx) {
            outParams[idx] = (String[])this.properties[idx].clone();
        }
        return outParams;
    }
}

