/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.Launcher;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.InvalidArgumentException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppContextUtil;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.javaws.ui.SplashScreen;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import sun.plugin2.applet.viewer.JNLP2Viewer;
import sun.plugin2.uitoolkit.PluginUIToolkit;

public class WebStart {
    private String[] _args = null;
    private Launcher _launcher = null;

    public static void main(String[] args) {
        Trace.redirectStdioStderr();
        new WebStart().performLaunch(args);
    }

    private void performLaunch(final String[] args) {
        try {
            PluginUIToolkit.initPluginToolkit();
            Main.initApp((String[])args);
            new Thread(Main.getSecurityThreadGroup(), new Runnable(){

                @Override
                public void run() {
                    AppContextUtil.createSecurityAppContext();
                    Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                    try {
                        WebStart.this.continueInSecureThread(args);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    Trace.flush();
                }
            }, "Java Web Start Main Thread").start();
        }
        catch (Throwable e) {
            LaunchErrorDialog.show(null, (Throwable)e, (boolean)true);
        }
    }

    private void continueInSecureThread(String[] argsin) {
        String[] args = Main.prepareArguments((String[])argsin);
        if (Cache.canWrite() || Main.isViewer()) {
            Main.initEnvironment();
            if (Main.isUninstall()) {
                Main.uninstallCache(args.length > 0 ? args[0] : null);
            } else {
                if (DeployOfflineManager.isGlobalOffline()) {
                    JnlpxArgs.SetIsOffline();
                    DeployOfflineManager.setForcedOffline((boolean)true);
                }
                if (Main.needToUpdateBaseline()) {
                    SecurityBaseline.forceBaselineUpdate();
                } else if (!Main.isViewer()) {
                    if (Globals.TCKHarnessRun) {
                        Environment.setGlobalException((boolean)true);
                        Main.tckprintln((String)"Java Started");
                    }
                    if (args.length > 0) {
                        if (Environment.isImportMode()) {
                            for (int i = 0; i < args.length; ++i) {
                                int argIndex = i == 0 ? args.length - 1 : i - 1;
                                boolean exit = i == args.length - 1;
                                this.launchApp(args[argIndex], exit);
                            }
                        } else {
                            if (args.length != 1) {
                                JnlpxArgs.removeArgumentFile((String)args[args.length - 1]);
                                LaunchErrorDialog.show(null, (Throwable)new InvalidArgumentException(args), (boolean)true);
                                return;
                            }
                            DeploymentRuleSet.initialize();
                            this.launchApp(args[0], true);
                        }
                    }
                } else {
                    if (args.length > 0) {
                        JnlpxArgs.removeArgumentFile((String)args[0]);
                    }
                    try {
                        String onearg = Main.isSilent() ? "-store" : "-viewer";
                        String[] jcpargs = new String[]{onearg};
                        Main.launchJavaControlPanel((String[])jcpargs);
                    }
                    catch (Exception e) {
                        LaunchErrorDialog.show(null, (Throwable)e, (boolean)true);
                    }
                }
            }
        } else {
            LaunchErrorDialog.show(null, (Throwable)new CacheAccessException(Environment.isSystemCacheMode()), (boolean)true);
        }
        Trace.flush();
        SplashScreen.hide();
    }

    private void launchApp(String arg, boolean exit) {
        LaunchDesc ld = Main.prepareLaunchDesc((String)arg, (boolean)exit);
        if (ld == null) {
            return;
        }
        if (ld.getLaunchType() == 5) {
            JnlpxArgs.removeArgumentFile((String)arg);
            String tab = ld.getInternalCommand();
            String[] argv = tab != null && !tab.equals("player") && !tab.equals("viewer") ? new String[]{"-tab", ld.getInternalCommand()} : new String[]{"-viewer"};
            Main.launchJavaControlPanel((String[])argv);
        } else if (Config.get().isValid()) {
            String[] args = new String[]{arg};
            this._launcher = new Launcher(ld, args, exit);
            this.launchApp();
        } else {
            LaunchErrorDialog.show(null, (Throwable)new LaunchDescException(ld, ResourceManager.getString((String)"enterprize.cfg.mandatory", (Object[])new Object[]{Config.get().getEnterpriseString()}), null), (boolean)exit);
        }
    }

    private void launchApp() {
        if (this._launcher.checkForSingleInstance()) {
            return;
        }
        if (this.prepareToLaunch()) {
            this._launcher.initiateUpdateCheck();
            if (this._launcher.useAppletLifecycle()) {
                return;
            }
            new Thread(Main.getLaunchThreadGroup(), (Runnable)this._launcher, "javawsApplicationMain").start();
        } else if (!Environment.isImportMode()) {
            LaunchErrorDialog.show((Object)Progress.get(null).getOwner(), (Throwable)new Exception(ResourceManager.getString((String)"launch.error.category.unexpected")), (boolean)true);
        }
    }

    private boolean prepareToLaunch() {
        boolean tryOffline = this._launcher.tryOffline();
        try {
            if (!tryOffline && DeployOfflineManager.isForcedOffline()) {
                Launcher launcher = this._launcher;
                Objects.requireNonNull(launcher);
                throw new Launcher.CacheUpdateRequiredException(launcher, "Forced offline mode!");
            }
            boolean ret = this.prepareToLaunch(tryOffline);
            return ret;
        }
        catch (Launcher.CacheUpdateRequiredException e) {
            return this._launcher.handleCacheUpdateRequiredException(e, tryOffline);
        }
    }

    private boolean prepareToLaunch(boolean offlineOnly) throws Launcher.CacheUpdateRequiredException {
        try {
            LaunchDesc ld = this._launcher.updateLaunchDesc(offlineOnly);
            if (this._launcher.useAppletLifecycle() && !this._launcher.isImport()) {
                this.launchAppUsingAppletLifecycle(ld);
                return true;
            }
            this._launcher.prepareAllResources(offlineOnly);
        }
        catch (Launcher.CacheUpdateRequiredException e) {
            throw e;
        }
        catch (Throwable t) {
            this._launcher.handleExitException(t);
            return false;
        }
        return true;
    }

    private void launchAppUsingAppletLifecycle(LaunchDesc ld) throws ExitException {
        Environment.setJavawsAppletLifecycle((boolean)true);
        if (ld.getResources() == null) {
            this._launcher.handleJnlpFileException(ld, (Exception)((Object)new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.noappresources", (Object[])new Object[]{ld.getSpecVersion()}), null)));
        }
        this.executeApplet(ld, this._launcher.getLap(), ld.getCodebase().toString(), ld.getDocumentBase().toString(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeApplet(LaunchDesc ld, LocalApplicationProperties lap, String codebase, String documentBase, boolean isAppletDescApplet) {
        block16: {
            File cachedFile;
            block15: {
                URL href = ld.getCanonicalHome();
                cachedFile = null;
                try {
                    String path = ResourceProvider.get().getCachedResourceFilePath(href, null);
                    if (path != null) {
                        cachedFile = new File(path);
                    }
                }
                catch (Exception ex) {
                    if (!Trace.isEnabled((TraceLevel)TraceLevel.CACHE)) break block15;
                    Trace.ignored((Throwable)ex);
                }
            }
            if (cachedFile != null) {
                if (!isAppletDescApplet) {
                    String actionName = SingleInstanceManager.getActionName();
                    if (actionName != null && (actionName.equals("-open") || actionName.equals("-print"))) {
                        this._args = new String[3];
                        this._args[0] = actionName;
                        this._args[1] = SingleInstanceManager.getOpenPrintFilePath();
                        this._args[2] = cachedFile.toString();
                    } else if (lap.isDraggedApplet()) {
                        this._args = new String[2];
                        this._args[0] = "-draggedApplet";
                        this._args[1] = cachedFile.toString();
                    } else {
                        this._args = new String[1];
                        this._args[0] = cachedFile.toString();
                    }
                } else {
                    this._args = new String[5];
                    this._args[0] = "-codebase";
                    this._args[1] = codebase;
                    this._args[2] = "-documentbase";
                    this._args[3] = documentBase;
                    this._args[4] = cachedFile.toString();
                }
                DeployOfflineManager.setForcedOffline((boolean)false);
                final Throwable[] e = new Throwable[]{null};
                try {
                    Thread t = new Thread(Main.getMainThreadGroup(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JNLP2Viewer.main(WebStart.this._args);
                            }
                            catch (Throwable t) {
                                e[0] = t;
                            }
                        }
                    });
                    t.start();
                    t.join();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                finally {
                    if (e[0] == null) break block16;
                    throw new RuntimeException(e[0]);
                }
            }
        }
    }
}

