/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.liveconnect;

import java.io.IOException;
import sun.plugin2.message.Serializer;

public class RemoteJavaObject {
    private int jvmID;
    private int appletID;
    private int objectID;
    private boolean isApplet;

    public RemoteJavaObject(int jvmID, int appletID, int objectID, boolean isApplet) {
        this.jvmID = jvmID;
        this.appletID = appletID;
        this.objectID = objectID;
        this.isApplet = isApplet;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteJavaObject other = (RemoteJavaObject)o;
        return this.jvmID == other.jvmID && this.appletID == other.appletID && this.objectID == other.objectID && this.isApplet == other.isApplet;
    }

    public int hashCode() {
        return this.jvmID ^ this.appletID ^ this.objectID;
    }

    public int getJVMID() {
        return this.jvmID;
    }

    public int getAppletID() {
        return this.appletID;
    }

    public int getObjectID() {
        return this.objectID;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public static void write(Serializer ser, RemoteJavaObject obj) throws IOException {
        if (obj == null) {
            ser.writeBoolean(false);
        } else {
            ser.writeBoolean(true);
            ser.writeInt(obj.getJVMID());
            ser.writeInt(obj.getAppletID());
            ser.writeInt(obj.getObjectID());
            ser.writeBoolean(obj.isApplet());
        }
    }

    public static RemoteJavaObject read(Serializer ser) throws IOException {
        if (!ser.readBoolean()) {
            return null;
        }
        return new RemoteJavaObject(ser.readInt(), ser.readInt(), ser.readInt(), ser.readBoolean());
    }

    public String toString() {
        return "[RemoteJavaObject jvmID=" + this.jvmID + " appletID=" + this.appletID + " objectID=" + this.objectID + " isApplet=" + this.isApplet + "]";
    }
}

