/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.ipc.windows;

import java.util.HashMap;
import java.util.Map;
import sun.plugin2.ipc.Event;
import sun.plugin2.os.windows.Windows;

public class WindowsEvent
extends Event {
    private long handle;
    private String name;

    public WindowsEvent(long handle, String name) {
        this.handle = handle;
        this.name = name;
    }

    public long getEventHandle() {
        return this.handle;
    }

    @Override
    public void waitForSignal(long millisToWait) {
        Windows.WaitForSingleObject(this.handle, (int)(millisToWait == 0L ? -1L : millisToWait));
    }

    @Override
    public void signal() {
        if (this.handle != 0L) {
            Windows.SetEvent(this.handle);
        }
    }

    @Override
    public Map<String, String> getChildProcessParameters() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("evt_name", this.name);
        return ret;
    }

    @Override
    public void dispose() {
        if (this.handle != 0L) {
            Windows.CloseHandle(this.handle);
            this.handle = 0L;
        }
    }
}

