/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.gluegen.runtime;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferFactory {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    public static ByteBuffer newDirectByteBuffer(int size) {
        ByteBuffer buf = ByteBuffer.allocateDirect(size);
        buf.order(ByteOrder.nativeOrder());
        return buf;
    }

    public static boolean isDirect(Buffer buf) {
        if (buf == null) {
            return true;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).isDirect();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).isDirect();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).isDirect();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).isDirect();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).isDirect();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).isDirect();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).isDirect();
        }
        throw new RuntimeException("Unexpected buffer type " + buf.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Buffer buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof ByteBuffer) {
            return buf.position();
        }
        if (buf instanceof FloatBuffer) {
            return buf.position() * 4;
        }
        if (buf instanceof IntBuffer) {
            return buf.position() * 4;
        }
        if (buf instanceof ShortBuffer) {
            return buf.position() * 2;
        }
        if (buf instanceof DoubleBuffer) {
            return buf.position() * 8;
        }
        if (buf instanceof LongBuffer) {
            return buf.position() * 8;
        }
        if (buf instanceof CharBuffer) {
            return buf.position() * 2;
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static Object getArray(Buffer buf) {
        if (buf == null) {
            return null;
        }
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).array();
        }
        if (buf instanceof FloatBuffer) {
            return ((FloatBuffer)buf).array();
        }
        if (buf instanceof IntBuffer) {
            return ((IntBuffer)buf).array();
        }
        if (buf instanceof ShortBuffer) {
            return ((ShortBuffer)buf).array();
        }
        if (buf instanceof DoubleBuffer) {
            return ((DoubleBuffer)buf).array();
        }
        if (buf instanceof LongBuffer) {
            return ((LongBuffer)buf).array();
        }
        if (buf instanceof CharBuffer) {
            return ((CharBuffer)buf).array();
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Buffer buf) {
        if (buf == null) {
            return 0;
        }
        int pos = buf.position();
        if (buf instanceof ByteBuffer) {
            return ((ByteBuffer)buf).arrayOffset() + pos;
        }
        if (buf instanceof FloatBuffer) {
            return 4 * (((FloatBuffer)buf).arrayOffset() + pos);
        }
        if (buf instanceof IntBuffer) {
            return 4 * (((IntBuffer)buf).arrayOffset() + pos);
        }
        if (buf instanceof ShortBuffer) {
            return 2 * (((ShortBuffer)buf).arrayOffset() + pos);
        }
        if (buf instanceof DoubleBuffer) {
            return 8 * (((DoubleBuffer)buf).arrayOffset() + pos);
        }
        if (buf instanceof LongBuffer) {
            return 8 * (((LongBuffer)buf).arrayOffset() + pos);
        }
        if (buf instanceof CharBuffer) {
            return 2 * (((CharBuffer)buf).arrayOffset() + pos);
        }
        throw new RuntimeException("Unknown buffer type " + buf.getClass().getName());
    }

    public static void rangeCheck(byte[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(char[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(short[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(int[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(long[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(float[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(double[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(Buffer buffer, int minElementsRemaining) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < minElementsRemaining) {
            throw new IndexOutOfBoundsException("Required " + minElementsRemaining + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Buffer buffer, int minBytesRemaining) {
        if (buffer == null) {
            return;
        }
        int elementsRemaining = buffer.remaining();
        int bytesRemaining = 0;
        if (buffer instanceof ByteBuffer) {
            bytesRemaining = elementsRemaining;
        } else if (buffer instanceof FloatBuffer) {
            bytesRemaining = elementsRemaining * 4;
        } else if (buffer instanceof IntBuffer) {
            bytesRemaining = elementsRemaining * 4;
        } else if (buffer instanceof ShortBuffer) {
            bytesRemaining = elementsRemaining * 2;
        } else if (buffer instanceof DoubleBuffer) {
            bytesRemaining = elementsRemaining * 8;
        } else if (buffer instanceof LongBuffer) {
            bytesRemaining = elementsRemaining * 8;
        } else if (buffer instanceof CharBuffer) {
            bytesRemaining = elementsRemaining * 2;
        }
        if (bytesRemaining < minBytesRemaining) {
            throw new IndexOutOfBoundsException("Required " + minBytesRemaining + " remaining bytes in buffer, only had " + bytesRemaining);
        }
    }
}

