/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.AppletInitEvent;
import com.sun.applet2.preloader.event.ApplicationExitEvent;
import com.sun.applet2.preloader.event.ConfigEvent;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.InitEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.Environment;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.ArgumentParsingUtil;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.JVMParameters;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JRESelectException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.EmbeddedJNLPValidation;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.PreloaderDelegate;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JNLPSignedResourcesHelper;
import com.sun.javaws.ui.SplashScreen;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.JnlpLookupStub;
import com.sun.jnlp.NativeSandboxJNLPServiceImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.JNLP2ClassLoader;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.ManagerCache;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.applet.StopListener;
import sun.plugin2.main.client.DisconnectedExecutionContext;
import sun.plugin2.main.client.JVMHealthData;

public class JNLP2Manager
extends Plugin2Manager {
    private URL _initDocumentBaseURL = null;
    private String _initJnlpFile = null;
    private byte[] _initJnlpBytes;
    private boolean _initialized;
    private JREInfo homeJREInfo = null;
    private URL _codebase = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy = null;
    private LocalApplicationProperties _lap = null;
    private static boolean _environmentInitialized = false;
    private String _cachedJNLPFilePath = null;
    private JRESelectException _relaunchException = null;
    private boolean _allSigned = false;
    private boolean _disableCustomPreloader = false;

    public void setCachedJNLPFilePath(String path) {
        this._cachedJNLPFilePath = path;
    }

    public JNLP2Manager(ManagerCache managerCache, String codebaseStr, URL documentBaseURL, String jnlpFile, boolean relaunched) throws Exception {
        this(managerCache, codebaseStr, documentBaseURL, jnlpFile, null, relaunched);
    }

    public JNLP2Manager(ManagerCache managerCache, String codebaseStr, URL documentBaseURL, String jnlpFile, byte[] jnlpBytes, boolean relaunched) throws Exception {
        super(managerCache, relaunched);
        this._initDocumentBaseURL = documentBaseURL;
        this._initJnlpFile = jnlpFile;
        this._initJnlpBytes = jnlpBytes != null ? (byte[])jnlpBytes.clone() : null;
        this._initialized = false;
        if (codebaseStr == null) {
            this._codebase = URLUtil.getBase((URL)this._initDocumentBaseURL);
            if (DEBUG) {
                System.out.println("   JNLP Codebase (is documentbase): " + this._codebase);
            }
        } else {
            try {
                this._codebase = URLUtil.asPathURL((URL)new URL(codebaseStr));
                if (DEBUG) {
                    System.out.println("   JNLP Codebase (absolute): " + this._codebase);
                }
            }
            catch (Exception e) {
                this._codebase = null;
            }
            if (this._codebase == null) {
                try {
                    URL u = new URL(URLUtil.getBase((URL)this._initDocumentBaseURL), codebaseStr);
                    if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)this._initDocumentBaseURL), (URL)u)) {
                        throw new SecurityException("Permission denied: " + u);
                    }
                    this._codebase = URLUtil.asPathURL((URL)u);
                    if (DEBUG) {
                        System.out.println("   JNLP Codebase (documentbase+codebase): " + this._codebase);
                    }
                }
                catch (Exception e) {
                    this._codebase = null;
                }
            }
            if (DEBUG && this._codebase == null) {
                System.out.println("   JNLP Codebase (null)");
            }
        }
        if (DEBUG) {
            Trace.println((String)("new JNLP2Manager: " + this._initJnlpFile + ", codebase: " + this._codebase + ", documentBase: " + this._initDocumentBaseURL), (TraceLevel)TraceLevel.BASIC);
            if (this._initJnlpBytes != null) {
                Trace.println((String)("Embedded JNLP: " + new String(this._initJnlpBytes)), (TraceLevel)TraceLevel.BASIC);
            }
        }
    }

    @Override
    public AppInfo getAppInfo() {
        return this.getLaunchDesc().getAppInfo();
    }

    @Override
    public DeploymentRuleSet getMainDeploymentRuleSet(URL loc) {
        return this.getMainDeploymentRuleSet();
    }

    @Override
    public URL getMainLocation(Class<?> cls) {
        CodeSource cs = cls.getProtectionDomain().getCodeSource();
        return cs.getLocation();
    }

    @Override
    public DeploymentRuleSet getMainDeploymentRuleSet() {
        return this._launchDesc.getMainDeploymentRuleSet();
    }

    @Override
    protected Plugin2ClassLoader newClassLoader() {
        JNLP2ClassLoader child;
        if (null == this._codebase) {
            Exception e = new Exception("newClassLoader - init failed: _codebase is null");
            Trace.ignoredException((Exception)e);
            return null;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        JNLP2ClassLoader parent = new JNLP2ClassLoader(this._codebase, cl);
        if (!Plugin2ClassLoader.setDeployURLClassPathCallbacks(parent, child = new JNLP2ClassLoader(this._codebase, (ClassLoader)((Object)parent)))) {
            return parent;
        }
        return child;
    }

    @Override
    public String getAppletUniqueKey() {
        Object keyString = "|";
        if (this._initDocumentBaseURL != null) {
            keyString = (String)keyString + this._initDocumentBaseURL.toString();
        }
        keyString = (String)keyString + "|";
        if (this._initJnlpFile != null) {
            keyString = (String)keyString + this._initJnlpFile;
        }
        keyString = (String)keyString + "|";
        return keyString;
    }

    @Override
    protected void collectJnlpProperties() {
    }

    @Override
    public void initialize() throws Exception {
        LocalApplicationProperties lap;
        super.initialize();
        Plugin2ClassLoader cl = this.getAppletClassLoader();
        if (!(cl instanceof JNLP2ClassLoader)) {
            Exception e = new Exception("ClassLoader not JNLP2ClassLoader (" + cl + ")");
            throw e;
        }
        if (!this.isAppletRelaunched()) {
            Config.get().refreshIfNeeded();
        }
        this.homeJREInfo = JREInfo.getHomeJRE();
        if (DEBUG && VERBOSE) {
            Trace.println((String)("JNLP2Manager.initialize(): java.home:" + Environment.getJavaHome() + ", RUnning JRE: " + this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)"JREInfos");
            JREInfo.traceJREs();
        }
        if (this.homeJREInfo == null) {
            throw new ExitException((Throwable)new Exception("Internal Error: no running JRE"), 3);
        }
        LaunchDesc ld = this.checkForEmbeddedJNLP();
        if (ld == null) {
            ld = LaunchDescFactory.buildDescriptorFromCache((String)this._initJnlpFile, (URL)this._codebase, (URL)this._initDocumentBaseURL);
            if (this._initJnlpFile.endsWith(".jarjnlp")) {
                this._launchDesc = ld;
            }
        }
        if (this._launchDesc == null && ld != null && ld.getUpdate().isBackgroundCheck() && ((lap = ResourceProvider.get().getLocalApplicationProperties(ld.getCanonicalHome(), null, true)) == null || !lap.forceUpdateCheck())) {
            if (this.redirectLaunchDesc(ld, this._initJnlpFile, this._codebase, this._initDocumentBaseURL)) {
                this._lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
            } else {
                this._launchDesc = ld;
                this._lap = lap;
            }
        }
        if (this._launchDesc == null) {
            this._launchDesc = LaunchDescFactory.buildDescriptor((String)this._initJnlpFile, (URL)this._codebase, (URL)this._initDocumentBaseURL, (boolean)DEBUG);
            if (null != this._launchDesc) {
                if (this.redirectLaunchDesc(this._launchDesc, this._initJnlpFile, this._codebase, this._initDocumentBaseURL) && DEBUG) {
                    Trace.println((String)("JNLP2Manager.initialize(): JNLP redirect Ref: " + this._launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
                }
            } else if (this._cachedJNLPFilePath != null && (ld = LaunchDescFactory.buildDescriptor((File)new File(this._cachedJNLPFilePath), (URL)this._codebase, (URL)this._initDocumentBaseURL, null)) != null && (ld.getLocation() == null || ld.getInformation().supportsOfflineOperation())) {
                this._launchDesc = ld;
            }
        }
        if (null == this._launchDesc) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP not available: " + this._initJnlpFile), (TraceLevel)TraceLevel.BASIC);
            return;
        }
        if (!this._launchDesc.isApplet() && !this._launchDesc.isFXApp()) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("JNLP2Manager.initialize(): JNLP not an applet nor JavaFX application: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            }
            return;
        }
        if (Environment.isImportMode()) {
            if (Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)("JNLP2Manager.initialize(): JNLP import mode not supported: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            }
            return;
        }
        AppletDesc ad = this._launchDesc.getAppletDescriptor();
        boolean isFXApp = this._launchDesc.isFXApp();
        if (null == ad && !isFXApp) {
            throw new Exception("initialize - init failed: not an applet of FX application");
        }
        this._codebase = this._launchDesc.getCodebase();
        this._initialized = true;
        Applet2ExecutionContext exeCtx = this.getAppletExecutionContext();
        if (isFXApp) {
            exeCtx.setAppletParameters(JNLP2Tag.addJnlpParams(exeCtx.getAppletParameters(), this._launchDesc));
        } else {
            exeCtx.setAppletParameters(JNLP2Tag.addJnlpParams(exeCtx.getAppletParameters(), ad));
        }
        this.prepareToLaunch();
        if (null == this._appPolicy) {
            Exception e = new Exception("initialize - init failed: _appPolicy is null");
            throw e;
        }
    }

    @Override
    protected void performDesktopIntegration() {
        if (this._launchDesc != null && (this._launchDesc.isFXApp() || this.isDisconnectedExecutionContext())) {
            this.installShortcuts();
        }
    }

    @Override
    protected void loadJarFiles() throws ExitException {
        if (!this._initialized) {
            if (null == this._launchDesc) {
                ExitException ee = new ExitException((Throwable)new FileNotFoundException("JNLP file error: " + this._initJnlpFile + ". Please make sure the file exists and check if \"codebase\" and \"href\" in the JNLP file are correct."), 3);
                throw ee;
            }
            if (!this._launchDesc.isApplet() && !this._launchDesc.isFXApp()) {
                ExitException ee = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP not an applet or a JavaFX application", new Exception("JNLP not an applet or a JavaFX application")), 3);
                throw ee;
            }
            if (Environment.isImportMode()) {
                ExitException ee = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP import mode not supported", new Exception("JNLP import mode not supported")), 3);
                throw ee;
            }
            ExitException ee = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP2Manager not initialized", new Exception("JNLP2Manager not initialized")), 3);
            throw ee;
        }
        Object event = new DownloadEvent(1, this._launchDesc.getLocation(), null, null, 1L, 1L, 100);
        try {
            this.prepareLaunchFile(this._launchDesc);
            this._launchDesc.getUpdater().startBackgroundUpdateOpt();
        }
        catch (Throwable t) {
            ExitException ee;
            Trace.ignored((Throwable)t);
            ExitException exitException = ee = t instanceof ExitException ? (ExitException)t : new ExitException(t, 3);
            if (ee.getReason() != 0) {
                event = ee.getReason() == 2 || ee.isSilentException() ? null : JNLP2Manager.getErrorEvent(this._launchDesc.getLocation(), ee);
            }
            throw ee;
        }
        finally {
            try {
                if (event != null) {
                    this.getPreloaderDelegate().handleEvent((PreloaderEvent)event);
                }
                if (Platform.get().getRunInNativeSandbox()) {
                    PreloaderDelegate preloader = this.getPreloaderDelegate();
                    if (ToolkitStore.isToolkitType((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT)) {
                        preloader.handleEvent((PreloaderEvent)new AppletInitEvent(4, null));
                    }
                    preloader.handleEvent((PreloaderEvent)new ConfigEvent(6));
                    preloader.handleEvent((PreloaderEvent)new ApplicationExitEvent());
                }
            }
            catch (CancelException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public URL getCodeBase() {
        return this._codebase;
    }

    @Override
    public String getCode() {
        if (null == this._launchDesc) {
            return "<applet error>";
        }
        return this._launchDesc.getMainClassName();
    }

    @Override
    protected void destroyAppContext(AppContext fac, StopListener stopListener, long timeToWait) {
        Object obj = fac.get((Object)"deploy-launchdownloadthreadpoolinappcontext");
        if (obj != null) {
            ExecutorService pool = (ExecutorService)obj;
            pool.shutdown();
        }
        super.destroyAppContext(fac, stopListener, timeToWait);
    }

    @Override
    protected void appletSSVRelaunch() throws JRESelectException {
        if (this._relaunchException != null) {
            throw this._relaunchException;
        }
    }

    @Override
    protected void checkRunningJVMToolkitSatisfying() throws JRESelectException {
        boolean isFXSatisfied;
        if (this.isAppletRelaunched()) {
            return;
        }
        boolean isAWTSatisfied = !this._launchDesc.isFXApp() && ToolkitStore.isToolkitType((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.AWT_TOOLKIT);
        boolean bl = isFXSatisfied = this._launchDesc.isFXApp() && ToolkitStore.isToolkitType((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT);
        if (isAWTSatisfied || isFXSatisfied) {
            return;
        }
        JREInfo secureJRE = this._launchDesc.selectJRE(true);
        if (secureJRE != null && secureJRE.getJfxRuntime() != null) {
            throw new JRESelectException(null, null);
        }
    }

    @Override
    protected void checkRunningJVMArgsSatisfying() throws JRESelectException {
        if (this.isAppletRelaunched()) {
            return;
        }
        JREMatcher jreMatcher = this._launchDesc.getJREMatcher();
        if (!(jreMatcher.isRunningJVMArgsSatisfying(this._allSigned) && JVMHealthData.getCurrent().isHealthy() || this._relaunchException == null)) {
            throw new JRESelectException(null, this._relaunchException.getJVMArgs());
        }
    }

    public void clearRelaunchException() {
        this._relaunchException = null;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    @Override
    public String getDraggedTitle() {
        InformationDesc infoDesc;
        String title = super.getDraggedTitleParam();
        if (title == null && this._launchDesc != null && (infoDesc = this._launchDesc.getInformation()) != null) {
            title = infoDesc.getTitle();
        }
        return title;
    }

    @Override
    public void setDraggedApplet() {
        if (this._launchDesc == null) {
            return;
        }
        LocalApplicationProperties lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
        if (lap != null) {
            lap.setDraggedApplet();
        }
    }

    @Override
    boolean getDecoratedDefault() {
        if (this._launchDesc == null) {
            return true;
        }
        LocalApplicationProperties lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
        if (lap == null) {
            return true;
        }
        return !lap.isDraggedApplet();
    }

    @Override
    String getDecoratedPreference() {
        String value;
        AppletDesc appletDesc;
        if (this._launchDesc != null && (appletDesc = this._launchDesc.getAppletDescriptor()) != null && (value = appletDesc.getParameters().getProperty("java_decorated_frame")) != null) {
            return value;
        }
        return this.getParameter("java_decorated_frame");
    }

    @Override
    protected void setupProgress() {
    }

    private boolean redirectLaunchDesc(LaunchDesc ld, String jnlpHRef, URL codebase, URL documentbase) throws ExitException {
        try {
            URL newHref = ld.getLocation();
            if (newHref != null) {
                URL url = null;
                try {
                    url = new URL(jnlpHRef);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (url != null && url.toString().equals(newHref.toString())) {
                    return false;
                }
                if (codebase != null) {
                    try {
                        url = new URL(codebase, jnlpHRef);
                        if (!URLUtil.checkTargetURL((URL)codebase, (URL)url)) {
                            throw new SecurityException("Permission denied: " + url);
                        }
                    }
                    catch (Exception e) {
                        if (DEBUG) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                        url = null;
                    }
                    if (url != null && url.toString().equals(newHref.toString())) {
                        return false;
                    }
                }
                if (codebase == null && documentbase != null) {
                    try {
                        url = new URL(URLUtil.getBase((URL)documentbase), jnlpHRef);
                        if (!URLUtil.checkTargetURL((URL)URLUtil.getBase((URL)documentbase), (URL)url)) {
                            throw new SecurityException("Permission denied: " + url);
                        }
                    }
                    catch (Exception e) {
                        if (DEBUG) {
                            System.out.println(e);
                            e.printStackTrace();
                        }
                        url = null;
                    }
                    if (url != null && url.toString().equals(newHref.toString())) {
                        return false;
                    }
                }
                this._launchDesc = LaunchDescFactory.buildDescriptor((String)newHref.toString(), (URL)codebase, (URL)documentbase, (boolean)DEBUG);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (DEBUG) {
                System.out.println(e);
                e.printStackTrace();
            }
            throw new ExitException((Throwable)e, 3);
        }
    }

    private void prepareToLaunch() throws ExitException {
        block6: {
            try {
                if (this._launchDesc == null) {
                    throw new ExitException("No launch descriptor to use", null);
                }
                this._lap = ResourceProvider.get().getLocalApplicationProperties(this._launchDesc.getCanonicalHome(), null, true);
                URL href = this._launchDesc.getLocation();
                if (href != null) {
                    Cache.removeRemovedApp((String)href.toString(), (String)this._launchDesc.getInformation().getTitle());
                }
                if (this._launchDesc.getResources() != null) {
                    Globals.getDebugOptionsFromProperties((Properties)this._launchDesc.getResources().getResourceProperties());
                }
                this._appPolicy = AppPolicy.createInstance((String)this._launchDesc.getCanonicalHome().getHost());
            }
            catch (Throwable t) {
                ExitException ee = t instanceof ExitException ? (ExitException)t : new ExitException(t, 3);
                int eeReason = ee.getReason();
                if (eeReason == 3) {
                    this.setErrorOccurred(ee.getException().getMessage(), ee.getException());
                    this.showAppletException(ee);
                }
                if (eeReason == 0) break block6;
                throw ee;
            }
        }
    }

    private URL validateLaunchDesc(LaunchDesc ld) throws ExitException {
        if (ld.getResources() == null) {
            this.handleJnlpFileException(ld, (Exception)new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.noappresources", (Object[])new Object[]{ld.getSpecVersion()}), null));
        }
        JNLPException.setDefaultLaunchDesc((LaunchDesc)ld);
        if (!ld.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException((Throwable)new OfflineLaunchException(1), 3);
        }
        URL jnlpUrl = ld.getCanonicalHome();
        if (jnlpUrl == null) {
            LaunchDescException lde = new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException((Throwable)lde, 3);
        }
        return jnlpUrl;
    }

    private boolean ensureAllJnlpFilesAreAvailable(LaunchDesc ld, ArrayList<File> installFiles) throws ExitException {
        boolean allInCache = false;
        LaunchDownload download = new LaunchDownload(ld);
        if (ld.getUpdate().isBackgroundCheck() && (this._lap == null || !this._lap.forceUpdateCheck())) {
            allInCache = download.isInCache();
        }
        if (!allInCache) {
            try {
                download.downloadExtensions(null, 0, installFiles);
            }
            catch (Exception ioe) {
                if (ld.getInformation().supportsOfflineOperation() && download.isInCache()) {
                    allInCache = true;
                }
                throw new ExitException((Throwable)ioe, 3);
            }
        }
        return allInCache;
    }

    boolean isJfxSupportSatisfiedImpl(ClassLoader cl, LaunchDesc ld) {
        if (!ld.needFX()) {
            return true;
        }
        if (ld.isFXApp() && !ToolkitStore.setPreferredToolkit((ToolkitStore.ToolkitType)ToolkitStore.ToolkitType.FX_TOOLKIT)) {
            return false;
        }
        return JfxHelper.isJfxSupportSatisfied((ClassLoader)cl, (LaunchDesc)ld);
    }

    private boolean isJfxSupportSatisfied(LaunchDesc ld) {
        return this.isJfxSupportSatisfiedImpl(null, ld);
    }

    private boolean runInNativeSandbox(LaunchDesc ld) {
        if (Platform.get().isNativeSandbox()) {
            return false;
        }
        DeploymentRuleSet drs = ld.getMainDeploymentRuleSet();
        if (drs != null && !drs.allowNativeSandbox()) {
            return false;
        }
        ArrayList list = new ArrayList();
        JNLPSignedResourcesHelper.addExtensions(list, (LaunchDesc)ld);
        for (LaunchDesc cur : list) {
            JARDesc[] jds;
            ResourcesDesc rd;
            if (cur.getSecurityModel() == 0 || (rd = cur.getResources()) == null || (jds = rd.getLocalJarDescs()) == null || jds.length == 0) continue;
            return false;
        }
        return true;
    }

    private boolean disableCustomPreloader(LaunchDesc ld) {
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this.runInNativeSandbox(ld)) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
            return true;
        }
        if (this._lap != null && this._lap.getEnableCustomPreloader()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        if (Platform.get().isNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        DeploymentRuleSet drs = ld.getMainDeploymentRuleSet();
        if (drs != null && !drs.allowNativeSandbox()) {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
            return false;
        }
        ArrayList list = new ArrayList();
        JNLPSignedResourcesHelper.addExtensions(list, (LaunchDesc)ld);
        boolean haveAllPermissions = false;
        boolean haveSandbox = false;
        for (LaunchDesc list1 : list) {
            LaunchDesc cur = list1;
            if (cur.getSecurityModel() == 0) {
                haveSandbox = true;
            } else {
                haveAllPermissions = true;
            }
            if (!haveAllPermissions || !haveSandbox) continue;
            this._disableCustomPreloader = true;
            break;
        }
        if (this._disableCustomPreloader) {
            Trace.println((String)"Custom preloader: disabled", (TraceLevel)TraceLevel.PRELOADER);
        } else {
            Trace.println((String)"Custom preloader: enabled", (TraceLevel)TraceLevel.PRELOADER);
        }
        return this._disableCustomPreloader;
    }

    private void prepareLaunchFile(final LaunchDesc ld) throws ExitException {
        boolean uiToolkitForcesRelaunch;
        JnlpLaunchState s = new JnlpLaunchState(ld);
        URL jnlpUrl = this.validateLaunchDesc(ld);
        ld.setPropsSet(true);
        if (!(this.getAppletExecutionContext() instanceof DisconnectedExecutionContext)) {
            ld.setParentURL(this.getDocumentBase());
        }
        JNLP2ClassLoader cl = (JNLP2ClassLoader)this.getOrCreatePlugin2ClassLoader();
        ArrayList<File> installFiles = new ArrayList<File>();
        boolean allInCache = this.ensureAllJnlpFilesAreAvailable(ld, installFiles);
        boolean updateCache = !ld.getUpdate().isBackgroundCheck() && !ld.getUpdate().isPromptPolicy() && !this.isAppletRelaunched();
        boolean skipExtensions = true;
        cl.initialize(ld, this._appPolicy);
        final JNLPSignedResourcesHelper signingHelper = new JNLPSignedResourcesHelper(ld);
        final PreloaderDelegate preloader = this.getPreloaderDelegate();
        Runnable okAction = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean allSigned = signingHelper.checkSignedResources((Preloader)JNLP2Manager.this.getPreloaderDelegate(), true);
                    Trace.println((String)("Security check for progress jars: allSigned=" + allSigned), (TraceLevel)TraceLevel.SECURITY);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (JNLP2Manager.this.disableCustomPreloader(ld)) {
                    preloader.setPreloaderClass(null);
                }
                preloader.initPreloader((ClassLoader)((Object)JNLP2Manager.this.loader), JNLP2Manager.this.appletThreadGroup);
            }
        };
        Runnable failAction = new Runnable(){

            @Override
            public void run() {
                preloader.setPreloaderClass(null);
                preloader.initPreloader((ClassLoader)((Object)JNLP2Manager.this.loader), JNLP2Manager.this.appletThreadGroup);
            }
        };
        new LaunchDownload(ld).prepareCustomProgress(preloader, signingHelper, okAction, failAction, !allInCache || updateCache);
        boolean allUpdated = false;
        allUpdated = this.downloadResources(cl, ld, installFiles, allInCache, updateCache, true);
        ld.selectJRE(false);
        if (allUpdated) {
            this.resetForceUpdateCheck();
        }
        Trace.println((String)("LaunchDesc location: " + jnlpUrl), (TraceLevel)TraceLevel.BASIC);
        try {
            s.doJvmSelection();
        }
        catch (LaunchDescException ex) {
            throw new ExitException((Throwable)ex, 2);
        }
        boolean homeJVMMatch = s.isHomeJvmMatch();
        boolean forceUpdate = s.jreInfo == null;
        boolean offlineMode = DeployOfflineManager.isGlobalOffline();
        if (forceUpdate && offlineMode) {
            throw new ExitException((Throwable)new OfflineLaunchException(0), 3);
        }
        boolean needUpdate = forceUpdate;
        if (!(forceUpdate || allUpdated || ld.getUpdate().isBackgroundCheck() || this.isAppletRelaunched() || offlineMode)) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                if (DEBUG) {
                    Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                }
                needUpdate = true;
            } else {
                try {
                    needUpdate = ld.getUpdater().isUpdateAvailable();
                }
                catch (Exception e) {
                    throw new ExitException((Throwable)e, 3);
                }
                if (ld.getUpdater().isCheckAborted()) {
                    throw new ExitException((Throwable)new LaunchDescException(ld, "User rejected cert - aborted", null), 4);
                }
            }
        }
        if (DEBUG) {
            Trace.println((String)("\n\tisRelaunch: " + this.isAppletRelaunched() + "\n\tOffline mode: " + offlineMode + "\n\tforceUpdate: " + forceUpdate + "\n\tneedUpdate: " + needUpdate + "\n\tbgrUpdCheck: " + ld.getUpdate().isBackgroundCheck() + "\n\tbgrUpdThread: " + ld.getUpdater().isBackgroundUpdateRunning() + "\n\tRunning  JREInfo: " + this.homeJREInfo + "\n\t" + s.jreMatcher), (TraceLevel)TraceLevel.BASIC);
        }
        if (needUpdate && !forceUpdate) {
            forceUpdate = ld.getUpdater().needUpdatePerPolicy();
        }
        if (forceUpdate) {
            s.updateResources(cl, installFiles, allInCache, true);
        }
        PreloaderDelegate cp = this.getPreloaderDelegate();
        try {
            cp.waitTillLoaded();
        }
        catch (JNLPException je) {
            throw new ExitException((Throwable)je, 3);
        }
        catch (IOException ioe) {
            if (ld.getInformation().supportsOfflineOperation() && new LaunchDownload(ld).isInCache(true)) {
                Trace.ignoredException((Exception)ioe);
            }
            throw new ExitException((Throwable)ioe, 3);
        }
        if (s.jreInstalled && homeJVMMatch) {
            throw new ExitException((Throwable)new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
        }
        if (homeJVMMatch) {
            s.doInstallers(installFiles);
        }
        if (!ld.isValidSpecificationVersion()) {
            JNLPException.setDefaultLaunchDesc((LaunchDesc)ld);
            this.handleJnlpFileException(ld, (Exception)((Object)new LaunchDescException(ld, ResourceManager.getString((String)"launch.error.badjnlversion", (Object[])new Object[]{ld.getSpecVersion()}), null)));
        }
        if (s.jreInstalled) {
            try {
                s.doJvmSelection();
            }
            catch (LaunchDescException ex) {
                throw new ExitException((Throwable)ex, 2);
            }
            if (s.jreInfo != null) {
                s.relaunchApplet(false);
                return;
            }
            String fxVer = "2.0+";
            if (ld.getJavaFXRuntimeDescriptor() != null) {
                fxVer = ld.getJavaFXRuntimeDescriptor().getVersion();
            }
            throw new ExitException(ResourceManager.getString((String)"launch.error.jfx.unavailable", (Object[])new Object[]{fxVer}), null, 3);
        }
        JVMHealthData data = JVMHealthData.getCurrent();
        if (DEBUG) {
            Trace.println((String)("Checking current JVM health: " + data), (TraceLevel)TraceLevel.BASIC);
        }
        boolean bl = uiToolkitForcesRelaunch = !ToolkitStore.isToolkitType((ToolkitStore.ToolkitType)(ld.isFXApp() ? ToolkitStore.ToolkitType.FX_TOOLKIT : ToolkitStore.ToolkitType.AWT_TOOLKIT));
        if (this.runInNativeSandbox(ld)) {
            Platform.get().setRunInNativeSandbox(true);
        } else {
            Platform.get().setRunInNativeSandbox(false);
        }
        if (ld.isSecureJVMArgs() && (s.installerRelaunch || !homeJVMMatch || uiToolkitForcesRelaunch || !data.isHealthy())) {
            Trace.println((String)("Relaunch because: " + (s.installerRelaunch ? "[installer demands a relaunch] " : "") + (homeJVMMatch ? "" : "[currently running JRE doesn't satisfy (version/args)] ") + (uiToolkitForcesRelaunch ? "[current UI toolkit does not match] " : "") + (data.isHealthy() ? "" : "[unhealthy JVM state] ")), (TraceLevel)TraceLevel.BASIC);
            s.relaunchApplet(false);
        }
        boolean allSigned = false;
        try {
            signingHelper.checkSignedLaunchDesc(this._codebase, this._initDocumentBaseURL);
            allSigned = signingHelper.checkSignedResources((Preloader)this.getPreloaderDelegate(), false);
            this._allSigned = allSigned = allSigned && ld.isSigned();
            if (this._disableCustomPreloader) {
                this._lap.setEnableCustomPreloader(true);
                this._lap.store();
            }
        }
        catch (JNLPException je) {
            if (DEBUG) {
                Trace.ignored((Throwable)je);
            }
            throw new ExitException((Throwable)je, 3);
        }
        catch (IOException ioe) {
            throw new ExitException((Throwable)ioe, 3);
        }
        catch (ExitException ee) {
            throw ee;
        }
        catch (Exception e) {
            if (DEBUG) {
                Trace.ignored((Throwable)e);
            }
            throw new ExitException((Throwable)e, 3);
        }
        Trace.println((String)("passing security checks; secureArgs:" + ld.isSecureJVMArgs() + ", allSigned:" + allSigned), (TraceLevel)TraceLevel.BASIC);
        if (!this.isAppletRelaunched()) {
            boolean secure;
            boolean bl2 = secure = (ld.getSecurityModel() == 1 || ld.getSecurityModel() == 2) && ld.isSigned();
            if (secure) {
                JVMParameters jvmExtASCIIParams = new JVMParameters();
                jvmExtASCIIParams.setIncludeExtendedASCIIValues(true);
                jvmExtASCIIParams.parse(s.jreDesc.getVmArgs());
                s.jreMatcher.getSelectedJVMParameters().addArguments(jvmExtASCIIParams);
            }
        }
        if (Environment.isJavawsAppletLifecycle()) {
            SplashScreen.generateCustomSplash((LaunchDesc)ld, (boolean)false);
        }
        homeJVMMatch = s.jreMatcher.isRunningJVMSatisfying(allSigned);
        if (s.installerRelaunch || !homeJVMMatch || !data.isHealthy() || Platform.get().getRunInNativeSandbox() || this._disableCustomPreloader) {
            if (!Platform.get().getRunInNativeSandbox() && this._disableCustomPreloader) {
                Platform.get().checkAndUpdateSandboxWindow(true);
            }
            s.relaunchApplet(allSigned);
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
    }

    private boolean downloadResources(JNLP2ClassLoader cl, LaunchDesc ld, ArrayList<File> installFiles, boolean allInCache, boolean updateCache, boolean skipExtensions) throws ExitException {
        boolean doDownload;
        boolean updated = false;
        boolean bl = doDownload = updateCache || !allInCache;
        if (DEBUG) {
            Trace.println((String)("JNLP2Manager.downloadResources(): updateCache " + updateCache + ", allInCache " + allInCache + ", doDownload " + doDownload), (TraceLevel)TraceLevel.BASIC);
        }
        if (!doDownload) {
            return updated;
        }
        try {
            this.getPreloaderDelegate().handleEvent((PreloaderEvent)new ConfigEvent(3, this.getLaunchDesc().getAppInfo()));
            this.getPreloaderDelegate().handleEvent((PreloaderEvent)new InitEvent(4));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        LaunchDownload download = new LaunchDownload(ld);
        try {
            if (!skipExtensions) {
                download.downloadExtensions((Preloader)this.getPreloaderDelegate(), 0, installFiles);
            }
            cl.updateJarDescriptors(ld.getResources());
            LaunchDownload.checkJNLPSecurity((LaunchDesc)ld);
            download.downloadEagerorAll(false, (Preloader)this.getPreloaderDelegate(), false);
            updated = true;
        }
        catch (SecurityException se) {
            throw new ExitException((Throwable)se, 3);
        }
        catch (JNLPException je) {
            throw new ExitException((Throwable)je, 3);
        }
        catch (IOException ioe) {
            if (ld.getInformation().supportsOfflineOperation() && allInCache) {
                Trace.ignoredException((Exception)ioe);
                try {
                    LaunchDownload.checkJNLPSecurity((LaunchDesc)ld);
                }
                catch (SecurityException se) {
                    throw new ExitException((Throwable)se, 3);
                }
                catch (JNLPException je) {
                    throw new ExitException((Throwable)je, 3);
                }
                return updated;
            }
            throw new ExitException((Throwable)ioe, 3);
        }
        return updated;
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException ioe) {
                Trace.ignoredException((Exception)ioe);
            }
        }
    }

    private void handleJnlpFileException(LaunchDesc ld, Exception exception) throws ExitException {
        if (ld == null) {
            return;
        }
        Resource r = ResourceProvider.get().getCachedResource(ld.getCanonicalHome(), null);
        if (r != null) {
            ResourceProvider.get().markRetired(r, true);
        }
        throw new ExitException((Throwable)exception, 3);
    }

    @Override
    protected String getCodeSourceLocations() {
        if (!this._initialized) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this._launchDesc);
        ResourcesDesc resources = this._launchDesc.getResources();
        if (resources != null) {
            list.addAll(Arrays.asList(resources.getEagerOrAllJarDescs(true)));
            list.addAll(Arrays.asList(resources.getExtensionDescs()));
        }
        return JNLP2Manager.buildJarList(list.toArray(new Object[list.size()]));
    }

    @Override
    protected String getJarFiles() {
        if (!this._initialized) {
            return null;
        }
        ResourcesDesc resources = this._launchDesc.getResources();
        if (resources != null) {
            return JNLP2Manager.buildJarList(resources.getEagerOrAllJarDescs(true));
        }
        return null;
    }

    protected static String buildJarList(Object[] resources) {
        if (resources == null) {
            return null;
        }
        StringBuffer buf = null;
        boolean needComma = false;
        for (Object resource : resources) {
            String str = null;
            if (resource instanceof LaunchDesc) {
                if (((LaunchDesc)resource).getLocation() != null) {
                    str = ((LaunchDesc)resource).getLocation().toString();
                }
            } else if (resource instanceof JARDesc) {
                if (((JARDesc)resource).getLocation() != null) {
                    str = ((JARDesc)resource).getLocation().toString();
                }
            } else {
                if (!(resource instanceof ExtensionDesc)) continue;
                if (((ExtensionDesc)resource).getLocation() != null) {
                    str = ((ExtensionDesc)resource).getLocation().toString();
                }
            }
            if (str == null) continue;
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (needComma) {
                buf.append(",");
            }
            buf.append(str);
            needComma = true;
        }
        if (buf == null) {
            return null;
        }
        return buf.toString();
    }

    public static void initializeExecutionEnvironment() throws JNLPException {
        if (_environmentInitialized) {
            return;
        }
        if (!Cache.canWrite()) {
            CacheAccessException e = new CacheAccessException(Environment.isSystemCacheMode());
            throw e;
        }
        Properties p = System.getProperties();
        p.setProperty("javawebstart.version", Globals.getComponentName());
        ServiceManager.setServiceManagerStub((ServiceManagerStub)new JnlpLookupStub());
        if (Config.useNativeSandbox(null) && !Platform.get().isNativeSandbox()) {
            Platform.get().setNativeSandboxJNLPService((NativeSandboxJNLPService)new NativeSandboxJNLPServiceImpl());
        }
        Config.setupPackageAccessRestriction();
        UIFactory.setDialogListener((DialogListener)new JavawsDialogListener());
        if (DeployOfflineManager.isGlobalOffline()) {
            DeployOfflineManager.setForcedOffline((boolean)true);
        }
        _environmentInitialized = true;
    }

    protected boolean useGrayBoxProgressListener() {
        return false;
    }

    @Override
    public void installShortcuts() {
        this.startWorkerThread("Shortcut Installer Thread", new Runnable(){

            @Override
            public void run() {
                URL jnlpUrl = JNLP2Manager.this._launchDesc.getLocation();
                LocalApplicationProperties lap = ResourceProvider.get().getLocalApplicationProperties(jnlpUrl, null, true);
                if (lap != null) {
                    LocalInstallHandler lih;
                    lap.setLastAccessed(new Date());
                    lap.incrementLaunchCount();
                    if (JNLP2Manager.this._initDocumentBaseURL != null) {
                        lap.setDocumentBase(JNLP2Manager.this._initDocumentBaseURL.toString());
                    }
                    if (JNLP2Manager.this._codebase != null) {
                        lap.setCodebase(JNLP2Manager.this._codebase.toString());
                    }
                    if ((lih = LocalInstallHandler.getInstance()) != null && !lih.isShortcutExists(lap)) {
                        if (!JNLP2Manager.this._launchDesc.isFXApp() && !JNLP2Manager.this.isDisconnectedExecutionContext()) {
                            lap.setAskedForInstall(false);
                        }
                        lih.install(JNLP2Manager.this._launchDesc, lap, true, false, null);
                    }
                    try {
                        lap.store();
                    }
                    catch (IOException e) {
                        Trace.ignored((Throwable)e);
                    }
                }
            }
        });
    }

    private LaunchDesc checkForEmbeddedJNLP() {
        if (this._initJnlpBytes == null) {
            return null;
        }
        LaunchDesc embeddedLD = null;
        try {
            URL derived = this._codebase;
            if (this._initJnlpFile != null) {
                try {
                    derived = new URL(this._initDocumentBaseURL, this._initJnlpFile);
                    derived = URLUtil.asPathURL((URL)URLUtil.getBase((URL)derived));
                }
                catch (MalformedURLException mue) {
                    Trace.ignored((Throwable)mue);
                }
            }
            if (derived == null) {
                derived = this._codebase;
            }
            embeddedLD = LaunchDescFactory.buildDescriptor((byte[])this._initJnlpBytes, (URL)derived, (URL)this._initDocumentBaseURL);
            if (DEBUG) {
                System.out.println("buildDescriptor(embeddedJnlp) returns " + embeddedLD);
            }
            if (embeddedLD != null) {
                new EmbeddedJNLPValidation(embeddedLD, derived).validate();
                this._launchDesc = embeddedLD = LaunchDownload.updateLaunchDescInCache((LaunchDesc)embeddedLD, (URL)derived, (URL)this._initDocumentBaseURL);
            }
        }
        catch (Exception ex) {
            embeddedLD = null;
            Trace.println((String)"Ignore exception processing jnlp_embedded:", (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)new String(this._initJnlpBytes), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)ex);
        }
        this._initJnlpBytes = null;
        return embeddedLD;
    }

    private class JnlpLaunchState {
        LaunchDesc ld;
        boolean jreInstalled;
        boolean installerRelaunch;
        private JREMatcher jreMatcher;
        private JREDesc jreDesc;
        private JREInfo jreInfo;
        private boolean homeJVMMatch;
        private boolean homeJVMVersionMatch;
        private String bestJREVersion = null;

        JnlpLaunchState(LaunchDesc ld) {
            this.ld = ld;
            this.jreInstalled = false;
            this.installerRelaunch = false;
        }

        boolean isHomeJvmMatch() {
            this.jreMatcher = this.ld.getJREMatcher();
            if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)"JnlpLaunchState.isHomeJvmMatch: JRE matcher:");
                Trace.println((String)this.jreMatcher.toString());
            }
            this.homeJVMMatch = this.jreMatcher.isRunningJVMSatisfying(true);
            return this.homeJVMMatch;
        }

        String findBestJreVersion() {
            if (null == this.bestJREVersion) {
                this.homeJVMVersionMatch = this.jreMatcher.isRunningJVMVersionSatisfying();
                if (this.jreInfo != null) {
                    this.bestJREVersion = this.jreInfo.getProduct();
                } else if (!this.homeJVMVersionMatch) {
                    JavaFXRuntimeDesc jfxd = this.ld.getJavaFXRuntimeDescriptor();
                    this.bestJREVersion = JNLP2Manager.this.fireGetBestJREVersion(this.jreDesc.getVersion(), jfxd == null ? null : jfxd.getVersion());
                }
                if (this.bestJREVersion == null) {
                    this.bestJREVersion = this.jreDesc.getVersion();
                }
            }
            return this.bestJREVersion;
        }

        void doJvmSelection() throws ExitException, LaunchDescException {
            this.jreInfo = this.ld.getSelectedJRE();
            this.jreDesc = this.ld.getJREMatcher().getSelectedJREDesc();
            if (this.jreInfo == null && this.jreDesc == null) {
                Trace.println((String)this.jreMatcher.toString());
                throw new ExitException((Throwable)new Exception("Internal Error: Internal error, no JREDesc and no JREInfo"), 3);
            }
            if (this.jreInfo == null) {
                JNLP2Manager.this.setParameter("__applet_request_version", this.jreDesc.getVersion());
                this.jreInfo = this.ld.selectJRE(true);
            }
            if (this.ld.needFX()) {
                if (this.jreInfo != null) {
                    JfxHelper.validateJfxRequest((LaunchDesc)this.ld, (JREInfo)this.jreInfo);
                } else {
                    JfxHelper.validateJfxRequest((LaunchDesc)this.ld, (JREDesc)this.jreDesc);
                }
            }
        }

        void updateResources(JNLP2ClassLoader cl, ArrayList<File> installFiles, boolean allInCache, boolean skipExtensions) throws ExitException {
            JNLP2Manager.this.downloadResources(cl, this.ld, installFiles, allInCache, true, skipExtensions);
            JNLP2Manager.this.resetForceUpdateCheck();
        }

        void doInstallers(ArrayList<File> installFiles) throws ExitException {
            if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)("JnlpLaunchState.doInstallers(): SingleInstanceManager ?: " + this.ld.getCanonicalHome().toString()));
            }
            if (SingleInstanceManager.isServerRunning((String)this.ld.getCanonicalHome().toString())) {
                ApplicationDesc applicationDesc;
                String[] appArgs = Globals.getApplicationArgs();
                if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                    Trace.println((String)("JnlpLaunchState.doInstallers(): SingleInstanceManager: Running with appArgs: " + appArgs + ", thread: " + Thread.currentThread()));
                }
                if (appArgs != null && (applicationDesc = this.ld.getApplicationDescriptor()) != null) {
                    applicationDesc.setArguments(appArgs);
                }
                if (SingleInstanceManager.connectToServer((String)this.ld.toString())) {
                    if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                        Trace.println((String)"JnlpLaunchState.doInstallers(): SingleInstanceManager: OK from server");
                    }
                    String msg = "Single Instance already exist: " + this.ld.getCanonicalHome().toString();
                    Exception e = new Exception(msg);
                    JNLP2Manager.this.setErrorOccurred(msg, e);
                    throw new ExitException((Throwable)e, 5);
                }
                if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                    Trace.println((String)"JnlpLaunchState.doInstallers(): SingleInstanceManager: NOK from server");
                }
            } else if (Plugin2Manager.DEBUG && Plugin2Manager.VERBOSE) {
                Trace.println((String)("JnlpLaunchState.doInstallers(): No SingleInstanceManager, thread: " + Thread.currentThread()));
            }
            if (!installFiles.isEmpty()) {
                try {
                    JnlpxArgs.executeInstallers(installFiles, (Preloader)JNLP2Manager.this.getPreloaderDelegate());
                }
                catch (ExitException ee) {
                    if (ee.getReason() != 1) {
                        throw ee;
                    }
                    this.installerRelaunch = true;
                }
            }
        }

        private void relaunchApplet(boolean allSigned) throws JRESelectException, ExitException {
            JavaFXRuntimeDesc jfxRd;
            JREDesc bestJreDesc = null;
            this.findBestJreVersion();
            if (this.jreInstalled) {
                JNLP2Manager.this.setParameter("__jre_installed", String.valueOf(true));
            }
            if (!this.homeJVMVersionMatch) {
                if (JNLP2Manager.this.getParameter("__applet_request_version") == null) {
                    JNLP2Manager.this.setParameter("__applet_ssv_version", this.bestJREVersion);
                }
                bestJreDesc = this.jreDesc;
            }
            if ((jfxRd = this.ld.getJavaFXRuntimeDescriptor()) != null) {
                JNLP2Manager.this.setParameter("javafx_version", jfxRd.getVersion());
                if (!this.ld.isFXApp()) {
                    JNLP2Manager.this.setParameter("__ui_tk", "awt");
                    if (Plugin2Manager.DEBUG) {
                        Trace.println((String)"Use AWT TK along with FX", (TraceLevel)TraceLevel.BASIC);
                    }
                }
            }
            if (Plugin2Manager.DEBUG) {
                Trace.println((String)("JRESelectException: installerRelaunch: " + this.installerRelaunch), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: jreInstalled: " + this.jreInstalled), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: running JREInfo: " + JNLP2Manager.this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException: " + this.jreMatcher), (TraceLevel)TraceLevel.BASIC);
            }
            if (!JNLP2Manager.this.isAppletRelaunched()) {
                List paramList = this.jreMatcher.getSelectedJVMParameters().getCommandLineArguments(null, false, false, true, allSigned, false);
                if (JNLP2Manager.this.fireAppletRelaunchSupported()) {
                    JRESelectException e = new JRESelectException(bestJreDesc, ArgumentParsingUtil.encodeArgumentList((List)paramList));
                    if (this.homeJVMVersionMatch) {
                        throw e;
                    }
                    Trace.println((String)"jre version mismatch, delay relaunch to SSVValidation", (TraceLevel)TraceLevel.BASIC);
                    JNLP2Manager.this._relaunchException = e;
                } else {
                    Trace.println((String)"JRESelectException: ignored - relaunch not supported", (TraceLevel)TraceLevel.BASIC);
                }
            } else {
                Trace.println((String)"JRESelectException: ignored - relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
    }
}

