/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.config.Config;
import java.util.ArrayList;
import java.util.List;

public class Applet2ThreadGroup
extends ThreadGroup {
    public Applet2ThreadGroup(String name) {
        this(Thread.currentThread().getThreadGroup(), name);
    }

    public Applet2ThreadGroup(ThreadGroup parent, String name) {
        super(parent, name);
        this.setMaxPriority(4);
    }

    public static int getAppletThreadCount(int maxCount) {
        if (maxCount == 0) {
            return 0;
        }
        Thread[] threads = new Thread[maxCount];
        int count = 0;
        List<ThreadGroup> appThreadGroups = Applet2ThreadGroup.getAppletThreadGroups();
        for (ThreadGroup appThreadGroup : appThreadGroups) {
            Applet2ThreadGroup tg = (Applet2ThreadGroup)appThreadGroup;
            if ((count += tg.enumerate(threads)) < maxCount) continue;
            count = maxCount;
            break;
        }
        return count;
    }

    public static int getAppletThreadCount() {
        return Applet2ThreadGroup.getAppletThreadCount(Config.getMaxAppletThreadCount());
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        return tg;
    }

    public static List<ThreadGroup> getAppletThreadGroups() {
        ThreadGroup root = Applet2ThreadGroup.getRootThreadGroup();
        int size = root.activeGroupCount() + 5;
        if (size < 20) {
            size = 20;
        }
        ThreadGroup[] threadGroups = new ThreadGroup[size];
        int actualSize = 0;
        while ((actualSize = root.enumerate(threadGroups, true)) == size) {
            threadGroups = new ThreadGroup[size *= 2];
        }
        ArrayList<ThreadGroup> result = new ArrayList<ThreadGroup>(actualSize);
        for (int i = 0; i < actualSize; ++i) {
            if (!(threadGroups[i] instanceof Applet2ThreadGroup)) continue;
            result.add(threadGroups[i]);
        }
        return result;
    }
}

