/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.viewer.context;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import netscape.javascript.JSObject;
import sun.applet.AppletPanel;
import sun.plugin.viewer.AppletPanelCache;
import sun.plugin.viewer.context.AppletAudioClipFactory;
import sun.plugin.viewer.context.AppletImageFactory;
import sun.plugin.viewer.context.PluginAppletContext;

public abstract class DefaultPluginAppletContext
implements PluginAppletContext {
    private ArrayList<SoftReference<JSObject>> exported = new ArrayList();
    protected AppletPanel appletPanel;
    private static HashMap<URL, SoftReference<Image>> imageRefs = new HashMap();
    private static HashMap<URL, HashMap<URL, SoftReference<AudioClip>>> audioClipStore = new HashMap();
    private int persistStreamMaxSize = 65536;
    private static HashMap<URL, HashMap<String, byte[]>> streamStore = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioClip getAudioClip(URL url) {
        if (url == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Permission perm;
            try {
                perm = url.openConnection().getPermission();
            }
            catch (IOException exc) {
                return null;
            }
            if (perm != null) {
                sm.checkPermission(perm);
            }
        }
        SoftReference<AudioClip> ref = null;
        HashMap<URL, HashMap<URL, SoftReference<AudioClip>>> exc = audioClipStore;
        synchronized (exc) {
            HashMap<URL, SoftReference<AudioClip>> audioClips = audioClipStore.get(this.appletPanel.getCodeBase());
            if (audioClips == null) {
                audioClips = new HashMap();
                audioClipStore.put(this.appletPanel.getCodeBase(), audioClips);
            }
            if ((ref = audioClips.get(url)) == null || ref.get() == null) {
                ref = new SoftReference<AudioClip>(AppletAudioClipFactory.createAudioClip(url));
                audioClips.put(url, ref);
            }
        }
        AudioClip clip = ref.get();
        Trace.msgPrintln((String)"appletcontext.audio.loaded", (Object[])new Object[]{url}, (TraceLevel)TraceLevel.BASIC);
        return clip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Permission perm;
            try {
                perm = url.openConnection().getPermission();
            }
            catch (IOException exc) {
                return null;
            }
            if (perm != null) {
                sm.checkPermission(perm);
            }
        }
        SoftReference<Image> ref = null;
        HashMap<URL, SoftReference<Image>> exc = imageRefs;
        synchronized (exc) {
            ref = imageRefs.get(url);
            if (ref == null || ref.get() == null) {
                ref = new SoftReference<Image>(AppletImageFactory.createImage(url));
                imageRefs.put(url, ref);
            }
        }
        Image image = ref.get();
        Trace.msgPrintln((String)"appletcontext.image.loaded", (Object[])new Object[]{url}, (TraceLevel)TraceLevel.BASIC);
        return image;
    }

    @Override
    public Applet getApplet(String name) {
        Object[] appletPanels;
        name = name.toLowerCase();
        for (Object appletPanel1 : appletPanels = AppletPanelCache.getAppletPanels()) {
            AppletPanel p = (AppletPanel)appletPanel1;
            if (p == null || !p.isActive() && this.appletPanel != p) continue;
            String param = p.getParameter("name");
            if (param != null) {
                param = param.toLowerCase();
            }
            if (!name.equals(param) || !p.getDocumentBase().equals(this.appletPanel.getDocumentBase())) continue;
            try {
                if (!this.checkConnect(this.appletPanel.getCodeBase().getHost(), p.getCodeBase().getHost())) {
                    return null;
                }
            }
            catch (InvocationTargetException ee) {
                this.showStatus(ee.getTargetException().getMessage());
                return null;
            }
            catch (Exception ee) {
                this.showStatus(ee.getMessage());
                return null;
            }
            return p.getApplet();
        }
        return null;
    }

    @Override
    public Enumeration<Applet> getApplets() {
        Object[] appletPanels;
        Vector<Applet> v = new Vector<Applet>();
        for (Object appletPanel1 : appletPanels = AppletPanelCache.getAppletPanels()) {
            AppletPanel p = (AppletPanel)appletPanel1;
            if (p == null || !p.isActive() || !p.getDocumentBase().equals(this.appletPanel.getDocumentBase())) continue;
            try {
                if (!this.checkConnect(this.appletPanel.getCodeBase().getHost(), p.getCodeBase().getHost())) continue;
                v.addElement(p.getApplet());
            }
            catch (InvocationTargetException ee) {
                this.showStatus(ee.getTargetException().getMessage());
            }
            catch (Exception ee) {
                this.showStatus(ee.getMessage());
            }
        }
        Applet applet = this.appletPanel.getApplet();
        if (!v.contains(applet)) {
            v.addElement(applet);
        }
        return v.elements();
    }

    private boolean checkConnect(String sourceHostName, String targetHostName) throws Exception {
        SocketPermission panelSp = new SocketPermission(sourceHostName, "connect");
        SocketPermission sp = new SocketPermission(targetHostName, "connect");
        return panelSp.implies(sp);
    }

    @Override
    public void showDocument(URL url) {
        this.showDocument(url, "_top");
    }

    @Override
    public void showDocument(URL url, String target) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < target.length(); ++i) {
            char c = target.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        this.doShowDocument(url, buffer.toString());
    }

    public void doShowDocument(final URL url, final String target) {
        DefaultPluginAppletContext pac = this;
        Thread showDocThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSObject win = DefaultPluginAppletContext.this.getJSObject();
                    if (win != null) {
                        Object[] args = new Object[]{url.toString(), target};
                        win.call("open", args);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, "showDocument Thread");
        showDocThread.start();
    }

    @Override
    public void showStatus(String status) {
        if (status == null) {
            return;
        }
        int index = status.indexOf("\n");
        if (index != -1) {
            this.doShowStatus(status.substring(0, index));
        } else {
            this.doShowStatus(status);
        }
    }

    protected void doShowStatus(final String status) {
        final DefaultPluginAppletContext pac = this;
        Thread statusThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSObject win = pac.getJSObject();
                    if (win != null) {
                        win.eval("function setStatus() { self.status='" + status + "';};void(setTimeout(\"setStatus()\", 1500))");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }, "showStatus Thread");
        statusThread.start();
    }

    @Override
    public void addAppletPanelInContext(AppletPanel appletPanel) {
        this.appletPanel = appletPanel;
        AppletPanelCache.add(appletPanel);
    }

    @Override
    public void removeAppletPanelFromContext(AppletPanel appletPanel) {
        AppletPanelCache.remove(appletPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setStream(String name, InputStream is) throws IOException {
        HashMap<String, Object> streamMap = streamStore.get(this.appletPanel.getCodeBase());
        if (streamMap == null) {
            streamMap = new HashMap();
            streamStore.put(this.appletPanel.getCodeBase(), streamMap);
        }
        HashMap<String, byte[]> hashMap = streamMap;
        synchronized (hashMap) {
            if (is != null) {
                byte[] data = (byte[])streamMap.get(name);
                if (data == null) {
                    int streamSize = is.available();
                    if (streamSize >= this.persistStreamMaxSize) throw new IOException("Stream size exceeds the maximum limit");
                    data = new byte[streamSize];
                    is.read(data, 0, streamSize);
                    streamMap.put(name, data);
                } else {
                    streamMap.remove(name);
                    this.setStream(name, is);
                }
            } else {
                streamMap.remove(name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getStream(String name) {
        ByteArrayInputStream bAIS = null;
        HashMap<String, byte[]> streamMap = streamStore.get(this.appletPanel.getCodeBase());
        if (streamMap != null) {
            HashMap<String, byte[]> hashMap = streamMap;
            synchronized (hashMap) {
                byte[] data = streamMap.get(name);
                if (data != null) {
                    bAIS = new ByteArrayInputStream(data);
                }
            }
        }
        return bAIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getStreamKeys() {
        Iterator<String> iter = null;
        HashMap<String, byte[]> streamMap = streamStore.get(this.appletPanel.getCodeBase());
        if (streamMap != null) {
            HashMap<String, byte[]> hashMap = streamMap;
            synchronized (hashMap) {
                iter = streamMap.keySet().iterator();
            }
        }
        return iter;
    }

    private String getNameFromURL(URL url) {
        try {
            String file = url.getFile();
            int last = file.lastIndexOf(47);
            return file.substring(last + 1);
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJSObjectToExportedList(JSObject jsObject) {
        ArrayList<SoftReference<JSObject>> arrayList = this.exported;
        synchronized (arrayList) {
            this.exported.add(new SoftReference<JSObject>(jsObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        ArrayList<SoftReference<JSObject>> arrayList = this.exported;
        synchronized (arrayList) {
            for (SoftReference<JSObject> ref : this.exported) {
                JSObject obj;
                if (ref == null || (obj = ref.get()) == null || !(obj instanceof sun.plugin.javascript.JSObject)) continue;
                ((sun.plugin.javascript.JSObject)obj).cleanup();
            }
            this.exported.clear();
        }
    }
}

