/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class JarCacheUtil {
    public static final String FileVersionRegEx = "\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}\\.\\p{XDigit}{1,4}";
    private static final AccessControlContext ACC_FILE_INSTANCE;

    public static HashMap<String, String> getJarsWithVersion(String cacheArchive, String cacheVersion, String cacheArchiveEx) {
        String jarFileVersion;
        String jarFileName;
        HashMap<String, String> jarFileVersionMap = new HashMap<String, String>();
        if (cacheArchive != null && cacheVersion != null) {
            StringTokenizer verTok;
            int versionCount;
            StringTokenizer fileTok = new StringTokenizer(cacheArchive, ",", false);
            int fileCount = fileTok.countTokens();
            if (fileCount != (versionCount = (verTok = new StringTokenizer(cacheVersion, ",", false)).countTokens()) && Trace.isEnabled((TraceLevel)TraceLevel.BASIC)) {
                Trace.println((String)ResourceManager.getString((String)"cache.version_attrib_error"), (TraceLevel)TraceLevel.BASIC);
            }
            while (fileTok.hasMoreTokens() && verTok.hasMoreTokens()) {
                jarFileName = fileTok.nextToken().trim();
                jarFileVersion = verTok.nextToken().trim();
                jarFileVersionMap.put(jarFileName, jarFileVersion);
            }
        }
        if (cacheArchiveEx != null) {
            StringTokenizer jarTok = new StringTokenizer(cacheArchiveEx, ",", false);
            block1: while (jarTok.hasMoreTokens()) {
                String elem = jarTok.nextToken().trim();
                StringTokenizer fieldTok = new StringTokenizer(elem, ";", false);
                jarFileName = fieldTok.nextToken().trim();
                while (fieldTok.hasMoreTokens()) {
                    jarFileVersion = fieldTok.nextToken().trim();
                    if (!Pattern.matches(FileVersionRegEx, jarFileVersion)) continue;
                    jarFileVersionMap.put(jarFileName, jarFileVersion);
                    continue block1;
                }
            }
        }
        return jarFileVersionMap;
    }

    public static synchronized void preload(URL codeBase, Map<String, String> preloadMap) throws IOException {
        for (Map.Entry<String, String> entry : preloadMap.entrySet()) {
            String jarFileName = entry.getKey();
            String jarFileVersion = entry.getValue();
            URL url = new URL(codeBase, jarFileName);
            if (!URLUtil.checkTargetURL((URL)codeBase, (URL)url)) {
                throw new SecurityException("Permission denied: " + url);
            }
            URL jarUrl = null;
            jarUrl = jarFileVersion != null ? new URL("jar:" + url.toString() + "?version-id=" + jarFileVersion + "!/") : new URL("jar:" + url.toString() + "!/");
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            jarConnection.getContentLength();
        }
    }

    public static JarFile cloneJarFile(final JarFile jarFile) throws IOException {
        if (jarFile == null) {
            return jarFile;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    if (jarFile instanceof JarFile && jarFile instanceof ResourceObject) {
                        return (JarFile)((ResourceObject)jarFile).clone();
                    }
                    String path = jarFile.getName();
                    if (new File(path).exists()) {
                        return JarUtil.createJarFile((File)new File(jarFile.getName()), (boolean)true);
                    }
                    return jarFile;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause().getMessage());
        }
    }

    static {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write,delete"));
        ((PermissionCollection)perms).add(new RuntimePermission("accessDeclaredMembers"));
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

