/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.com;

import com.sun.deploy.resources.ResourceManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import sun.plugin.com.Dispatcher;
import sun.plugin.com.MethodDispatcher;
import sun.plugin.com.NameIDMap;
import sun.plugin.com.ParameterListCorrelator;
import sun.plugin.com.PropertyGetDispatcher;
import sun.plugin.com.PropertySetDispatcher;
import sun.plugin.javascript.ReflectUtil;

public class JavaClass {
    private static final boolean writeDebug = false;
    protected Class<?> wrappedClass = null;
    private boolean collected = false;
    protected Method[] methods = null;
    protected Field[] fields = null;
    NameIDMap methIDMap = new NameIDMap();
    NameIDMap fieldIDMap = new NameIDMap();

    public JavaClass(Class<?> classToWrap) {
        this.wrappedClass = classToWrap;
    }

    public String getName() {
        return this.wrappedClass.getName();
    }

    public Method getMethod(int index) {
        return this.methods[index - 32768];
    }

    public Method getMethod1(int index, Object[] args) throws InvocationTargetException {
        int correlationIndex = -1;
        int minConversionCount = Integer.MAX_VALUE;
        boolean ambiguous = false;
        String name = this.getMethod(index).getName();
        for (int i = this.methIDMap.get(name); i < this.methods.length; ++i) {
            if (!this.methods[i].getName().equals(name)) continue;
            Class<?>[] paramTypes = this.methods[i].getParameterTypes();
            if ((args == null || args.length == 0) && paramTypes.length == 0) {
                return this.methods[i];
            }
            ParameterListCorrelator correlator = new ParameterListCorrelator(paramTypes, args);
            if (!correlator.parametersCorrelateToClasses()) continue;
            int conversionCount = correlator.numberOfConversionsNeeded();
            if (conversionCount < minConversionCount) {
                correlationIndex = i;
                minConversionCount = conversionCount;
                ambiguous = false;
                if (conversionCount != 0) continue;
                break;
            }
            if (conversionCount != minConversionCount) continue;
            ambiguous = true;
        }
        if (ambiguous) {
            throw new InvocationTargetException(new Exception(ResourceManager.getString((String)"com.method.ambiguous")));
        }
        if (minConversionCount == Integer.MAX_VALUE) {
            throw new InvocationTargetException(new Exception(ResourceManager.getString((String)"com.method.notexists", (Object[])new Object[]{this.getMethod(index).getName()})));
        }
        return this.methods[correlationIndex];
    }

    public Field getField(int index) {
        return this.fields[index - 4096];
    }

    public Dispatcher getDispatcher(int flag, int index, Object[] params) throws InvocationTargetException {
        Field field;
        Method method;
        Dispatcher disp = null;
        if ((0x8000 & index) > 0 && (method = this.getMethod1(index, params)) != null) {
            disp = new MethodDispatcher(method);
        }
        if ((0x1000 & index) > 0 && (field = this.getField(index)) != null) {
            disp = (flag & 2) > 0 ? new PropertyGetDispatcher(field) : new PropertySetDispatcher(field);
        }
        return disp;
    }

    protected synchronized void collect() {
        if (!this.collected) {
            int i;
            this.methods = ReflectUtil.getJScriptMethods(this.wrappedClass);
            this.fields = ReflectUtil.getJScriptFields(this.wrappedClass);
            JavaClass.sort(this.methods);
            JavaClass.sort(this.fields);
            if (this.methods != null) {
                for (i = 0; i < this.methods.length; ++i) {
                    int id = this.methIDMap.get(this.methods[i].getName());
                    if (id != -1) continue;
                    this.methIDMap.put(this.methods[i].getName(), i);
                }
            }
            if (this.fields != null) {
                for (i = 0; i < this.fields.length; ++i) {
                    this.fieldIDMap.put(this.fields[i].getName(), i);
                }
            }
            this.collected = true;
        }
    }

    static void sort(Object[] elements) {
        Arrays.sort(elements, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String x = ((Member)o1).getName();
                String y = ((Member)o2).getName();
                return x.compareTo(y);
            }
        });
    }

    protected int getIdForName(String name) throws Exception {
        this.collect();
        int id = this.methIDMap.get(name);
        if (id != -1) {
            return id + 32768;
        }
        id = this.fieldIDMap.get(name);
        if (id != -1) {
            return id + 4096;
        }
        throw new Exception(ResourceManager.getString((String)"com.notexists", (Object[])new Object[]{name}));
    }
}

