/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.Window;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AWTFrameWindow
extends Window {
    private Frame frame;
    private final Object frameLock = new Object();
    protected Window.WindowSize currentSize = new Window.WindowSize(this, 0, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Frame getFrame() {
        Object object = this.frameLock;
        synchronized (object) {
            return this.frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFrame(Frame frame) {
        Object object = this.frameLock;
        synchronized (object) {
            this.frame = frame;
        }
    }

    public AWTFrameWindow() {
        JFrame j = new JFrame();
        j.getContentPane().setLayout(new BorderLayout());
        this.frame = j;
    }

    @Override
    public Object getWindowObject() {
        return this.getFrame();
    }

    @Override
    public void setBackground(int color) {
        Frame ef = this.getFrame();
        if (ef != null) {
            ef.setBackground(new Color(color));
        }
    }

    @Override
    public void setForeground(int color) {
        Frame ef = this.getFrame();
        if (ef != null) {
            ef.setForeground(new Color(color));
        }
    }

    @Override
    public void setVisible(boolean visible) {
        Frame ef = this.getFrame();
        if (ef != null) {
            ef.setVisible(visible);
        }
    }

    @Override
    public void setSize(final int width, final int height) {
        final Frame ef = this.getFrame();
        if (ef != null && width > 0 && height > 0) {
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ef.setSize(width, height);
                }
            });
        }
    }

    @Override
    public Window.WindowSize getSize() {
        Frame ef = this.getFrame();
        if (ef != null) {
            Dimension d = ef.getSize();
            this.currentSize.width = d.width;
            this.currentSize.height = d.height;
        }
        return this.currentSize;
    }

    @Override
    public void dispose() {
        this.dispose(null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(final Window.DisposeListener disposeListener, long millisToWait) {
        Frame ef = this.getFrame();
        Object object = this.frameLock;
        synchronized (object) {
            this.frame = null;
        }
        if (ef != null && ef instanceof java.awt.Window) {
            Object disposeLock;
            final Frame parentWindow = ef;
            Object object2 = disposeLock = new Object();
            synchronized (object2) {
                this.invokeLater(parentWindow, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block5: {
                            try {
                                parentWindow.dispose();
                            }
                            catch (Exception ex) {
                                Trace.ignored(ex);
                                if (disposeListener == null) break block5;
                                disposeListener.disposeFailed();
                            }
                        }
                        Object object = disposeLock;
                        synchronized (object) {
                            disposeLock.notifyAll();
                        }
                    }
                });
                if (millisToWait > 0L) {
                    try {
                        disposeLock.wait(millisToWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void setPosition(int x, int y) {
        Frame ef = this.getFrame();
        if (ef != null) {
            ef.setLocation(x, y);
        }
    }

    public void invokeLater(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    public void invokeLater(Component component, Runnable r) {
        this.invokeLater(r);
    }
}

