/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.Environment;
import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.trace.TraceListener;
import com.sun.deploy.trace.TraceMessage;
import com.sun.deploy.trace.TraceStream;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.ConsoleTraceListener;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;

public class Trace {
    private static boolean automation = false;
    private static final List<TraceMessage> initQueue = new ArrayList<TraceMessage>();
    private static boolean isInitDone = false;
    private static final List<TraceMessage> queue = new ArrayList<TraceMessage>();
    private static final Set<TraceListener> traceListeners = new HashSet<TraceListener>();
    private static final Set<TraceLevel> enabledTraceLevels = Collections.synchronizedSet(new HashSet());
    private static final TeeStream traceStdout = new TeeStream(new TraceStream());
    private static final TeeStream traceStderr = new TeeStream(new TraceStream());
    private static PrintStream realStdout = null;
    private static PrintStream realStderr = null;
    private static final String[] nativeTracePrefixes = new String[]{"javaws", "jweblauncher", "npjp2", "jp2iexp", "deploy", "javacpl"};
    private static final TraceMsgQueueChecker queueChecker = new TraceMsgQueueChecker();

    private Trace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureMessageQueueProcessingStarted() {
        TraceMsgQueueChecker traceMsgQueueChecker = queueChecker;
        synchronized (traceMsgQueueChecker) {
            queueChecker.notifyAll();
        }
    }

    public static synchronized void redirectStdioStderr() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (null == realStdout && realStdout != traceStdout) {
                    realStdout = System.out;
                }
                if (null == realStderr && realStderr != traceStderr) {
                    realStderr = System.err;
                }
                System.setOut(traceStdout);
                System.setErr(traceStderr);
                return null;
            }
        });
    }

    public static synchronized void restoreStdioStdErr() {
        if (null != realStdout && System.out == traceStdout) {
            System.setOut(realStdout);
        }
        if (null != realStderr && System.err == traceStderr) {
            System.setErr(realStderr);
        }
        realStdout = null;
        realStderr = null;
    }

    public static synchronized PrintStream getRealStdout() {
        if (null != realStdout && System.out == traceStdout) {
            return realStdout;
        }
        return System.out;
    }

    public static synchronized PrintStream getRealStderr() {
        if (null != realStderr && System.err == traceStderr) {
            return realStderr;
        }
        return System.err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        while (true) {
            List<TraceMessage> list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    break;
                }
                queue.notifyAll();
                try {
                    queue.wait(200L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        Trace.fireFlushEvent();
    }

    public static boolean isEnabled() {
        return enabledTraceLevels.size() > 1;
    }

    public static void setInitialTraceLevel() {
        Trace.setInitialTraceLevel(false);
    }

    public static void setInitialTraceLevel(boolean tckMode) {
        String value = Config.getStringProperty("deployment.trace.level");
        if (tckMode && value != null) {
            value = value.startsWith("tck-") ? value.replaceAll("tck-", "") : null;
        }
        Trace.setInitialTraceLevel(value);
    }

    public static void setInitialTraceLevel(String initTraceLevel) {
        if (initTraceLevel != null && !initTraceLevel.equals("")) {
            StringTokenizer st = new StringTokenizer(initTraceLevel, "|");
            while (st.hasMoreTokens()) {
                String option = st.nextToken();
                if (option.equalsIgnoreCase("all")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    Trace.setEnabled(TraceLevel.UI, true);
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    Trace.setEnabled(TraceLevel.RULESET, true);
                    break;
                }
                if (option.equalsIgnoreCase("basic")) {
                    Trace.setEnabled(TraceLevel.BASIC, true);
                    continue;
                }
                if (option.equalsIgnoreCase("cache")) {
                    Trace.setEnabled(TraceLevel.CACHE, true);
                    continue;
                }
                if (option.equalsIgnoreCase("net")) {
                    Trace.setEnabled(TraceLevel.NETWORK, true);
                    continue;
                }
                if (option.equalsIgnoreCase("temp")) {
                    Trace.setEnabled(TraceLevel.TEMP, true);
                    continue;
                }
                if (option.equalsIgnoreCase("security")) {
                    Trace.setEnabled(TraceLevel.SECURITY, true);
                    continue;
                }
                if (option.equalsIgnoreCase("liveconnect")) {
                    Trace.setEnabled(TraceLevel.LIVECONNECT, true);
                    continue;
                }
                if (option.equalsIgnoreCase("ui")) {
                    Trace.setEnabled(TraceLevel.UI, true);
                    continue;
                }
                if (option.equalsIgnoreCase("preloader")) {
                    Trace.setEnabled(TraceLevel.PRELOADER, true);
                    continue;
                }
                if (!option.equalsIgnoreCase("ruleset")) continue;
                Trace.setEnabled(TraceLevel.RULESET, true);
            }
        }
    }

    public static boolean isEnabled(TraceLevel level) {
        return enabledTraceLevels.contains(level);
    }

    public static void setEnabled(TraceLevel level, boolean trace) {
        if (trace) {
            enabledTraceLevels.add(level);
        } else {
            enabledTraceLevels.remove(level);
        }
    }

    public static boolean isAutomationEnabled() {
        return automation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDone() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (!Config.getBooleanProperty("deployment.trace.redirect.stdio")) {
                    traceStdout.setTee(realStdout);
                    traceStderr.setTee(realStderr);
                }
                return null;
            }
        });
        List<TraceMessage> list = queue;
        synchronized (list) {
            isInitDone = true;
            List<TraceMessage> list2 = initQueue;
            synchronized (list2) {
                ListIterator<TraceMessage> i = initQueue.listIterator();
                while (i.hasNext()) {
                    TraceMessage m = (TraceMessage)i.next();
                    TraceLevel level = m.getLevel();
                    if (!enabledTraceLevels.contains(level)) continue;
                    Trace.enQueue(m);
                }
                initQueue.clear();
            }
        }
    }

    public static void enableAutomation(boolean automated) {
        automation = automated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enInitQueue(TraceMessage tm) {
        List<TraceMessage> list = initQueue;
        synchronized (list) {
            initQueue.add(tm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enQueue(TraceMessage tm) {
        List<TraceMessage> list = queue;
        synchronized (list) {
            queue.add(tm);
            queue.notifyAll();
        }
    }

    public static void print(String message, TraceLevel traceLevel) {
        if (!isInitDone) {
            TraceMessage tm = new TraceMessage(traceLevel, message);
            Trace.enInitQueue(tm);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage tm = new TraceMessage(traceLevel, message);
            Trace.enQueue(tm);
        }
    }

    public static void println(String message, TraceLevel traceLevel) {
        if (!isInitDone) {
            TraceMessage tm = new TraceMessage(traceLevel, message, true);
            Trace.enInitQueue(tm);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage tm = new TraceMessage(traceLevel, message, true);
            Trace.enQueue(tm);
        }
    }

    public static void println(String message) {
        Trace.println(message, TraceLevel.DEFAULT);
    }

    public static void print(String message) {
        Trace.print(message, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String resource, Object[] params, TraceLevel traceLevel) {
        if (!isInitDone) {
            TraceMessage tm = new TraceMessage(traceLevel, ResourceManager.getString(resource, params), true);
            Trace.enInitQueue(tm);
        } else if (enabledTraceLevels.contains(traceLevel)) {
            TraceMessage tm = new TraceMessage(traceLevel, ResourceManager.getString(resource, params), true);
            Trace.enQueue(tm);
        }
    }

    public static void msgPrintln(String resource, Object[] params) {
        Trace.msgPrintln(resource, params, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String resource) {
        Trace.msgPrintln(resource, null, TraceLevel.BASIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTraceListener(TraceListener tl) {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.add(tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(TraceListener tl) {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.remove(tl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTraceListeners() {
        Set<TraceListener> set = traceListeners;
        synchronized (set) {
            traceListeners.clear();
        }
    }

    public static void resetTraceLevel() {
        enabledTraceLevels.clear();
        enabledTraceLevels.add(TraceLevel.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePrintlnEvent(TraceMessage tm) {
        TraceListener[] traceListenerArray = traceListeners;
        synchronized (traceListeners) {
            TraceListener[] listeners = traceListeners.toArray(new TraceListener[traceListeners.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (TraceListener listener : listeners) {
                try {
                    listener.print(tm.getMessage());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireFlushEvent() {
        TraceListener[] traceListenerArray = traceListeners;
        synchronized (traceListeners) {
            TraceListener[] listeners = traceListeners.toArray(new TraceListener[traceListeners.size()]);
            // ** MonitorExit[var1] (shouldn't be in output)
            for (TraceListener listener : listeners) {
                try {
                    listener.flush();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public static void ignoredException(Exception e) {
        Trace.ignored(e);
    }

    public static void ignored(Throwable t) {
        if (enabledTraceLevels.size() > 1) {
            t.printStackTrace();
        }
    }

    public static void ignored(Throwable e, boolean causeOnly) {
        Throwable t = e;
        if (causeOnly && e.getCause() != null) {
            t = e.getCause();
        }
        Trace.ignored(t);
    }

    public static void printException(Throwable e) {
        Trace.printException(null, e);
    }

    public static void printException(Component parentComponent, Throwable e) {
        Trace.printException(parentComponent, e, null, null);
    }

    public static void printException(Throwable e, String desc, String caption) {
        Trace.printException(null, e, desc, caption);
    }

    public static void printException(Component parentComponent, Throwable e, String desc, String caption) {
        Trace.printException(parentComponent, e, desc, caption, true);
    }

    public static void printException(Component parentComponent, Throwable e, String desc, String caption, boolean show) {
        Trace.printException(parentComponent, e, null, desc, caption, show);
    }

    public static void printException(Component parentComponent, Throwable e, AppInfo ainfo, String desc, String caption, boolean show) {
        Trace.println("Ignored exception: " + e);
        if (show && !Trace.isAutomationEnabled()) {
            if (desc == null) {
                desc = ResourceManager.getString("dialogfactory.general_error");
            }
            ToolkitStore.getUI().showExceptionDialog(parentComponent, ainfo, e, caption, desc, null, null);
        }
    }

    public static void netPrintln(String msg) {
        Trace.println(msg, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String resource) {
        Trace.msgPrintln(resource, null, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String resource, Object[] params) {
        Trace.msgPrintln(resource, params, TraceLevel.NETWORK);
    }

    public static void netPrintException(Throwable e) {
        Trace.printException(null, e, ResourceManager.getString("dialogfactory.net_error"), null, false);
    }

    public static void netPrintException(Throwable e, String desc, String caption) {
        Trace.printException(null, e, desc, caption, false);
    }

    public static void securityPrintln(String msg) {
        Trace.println(msg, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String resource) {
        Trace.msgPrintln(resource, null, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String resource, Object[] params) {
        Trace.msgPrintln(resource, params, TraceLevel.SECURITY);
    }

    public static void securityPrintException(Throwable e) {
        Trace.printException(null, e, ResourceManager.getString("dialogfactory.security_error"), null, true);
    }

    public static void securityPrintException(Throwable e, String desc, String caption) {
        Trace.printException(null, e, desc, caption, true);
    }

    public static void liveConnectPrintln(String msg) {
        Trace.println(msg, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String resource) {
        Trace.msgPrintln(resource, null, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String resource, Object[] params) {
        Trace.msgPrintln(resource, params, TraceLevel.LIVECONNECT);
    }

    public static void liveConnectPrintException(Throwable e) {
        Trace.printException(null, e, null, null, false);
    }

    public static void cleanUpLogFiles(final String prefix, final String suffix, File directory) {
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String filename = pathname.getName();
                if (filename.startsWith(prefix) && filename.endsWith(suffix)) {
                    return true;
                }
                for (int i = 0; i < nativeTracePrefixes.length; ++i) {
                    if (!filename.startsWith(nativeTracePrefixes[i])) continue;
                    return true;
                }
                return false;
            }
        });
        int iMaxNumOfFiles = Config.getIntProperty("deployment.max.output.files");
        if (iMaxNumOfFiles > 0 && files.length >= iMaxNumOfFiles) {
            int numOfFiles = files.length;
            Arrays.sort(files, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Date t1 = new Date(((File)o1).lastModified());
                    Date t2 = new Date(((File)o2).lastModified());
                    return t1.compareTo(t2);
                }
            });
            for (int i = 0; i < numOfFiles - iMaxNumOfFiles + 1; ++i) {
                files[i].delete();
            }
        }
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        try {
            if (directory != null) {
                if (!directory.isDirectory()) {
                    directory.mkdirs();
                }
                Trace.cleanUpLogFiles(prefix, suffix, directory);
            }
            String fileName = prefix + "_" + Platform.get().getNativePID() + "_";
            return File.createTempFile(fileName, suffix, directory);
        }
        catch (Exception ioe) {
            Trace.ignored(ioe);
            return null;
        }
    }

    public static String getIntro() {
        DateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy");
        Date expires = new Date(BuiltInProperties.getExpirationTime());
        formatter = DateFormat.getInstance();
        StringBuffer sb = new StringBuffer();
        String key = Environment.isJavaWebStart() ? "product.javaws.name" : "product.javapi.name";
        sb.append(ResourceManager.getString(key, BuiltInProperties.getProperty("DEPLOY_VERSION")));
        sb.append("\n");
        sb.append(ResourceManager.getString("console.using_jre_version", System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name")));
        sb.append("\n");
        sb.append(ResourceManager.getString("console.expires", formatter.format(expires)));
        sb.append("\n");
        sb.append(ResourceManager.getString("console.user_home") + " = " + System.getProperty("user.home"));
        String additionalLogs = Trace.checkForAdditionalLogs();
        if (additionalLogs != null) {
            sb.append("\n");
            sb.append(additionalLogs);
        }
        return sb.toString();
    }

    public static String checkForAdditionalLogs() {
        String logFile = Config.getLogDirectory() + File.separator + "jweblauncher_stderr_" + Platform.get().getNativePID() + ".trace";
        File file = new File(logFile);
        if (file.exists()) {
            return ResourceManager.getString("console.additional.log", logFile);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConsoleMessages() {
        TraceListener[] traceListenerArray = traceListeners;
        synchronized (traceListeners) {
            TraceListener[] listeners = traceListeners.toArray(new TraceListener[traceListeners.size()]);
            // ** MonitorExit[var1] (shouldn't be in output)
            for (TraceListener listener : listeners) {
                if (!(listener instanceof ConsoleTraceListener)) continue;
                return ((ConsoleTraceListener)listener).getTraceMessages();
            }
            return "";
        }
    }

    static {
        Trace.resetTraceLevel();
        Thread traceMsgQueueThread = new Thread((Runnable)queueChecker, "traceMsgQueueThread");
        traceMsgQueueThread.setDaemon(true);
        traceMsgQueueThread.start();
    }

    private static class TeeStream
    extends PrintStream {
        private PrintStream tee = null;

        public TeeStream(OutputStream out) {
            super(out);
        }

        public void setTee(PrintStream other) {
            this.tee = other;
        }

        @Override
        public void flush() {
            super.flush();
            if (this.tee != null) {
                this.tee.flush();
            }
        }

        @Override
        public void write(byte[] buf, int offset, int length) {
            super.write(buf, offset, length);
            if (this.tee != null) {
                this.tee.write(buf, offset, length);
            }
        }

        @Override
        public void write(int b) {
            super.write(b);
            if (this.tee != null) {
                this.tee.write(b);
            }
        }

        @Override
        public void write(byte[] chars) throws IOException {
            super.write(chars);
            if (this.tee != null) {
                this.tee.write(chars);
            }
        }
    }

    private static class TraceMsgQueueChecker
    implements Runnable {
        private TraceMsgQueueChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TraceMsgQueueChecker traceMsgQueueChecker = this;
                synchronized (traceMsgQueueChecker) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (true) {
                TraceMessage tm = null;
                List list = queue;
                synchronized (list) {
                    if (queue.isEmpty()) {
                        try {
                            queue.wait();
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    try {
                        tm = (TraceMessage)queue.remove(0);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    queue.notifyAll();
                }
                if (tm == null) continue;
                Trace.firePrintlnEvent(tm);
            }
        }
    }
}

