/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class SelectableSecurityManager
extends SecurityManager {
    private static final SelectableSecurityManager instance = AccessController.doPrivileged(new PrivilegedAction<SelectableSecurityManager>(){

        @Override
        public SelectableSecurityManager run() {
            return new SelectableSecurityManager();
        }
    });
    private static final Object lock = new Object();
    private InheritableThreadLocal<Boolean> enabled = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static volatile int count = 0;

    private SelectableSecurityManager() {
    }

    public static SelectableSecurityManager getInstance() {
        return instance;
    }

    @Override
    public void checkPermission(Permission permission) {
        if (this.isEnabled()) {
            super.checkPermission(permission);
        }
    }

    @Override
    public void checkPermission(Permission permission, Object context) {
        if (this.isEnabled()) {
            super.checkPermission(permission, context);
        }
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        Object object = lock;
        synchronized (object) {
            if (this.isEnabled()) {
                return;
            }
            ++count;
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(instance);
            }
            this.enabled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = lock;
        synchronized (object) {
            if (!this.isEnabled()) {
                return;
            }
            this.enabled.set(false);
            if (--count <= 0 && System.getSecurityManager() == instance) {
                System.setSecurityManager(null);
            }
        }
    }
}

