/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.DeployJavaUtilJarAccess;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EnhancedJarVerifier
extends JarVerifier {
    public static JarVerifier create(URL location, String version, File jar, File nativePath) {
        if (ResourceProvider.get().hasEnhancedJarAccess()) {
            return new EnhancedJarVerifier(location, version, jar, nativePath);
        }
        return null;
    }

    EnhancedJarVerifier(URL location, String version, File jar, File nativePath) {
        super(location, version, jar, nativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(DownloadDelegate dd) throws IOException, JARSigningException {
        JarFile jar = JarUtil.createJarFile(this.jarFile, true);
        this.manifest = jar.getManifest();
        try {
            Enumeration<Object> entries = null;
            int count = 0;
            int total = jar.size();
            CodeSource[] codeSources = null;
            if (dd != null) {
                dd.validating(this.jarLocation, 0, total);
            }
            DeployJavaUtilJarAccess jarAccess = DeployJavaUtilJarAccess.instance();
            codeSources = jarAccess.getCodeSources(jar, this.jarLocation);
            if (BlackList.getInstance().checkJarFile(jar)) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 5);
            }
            if (TrustedLibraries.checkJarFile(jar)) {
                Attributes attrs = this.manifest.getMainAttributes();
                attrs.putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            if (codeSources != null && codeSources.length > 0) {
                ArrayList<CodeSource> l = new ArrayList<CodeSource>();
                for (CodeSource codeSource : codeSources) {
                    if (codeSource.getCertificates() == null) continue;
                    this.hasOnlyUnsignedEntries = false;
                    l.add(codeSource);
                }
                if (l.size() != codeSources.length) {
                    codeSources = l.toArray(new CodeSource[l.size()]);
                } else {
                    this.hasOnlySignedEntries = true;
                }
            }
            entries = codeSources != null && codeSources.length > 0 ? jarAccess.entryNames(jar, codeSources) : jar.entries();
            if (codeSources != null && codeSources.length == 1) {
                Certificate[] certs = codeSources[0].getCertificates();
                this.singleSignerIndicesCert = new int[certs.length];
                for (int i = 0; i < certs.length; ++i) {
                    this.signerCerts.add(certs[i]);
                    this.singleSignerIndicesCert[i] = i;
                }
                this.codeSourceCertCache.put(this.singleSignerIndicesCert, codeSources[0]);
                CodeSigner[] entrySigners = codeSources[0].getCodeSigners();
                this.singleSignerIndicesCS = new int[entrySigners.length];
                for (int i = 0; i < entrySigners.length; ++i) {
                    this.signersCS.add(entrySigners[i]);
                    this.singleSignerIndicesCS[i] = i;
                }
                this.codeSourceCache.put(this.singleSignerIndicesCS, codeSources[0]);
                this.hasSingleCodeSource = true;
            }
            while (entries.hasMoreElements()) {
                JarEntry entry;
                String name;
                ++count;
                if (codeSources != null && codeSources.length > 0) {
                    name = (String)entries.nextElement();
                    entry = jar.getJarEntry(name);
                } else {
                    entry = (JarEntry)entries.nextElement();
                    name = entry.getName();
                }
                if (name != null && entry != null && JarUtil.canSkipEntry(entry)) continue;
                if (entry == null) {
                    this.hasMissingSignedEntries = true;
                    Trace.println("signed entry \"" + name + "\" missing from jar " + this.jarLocation, TraceLevel.CACHE);
                }
                this.authenticateJarEntry(jar, entry);
                this.processCertificates(jar, entry, name);
                this.processSigners(jar, entry, name);
                if (dd == null || count % 10 != 0 && count < total) continue;
                dd.validating(this.jarLocation, count, total);
            }
            if (dd != null) {
                dd.validating(this.jarLocation, total, total);
            }
        }
        finally {
            jar.close();
            this.warnIfUnsigned();
        }
    }
}

