/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.JDialog;

public class DeployClientAuthCertStore
implements CertStore {
    private static JDialog myParent = null;
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserClientCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemClientCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPass = null;
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    protected DeployClientAuthCertStore(JDialog inParent, int storeType) {
        myParent = inParent;
        this.certStoreType = storeType;
    }

    public static CertStore getCertStore(JDialog inParent) {
        return new ImmutableCertStore(new DeployClientAuthCertStore(inParent, 3));
    }

    public static DeployClientAuthCertStore getUserCertStore(JDialog inParent) {
        return new DeployClientAuthCertStore(inParent, 1);
    }

    public static CertStore getSystemCertStore(JDialog inParent) {
        return new ImmutableCertStore(new DeployClientAuthCertStore(inParent, 2));
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long lastModified;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (lastModified = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserClientCerts = this.loadCertStore(_userFilename, integrityCheck);
            this._userLastModified = lastModified;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (lastModified = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemClientCerts = this.loadCertStore(_systemFilename, integrityCheck);
            this._sysLastModified = lastModified;
        }
    }

    private KeyStore loadCertStore(final String filename, final boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loading", new Object[]{filename});
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(filename);
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        if (integrityCheck) {
                            DeployClientAuthCertStore.access$002(DeployClientAuthCertStore.this, DeployClientAuthCertStore.this.getPasswordDialog());
                            if (DeployClientAuthCertStore.this.keyPass != null) {
                                DeployClientAuthCertStore.this.cancelFlag = false;
                                keyStore.load(bis, DeployClientAuthCertStore.this.keyPass);
                            } else {
                                DeployClientAuthCertStore.this.cancelFlag = true;
                            }
                        } else {
                            keyStore.load(bis, null);
                        }
                        bis.close();
                        fis.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            Trace.securityPrintException(e);
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.loaded", new Object[]{filename});
        return keyStore;
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saving", new Object[]{_userFilename});
        if (this.keyPass != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                        File file = new File(_userFilename);
                        file.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(file);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        DeployClientAuthCertStore.this._deploymentUserClientCerts.store(bos, DeployClientAuthCertStore.this.keyPass);
                        bos.close();
                        fos.close();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof CertificateException) {
                    throw (CertificateException)ex;
                }
                if (ex instanceof KeyStoreException) {
                    throw (KeyStoreException)ex;
                }
                if (ex instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)ex;
                }
                Trace.securityPrintException(e);
            }
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.saved", new Object[]{_userFilename});
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.adding");
        String newAlias = this._deploymentUserClientCerts.getCertificateAlias(cert);
        if (newAlias == null) {
            Random rand = new Random();
            boolean found = false;
            String alias = null;
            do {
                Certificate c;
                if ((c = this._deploymentUserClientCerts.getCertificate(alias = "clientauthcert" + rand.nextLong())) != null) continue;
                found = true;
            } while (!found);
            this._deploymentUserClientCerts.setCertificateEntry(alias, cert);
            Trace.msgSecurityPrintln("clientauthcertstore.cert.added", new Object[]{alias});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCertKey(Certificate[] certChain, Key inKey) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        String newAlias = this._deploymentUserClientCerts.getCertificateAlias(certChain[0]);
        if (newAlias == null) {
            Random rand = new Random();
            boolean found = false;
            String alias = null;
            do {
                Certificate c;
                if ((c = this._deploymentUserClientCerts.getCertificate(alias = "clientauthcert" + rand.nextLong())) != null) continue;
                found = true;
            } while (!found);
            if (this.keyPass == null && !this.cancelFlag) {
                this.keyPass = this.getPasswordDialog();
            }
            if (this.keyPass != null) {
                File ksFile = new File(_userFilename);
                if (ksFile.exists()) {
                    FileInputStream fis = new FileInputStream(_userFilename);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    try {
                        this._deploymentUserClientCerts.load(bis, this.keyPass);
                        this._deploymentUserClientCerts.setKeyEntry(alias, inKey, this.keyPass, certChain);
                    }
                    catch (Exception e) {
                        Trace.securityPrintException(e);
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        bis.close();
                        fis.close();
                    }
                } else {
                    this._deploymentUserClientCerts.setKeyEntry(alias, inKey, this.keyPass, certChain);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        Certificate[] certArray = new Certificate[]{cert};
        return this.remove(certArray);
    }

    public boolean remove(Certificate[] cert) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removing");
        String alias = null;
        if (this.keyPass != null) {
            try {
                File infile = new File(_userFilename);
                KeyStore mykeyStore = KeyStore.getInstance("JKS");
                mykeyStore.load(new BufferedInputStream(new FileInputStream(infile)), this.keyPass);
                for (int j = 0; j < cert.length; ++j) {
                    alias = this._deploymentUserClientCerts.getCertificateAlias(cert[j]);
                    if (alias == null) continue;
                    this._deploymentUserClientCerts.deleteEntry(alias);
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof KeyStoreException) {
                    throw (KeyStoreException)e;
                }
                Trace.securityPrintException(e);
                return false;
            }
        } else {
            return false;
        }
        Trace.msgSecurityPrintln("clientauthcertstore.cert.removed", new Object[]{alias});
        return true;
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.instore");
        String alias = null;
        alias = this._deploymentSystemClientCerts.getCertificateAlias(cert);
        if (alias != null) {
            return true;
        }
        alias = this._deploymentUserClientCerts.getCertificateAlias(cert);
        return alias != null;
    }

    @Override
    public boolean verify(Certificate cert) {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        HashSet<X509Certificate> deployClientAuthCerts = new HashSet<X509Certificate>();
        if ((this.certStoreType & 1) == 1) {
            deployClientAuthCerts.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            deployClientAuthCerts.addAll(this.getCertificates(2));
        }
        return deployClientAuthCerts;
    }

    private Collection<X509Certificate> getCertificates(int myCertStoreType) throws KeyStoreException {
        Trace.msgSecurityPrintln("clientauthcertstore.cert.getcertificates");
        KeyStore ks = null;
        ks = myCertStoreType == 1 ? this._deploymentUserClientCerts : this._deploymentSystemClientCerts;
        Enumeration<String> keyAliases = ks.aliases();
        TreeSet<String> tsCerts = new TreeSet<String>();
        while (keyAliases.hasMoreElements()) {
            String alias = keyAliases.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            tsCerts.add(alias);
        }
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        for (String sortAlias : tsCerts) {
            Certificate[] certChain = ks.getCertificateChain(sortAlias);
            if (certChain == null) continue;
            for (Certificate cert : certChain) {
                certCollection.add((X509Certificate)cert);
            }
        }
        return certCollection;
    }

    protected char[] getPasswordDialog() {
        CredentialInfo passwordInfo = ToolkitStore.getUI().showPasswordDialog(myParent, DeployClientAuthCertStore.getMessage("password.dialog.title"), DeployClientAuthCertStore.getMessage("clientauth.user.password.dialog.text"), false, false, null, false, null);
        if (passwordInfo == null) {
            return null;
        }
        return passwordInfo.getPassword();
    }

    private static String getMessage(String key) {
        return ResourceManager.getString(key);
    }

    static /* synthetic */ char[] access$002(DeployClientAuthCertStore x0, char[] x1) {
        x0.keyPass = x1;
        return x1;
    }

    static {
        _userFilename = Config.getUserClientAuthCertFile();
        _systemFilename = Config.getSystemClientAuthCertFile();
    }
}

