/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

final class DeniedCertStore
implements CertStore {
    private KeyStore deniedKS = null;

    DeniedCertStore() {
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.deniedKS == null) {
            try {
                this.deniedKS = KeyStore.getInstance("JKS");
                this.deniedKS.load(null, new char[0]);
            }
            catch (IOException ioe) {
                Trace.msgSecurityPrintln(ioe.getMessage());
            }
            catch (KeyStoreException kse) {
                Trace.msgSecurityPrintln(kse.getMessage());
            }
            catch (NoSuchAlgorithmException nsae) {
                Trace.msgSecurityPrintln(nsae.getMessage());
            }
            catch (CertificateException ce) {
                Trace.msgSecurityPrintln(ce.getMessage());
            }
        }
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        return CertUtils.add(this.deniedKS, "deniedcertstore", cert, loc, tsFlag);
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.removing");
        String alias = this.deniedKS.getCertificateAlias(cert);
        if (alias != null) {
            this.deniedKS.deleteEntry(alias);
        }
        Trace.msgSecurityPrintln("deniedcertstore.cert.removed");
        return true;
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        return CertUtils.contains(this.deniedKS, cert, loc, tsFlag);
    }

    @Override
    public boolean verify(Certificate cert) throws KeyStoreException {
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.getcertificates");
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        Enumeration<String> keyAliases = this.deniedKS.aliases();
        while (keyAliases.hasMoreElements()) {
            String myAlias = keyAliases.nextElement();
            X509Certificate cert = (X509Certificate)this.deniedKS.getCertificate(myAlias);
            certCollection.add(cert);
        }
        return certCollection;
    }
}

