/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.AuthCacheBridge;
import com.sun.deploy.security.AuthKey;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.Base64Wrapper;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

public class CredentialManager {
    public static final long LOGIN_SESSION_INVALID = -1L;
    private static final String DELIM = ",";
    static CredentialManager instance = null;
    private CredentialCache credCache = new CredentialCache();
    private CredentialPersistor persistor = new CredentialPersistor();
    private Map<String, CredentialInfo> serverMap = CredentialPersistor.access$000(this.persistor);
    private SessionProperties sessionProps = new SessionProperties("session.credentials");
    private static final AccessControlContext ACC_FILE_INSTANCE;

    CredentialManager() {
        SessionState.register(this.sessionProps);
        if (!this.sessionProps.isEmpty()) {
            Set<String> keys = this.sessionProps.stringPropertyNames();
            for (String key : keys) {
                String value = this.sessionProps.getProperty(key);
                try {
                    String[] strs = key.split(DELIM, 3);
                    if (strs.length != 3) continue;
                    CredentialInfo info = new CredentialInfo();
                    info.setUserName(new String(Base64Wrapper.decodeFromString(strs[0])));
                    info.setDomain(new String(Base64Wrapper.decodeFromString(strs[1])));
                    info.setSessionId(this.getLoginSessionId());
                    info.setPassword(this.decryptPassword(Base64Wrapper.decodeFromString(value)));
                    this.serverMap.put(new String(Base64Wrapper.decodeFromString(strs[2])), info);
                }
                catch (Exception e) {
                    Trace.ignored(e);
                }
            }
        }
        if (this.persistor.getSavedCredentialCount() > this.serverMap.size()) {
            this.persistor.persistAllCredentials(this.serverMap);
        }
        AuthCacheValue.setAuthCache((AuthCache)this.credCache);
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new CredentialManager();
        }
        return instance;
    }

    protected long getLoginSessionId() {
        return -1L;
    }

    protected boolean isPasswordEncryptionSupported() {
        return false;
    }

    protected boolean isPasswordStorageSupported() {
        return this.isPasswordEncryptionSupported();
    }

    protected byte[] encryptPassword(char[] pass) {
        return new byte[0];
    }

    protected char[] decryptPassword(byte[] pass) {
        return new char[0];
    }

    public void saveCredential(AuthKey key, CredentialInfo info) {
        info.setSessionId(this.getLoginSessionId());
        CredentialInfo cred = (CredentialInfo)info.clone();
        String keyId = CredentialManager.buildConnectionKey(key);
        if (this.isPasswordEncryptionSupported()) {
            byte[] encryptedPassword = this.encryptPassword(info.getPassword());
            if (cred.isPasswordSaveApproved()) {
                cred.setEncryptedPassword(encryptedPassword);
            } else if (encryptedPassword.length > 0) {
                String user = cred.getUserName();
                String user64 = user == null ? "" : Base64Wrapper.encodeToString(user.getBytes());
                String domain = cred.getDomain();
                String domain64 = domain == null ? "" : Base64Wrapper.encodeToString(domain.getBytes());
                String key64 = Base64Wrapper.encodeToString(keyId.getBytes());
                String sessionKey = this.escapeForPropertyKey(user64 + DELIM + domain64 + DELIM + key64);
                String encrypted64 = Base64Wrapper.encodeToString(encryptedPassword);
                this.sessionProps.setProperty(sessionKey, encrypted64);
            }
        } else {
            cred.setPassword(null);
        }
        this.serverMap.put(keyId, cred);
        this.persistor.persistCredential(keyId);
    }

    private String escapeForPropertyKey(String key) {
        return key.replaceAll("=", "\\=");
    }

    public boolean isCredentialValid(CredentialInfo info) {
        boolean result = false;
        if (info.getUserName().length() > 0 && info.getPassword().length > 0 && info.getSessionId() != -1L && info.getSessionId() == this.getLoginSessionId()) {
            result = true;
        }
        return result;
    }

    public static void removePersistantCredentials() {
        try {
            File f = new File(Config.getUserAuthFile());
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
        catch (Exception e) {
            Trace.securityPrintException(e);
        }
    }

    public void clearCredentialPassword(AuthKey key) {
        String keyId = CredentialManager.buildConnectionKey(key);
        CredentialInfo info = this.findServerCredential(keyId);
        if (!this.serverMap.containsKey(keyId) && info != null) {
            info.setPassword(null);
            this.saveCredential(key, info);
        }
        this.persistor.persistCredential(keyId);
    }

    protected CredentialInfo getCredential(AuthKey key) {
        byte[] buff;
        String keyId = CredentialManager.buildConnectionKey(key);
        CredentialInfo info = this.serverMap.get(keyId);
        if ((info == null || info != null && info.isCredentialEmpty()) && (info = this.findServerCredential(keyId)) == null) {
            info = new CredentialInfo();
        }
        if (info.getPassword().length == 0 && (buff = info.getEncryptedPassword()).length > 0) {
            info.setPassword(this.decryptPassword(buff));
        }
        return info;
    }

    private CredentialInfo findServerCredential(String server) {
        Set<String> set = this.serverMap.keySet();
        for (String key : set) {
            CredentialInfo info;
            if (!CredentialManager.getServerFromKey(server).equals(CredentialManager.getServerFromKey(key)) || (info = this.serverMap.get(key)) == null || info.isCredentialEmpty() || info.getPassword().length <= 0 && info.getEncryptedPassword().length <= 0) continue;
            return info;
        }
        return null;
    }

    private static String getServerFromKey(String conKey) {
        StringTokenizer tokenizer = new StringTokenizer(conKey, ":");
        return tokenizer.nextToken();
    }

    public static String buildConnectionKey(AuthKey con) {
        StringBuffer buffer = new StringBuffer();
        if (con.isProxy()) {
            buffer.append("p:");
        } else {
            buffer.append("s:");
        }
        buffer.append(con.getProtocolScheme());
        buffer.append(':');
        buffer.append(con.getHost());
        buffer.append(':');
        buffer.append(con.getPort());
        buffer.append(':');
        buffer.append(con.getPath());
        return buffer.toString().toLowerCase();
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }

    private class CredentialPersistor {
        private int credentialCount = 0;

        private int getSavedCredentialCount() {
            return this.credentialCount;
        }

        private synchronized void persistCredential(String siteKey) {
            ObjectOutputStream outStream = null;
            try {
                CredentialInfo info = (CredentialInfo)CredentialManager.this.serverMap.get(siteKey);
                if (info != null) {
                    OutputStream fout = this.openOutputFile(true);
                    outStream = new ObjectOutputStream(fout);
                    outStream.writeObject(siteKey);
                    info.writeExternal(outStream);
                    outStream.flush();
                    outStream.close();
                    fout.flush();
                    fout.close();
                }
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
        }

        private synchronized void deleteCredentials() {
            try {
                File f = new File(Config.getUserAuthFile());
                if (!f.delete()) {
                    f.deleteOnExit();
                }
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void persistAllCredentials(Map<String, CredentialInfo> map) {
            ObjectOutputStream outStream = null;
            OutputStream fout = null;
            try {
                fout = this.openOutputFile(false);
                Set<String> set = map.keySet();
                Iterator<String> iter = set.iterator();
                while (iter.hasNext()) {
                    outStream = new ObjectOutputStream(fout);
                    String key = iter.next();
                    CredentialInfo info = map.get(key);
                    outStream.writeObject(key);
                    info.writeExternal(outStream);
                    outStream.flush();
                }
            }
            catch (Throwable e) {
                Trace.securityPrintException(e);
            }
            finally {
                try {
                    if (outStream != null) {
                        outStream.flush();
                    }
                    fout.flush();
                    fout.close();
                }
                catch (Exception e) {
                    Trace.securityPrintException(e);
                }
            }
        }

        private synchronized void getPersistedCredential(ObjectInputStream in, String siteKey) {
            try {
                CredentialInfo info = new CredentialInfo();
                info.readExternal(in);
                CredentialManager.this.serverMap.put(siteKey, info);
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
        }

        private synchronized InputStream openInputStream() {
            InputStream instream = null;
            try {
                final File f = new File(Config.getUserAuthFile());
                instream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        if (!f.exists()) {
                            f.getParentFile().mkdirs();
                            f.createNewFile();
                        }
                        return new BufferedInputStream(new FileInputStream(f));
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
            return instream;
        }

        private synchronized OutputStream openOutputFile(final boolean append) {
            OutputStream out = null;
            try {
                final File f = new File(Config.getUserAuthFile());
                out = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                    @Override
                    public OutputStream run() throws IOException {
                        if (!f.exists()) {
                            f.getParentFile().mkdirs();
                            f.createNewFile();
                        }
                        return new BufferedOutputStream(new FileOutputStream(f, append));
                    }
                }, ACC_FILE_INSTANCE);
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
            return out;
        }

        private synchronized Map<String, CredentialInfo> getAllPersistedCredentials() {
            ObjectInputStream in = null;
            InputStream finstream = null;
            HashMap<String, CredentialInfo> map = null;
            try {
                map = new HashMap<String, CredentialInfo>();
                finstream = this.openInputStream();
                in = new ObjectInputStream(finstream);
                while (in != null) {
                    String siteKey = (String)in.readObject();
                    CredentialInfo info = new CredentialInfo();
                    info.readExternal(in);
                    map.put(siteKey, info);
                    ++this.credentialCount;
                    in = new ObjectInputStream(finstream);
                }
                finstream.close();
            }
            catch (EOFException siteKey) {
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
                try {
                    finstream.close();
                    if (this.credentialCount > 0) {
                        this.persistAllCredentials(map);
                    }
                }
                catch (Exception ex) {
                    Trace.securityPrintException(e);
                }
            }
            return map;
        }

        static /* synthetic */ Map access$000(CredentialPersistor x0) {
            return x0.getAllPersistedCredentials();
        }
    }

    private class CredentialCache
    extends AuthCacheImpl {
        HashMap<String, LinkedList<AuthCacheValue>> map = new HashMap();

        public CredentialCache() {
            this.setMap(this.map);
        }

        @Override
        public void remove(String server, AuthCacheValue value) {
            try {
                super.remove(server, value);
                AuthKey key = AuthCacheBridge.create(value);
                CredentialManager.getInstance().clearCredentialPassword(key);
            }
            catch (Exception e) {
                Trace.securityPrintException(e);
            }
        }
    }
}

