/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.protocol.jar;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarURLConnection;

public class DeployURLConnection
extends JarURLConnection {
    private URL _jarFileURL = null;
    private String _entryName;
    private JarEntry _jarEntry;
    private JarFile _jarFile;
    private String _contentType;
    private boolean _useCachedJar = false;
    private Map<String, List<String>> _headerFields = null;
    private URL _jarFileURLOverride = null;
    private boolean _ignoreClassPath;
    private boolean _useVersionProtocol;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    DeployURLConnection(URL url, Handler handler, boolean ignoreClassPath, boolean useVersionProtocol) throws MalformedURLException, IOException {
        super(DeployURLConnection.getAnchoredURL(url), handler);
        this._ignoreClassPath = ignoreClassPath;
        this._useVersionProtocol = useVersionProtocol;
        this.getJarFileURL();
        this._entryName = this.getEntryName();
    }

    private static URL getAnchoredURL(URL url) {
        if (!Config.isJavaVersionAtLeast10() && Config.isJavaVersionAtLeast9()) {
            try {
                return new URL(url.toString() + "#runtime");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this._jarEntry;
    }

    @Override
    public synchronized URL getJarFileURL() {
        URL jarURL;
        if (this._jarFile instanceof ResourceObject && (jarURL = ((ResourceObject)((Object)this._jarFile)).getResourceURL()) != null) {
            return jarURL;
        }
        if (this._jarFileURL == null) {
            this._jarFileURL = super.getJarFileURL();
        }
        if (this._useVersionProtocol) {
            if (this._jarFileURLOverride != null) {
                return this._jarFileURLOverride;
            }
            try {
                this._jarFileURL = new URL(URLUtil.canonicalize(this._jarFileURL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this._jarFileURL;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        if (this._useVersionProtocol) {
            this._jarFile = this.getJarFileWithVersionId();
        } else {
            this.connect();
        }
        if (ResourceProvider.get().isInternalUse()) {
            return this._jarFile;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JarFile>(){

                @Override
                public JarFile run() throws Exception {
                    if (DeployURLConnection.this._jarFile instanceof ResourceObject) {
                        return (JarFile)((ResourceObject)((Object)DeployURLConnection.this._jarFile)).clone();
                    }
                    String path = DeployURLConnection.this._jarFile.getName();
                    if (new File(path).exists()) {
                        Manifest mf;
                        JarFile jf = JarUtil.createJarFile(new File(path), true);
                        if (DeployURLConnection.this._ignoreClassPath && (mf = jf.getManifest()) != null) {
                            mf.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
                        }
                        return jf;
                    }
                    return DeployURLConnection.this._jarFile;
                }
            }, ACC_FILE_INSTANCE);
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause().getMessage());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (!this._useCachedJar) {
            return super.getInputStream();
        }
        if (this._entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this._jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
        }
        return this._jarFile.getInputStream(this._jarEntry);
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        if (this._useCachedJar && this._entryName == null) {
            return this.getJarFile();
        }
        return super.getContent();
    }

    @Override
    public String getContentType() {
        try {
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._useCachedJar) {
            if (this._contentType == null) {
                if (this._entryName == null) {
                    this._contentType = "x-java/jar";
                } else {
                    try {
                        this.connect();
                        JarFile jf = this._useVersionProtocol ? this.getJarFileWithVersionId() : this._jarFile;
                        InputStream in = jf.getInputStream(this._jarEntry);
                        this._contentType = DeployURLConnection.guessContentTypeFromStream(new BufferedInputStream(in));
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this._contentType == null) {
                    this._contentType = DeployURLConnection.guessContentTypeFromName(this._entryName);
                }
                if (this._contentType == null) {
                    this._contentType = "content/unknown";
                }
            }
        } else {
            this._contentType = super.getContentType();
        }
        return this._contentType;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException e) {
            return super.getContentLength();
        }
        if (this._useCachedJar) {
            if (this._jarEntry != null) {
                return (int)this._jarEntry.getSize();
            }
            return -1;
        }
        return super.getContentLength();
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            URL urlNoQuery = new URL(this._jarFileURL.getProtocol(), this._jarFileURL.getHost(), this._jarFileURL.getPort(), this._jarFileURL.getPath());
            String jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + urlNoQuery.toString());
            URL requestURL = jarVersion == null ? this._jarFileURL : urlNoQuery;
            boolean localJarCached = false;
            if ("file".equalsIgnoreCase(requestURL.getProtocol()) && !this.isLocalJREJar(requestURL)) {
                ResourceProvider.get().getResource(requestURL, jarVersion, true, 256, null);
                localJarCached = true;
            }
            if (ResourceProvider.get().canCache(urlNoQuery)) {
                block14: {
                    Resource r;
                    int type;
                    this.setUseCaches(false);
                    Integer downloadType = (Integer)ToolkitStore.get().getAppContext().get("deploy-download-type-" + urlNoQuery.toString());
                    int n = type = downloadType == null ? 0 : downloadType;
                    if ((type & 0x100000) != 0 && (r = ResourceProvider.get().getCachedResource(requestURL, jarVersion)) == null) {
                        ResourceProvider.get().getResource(requestURL, jarVersion, true, type, null);
                    }
                    if (!localJarCached) {
                        if ((type & 0x1000) != 0) {
                            this.retrieveJarFromCache(jarVersion, requestURL);
                        } else {
                            try {
                                super.connect();
                                this.retrieveJarFromCache(jarVersion, requestURL);
                            }
                            catch (IOException ioe) {
                                this.retrieveJarFromCache(jarVersion, requestURL);
                                if (this._jarFile != null) break block14;
                                throw ioe;
                            }
                        }
                    }
                }
                if (this._jarFile != null) {
                    this._useCachedJar = true;
                } else {
                    super.connect();
                    this._jarFile = super.getJarFile();
                }
            } else {
                super.connect();
                this._jarFile = super.getJarFile();
            }
            if (this._entryName != null) {
                this._jarEntry = this._jarFile.getJarEntry(this._entryName);
                if (this._jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this._entryName + " not found in " + this._jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    private void retrieveJarFromCache(String jarVersion, URL requestURL) throws IOException {
        Resource r = ResourceProvider.get().getCachedResource(requestURL, jarVersion);
        this._jarFile = r != null ? r.getJarFile() : null;
        this._headerFields = r != null ? r.getHeaders() : null;
    }

    @Override
    public URL getURL() {
        URL finalURL;
        if (this._jarFile instanceof ResourceObject && (finalURL = ((ResourceObject)((Object)this._jarFile)).getResourceURL()) != null) {
            try {
                return URLUtil.getJarEntryURL(finalURL, this._entryName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return super.getURL();
    }

    @Override
    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        try {
            this.connect();
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        if (this._headerFields != null) {
            List<String> headers = this._headerFields.get(name.toLowerCase());
            if (headers != null && headers.size() > 0) {
                return headers.get(0);
            }
            return null;
        }
        return super.getHeaderField(name);
    }

    @Override
    public Permission getPermission() throws IOException {
        String urlStringLowerCase;
        if (Config.isJavaVersionAtLeast18() && ((urlStringLowerCase = this.url.toString().toLowerCase()).startsWith("jar:http:") || urlStringLowerCase.startsWith("jar:https:"))) {
            String urlString;
            int bangPos = (urlString = this.url.toString()).indexOf("!/");
            urlString = urlString.substring(4, bangPos > -1 ? bangPos : urlString.length());
            URL u = new URL(urlString);
            return URLUtil.getURLConnectPermission(u);
        }
        return super.getPermission();
    }

    private synchronized JarFile getJarFileWithVersionId() throws IOException {
        String jarVersion;
        if (this._jarFile != null) {
            return this._jarFile;
        }
        if (ResourceProvider.get().canCache(this._jarFileURL) && (jarVersion = (String)ToolkitStore.get().getAppContext().get("deploy-" + this._jarFileURL.toString())) != null) {
            this._jarFileURLOverride = new URL(URLUtil.canonicalize(this._jarFileURL.toString() + "?" + URLEncoder.encode("version-id", "UTF-8") + "=" + URLEncoder.encode(jarVersion, "UTF-8")));
            String currentVersion = ResourceProvider.get().getCurrentVersion(this._jarFileURL);
            if (currentVersion != null && !currentVersion.equals(jarVersion)) {
                this._jarFileURLOverride = new URL(this._jarFileURLOverride.toString() + "&" + URLEncoder.encode("current-version-id", "UTF-8") + "=" + URLEncoder.encode(currentVersion, "UTF-8"));
            }
        }
        this.connect();
        this._jarFileURLOverride = null;
        return this._jarFile;
    }

    private boolean isLocalJREJar(URL jarURL) throws IOException {
        final String javaHome = Platform.get().getLongPathName(Config.getJREHome());
        String javaHomePath = null;
        try {
            javaHomePath = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return new File(javaHome).toURI().toURL().getPath();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new IOException(pae.getCause().getMessage());
        }
        return jarURL.getPath().startsWith(javaHomePath);
    }

    static {
        Permissions perms = new Permissions();
        ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read,write"));
        ((PermissionCollection)perms).add(new RuntimePermission("accessDeclaredMembers"));
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

