/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.config.Platform;
import java.io.IOException;
import java.io.OutputStream;

public class NativeSandboxOutputStream
extends OutputStream {
    private String fileName = null;
    private boolean overwrite = false;

    public NativeSandboxOutputStream(String fileName, boolean overwrite) {
        this.fileName = fileName;
        this.overwrite = overwrite;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)(b & 0xFF)};
        this.write(data);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || b.length - len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (off == 0 && b.length == len) {
            if (this.overwrite) {
                this.overwrite = false;
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, b, -1L, false);
            } else {
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, b, -1L, true);
            }
        } else {
            byte[] data = new byte[len];
            System.arraycopy(b, off, data, 0, len);
            if (this.overwrite) {
                this.overwrite = false;
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, data, -1L, false);
            } else {
                Platform.get().getNativeSandboxBroker().writeFile(this.fileName, data, -1L, true);
            }
        }
    }
}

