/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;

public class NativePlatform {
    String _osname;
    String _osarch;
    String _unifiedOsArch;
    boolean _is32Bit;
    boolean _is64Bit;
    private static NativePlatform _currentNativePlatform = null;

    public String getOSName() {
        return this._osname;
    }

    public String getOSArch() {
        return this._osarch;
    }

    public String getOsArchUnified() {
        return this._unifiedOsArch;
    }

    public boolean is32Bit() {
        return this._is32Bit;
    }

    public boolean is64Bit() {
        return this._is64Bit;
    }

    public static NativePlatform getCurrentNativePlatform() {
        if (null == _currentNativePlatform) {
            _currentNativePlatform = new NativePlatform(null, null);
        }
        return _currentNativePlatform;
    }

    public NativePlatform(String osname, String osarch) {
        if (osname == null) {
            osname = Config.getOSName();
        }
        if (osarch == null) {
            osarch = Config.getOSArch();
        }
        this._osname = osname;
        this._osarch = osarch;
        if (osarch.equals("x86") || osarch.equals("i386") || osarch.equals("i486") || osarch.equals("i586") || osarch.equals("i686")) {
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = "x86";
        } else if (osarch.equals("ppc") || osarch.equals("arm") || osarch.equals("sparc") || osarch.equals("pa_risc2.0")) {
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = osarch;
        } else if (osarch.equals("x86_64") || osarch.equals("amd64")) {
            this._is32Bit = false;
            this._is64Bit = true;
            this._unifiedOsArch = "x86_64";
        } else if (osarch.equals("ia64") || osarch.equals("sparcv9")) {
            this._is32Bit = false;
            this._is64Bit = true;
            this._unifiedOsArch = osarch;
        } else {
            String msg = "JREInfo: unknown osArch: <" + osarch + ">, considering 32bit";
            Trace.println(msg);
            System.out.println(msg);
            this._is32Bit = true;
            this._is64Bit = false;
            this._unifiedOsArch = osarch;
        }
    }

    public boolean match(NativePlatform np) {
        return this.getOSName().equals(np.getOSName()) && this.getOsArchUnified().equals(np.getOsArchUnified());
    }

    public boolean compatible(NativePlatform np) {
        return this.getOSName().equals(np.getOSName()) && Platform.get().isCompatibleArch(this.getOsArchUnified(), np.getOsArchUnified());
    }

    public String toString() {
        String bitDepth = this.is32Bit() ? "32bit" : (this.is64Bit() ? "64bit" : "??bit");
        return this._osname + ", " + this._osarch + " [ " + this._unifiedOsArch + ", " + bitDepth + " ]";
    }
}

