/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import com.sun.deploy.util.BufferUtil;
import com.sun.deploy.util.ByteBufferWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Serializer;

public abstract class AbstractSerializer
implements Serializer {
    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    @Override
    public abstract void writeByte(byte var1) throws IOException;

    @Override
    public void writeShort(short s) throws IOException {
        this.writeByte((byte)(s >>> 8));
        this.writeByte((byte)s);
    }

    @Override
    public void writeChar(char c) throws IOException {
        this.writeShort((short)c);
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >>> 24));
        this.writeByte((byte)(n >>> 16));
        this.writeByte((byte)(n >>> 8));
        this.writeByte((byte)n);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.writeByte((byte)(l >>> 56));
        this.writeByte((byte)(l >>> 48));
        this.writeByte((byte)(l >>> 40));
        this.writeByte((byte)(l >>> 32));
        this.writeByte((byte)(l >>> 24));
        this.writeByte((byte)(l >>> 16));
        this.writeByte((byte)(l >>> 8));
        this.writeByte((byte)l);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    @Override
    public void writeByteArray(byte[] byArray) throws IOException {
        this.writeByteArray(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public void writeByteArray(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeByte(byArray[n + i]);
        }
    }

    @Override
    public void writeCharArray(char[] cArray) throws IOException {
        this.writeCharArray(cArray, 0, cArray == null ? 0 : cArray.length);
    }

    @Override
    public void writeCharArray(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeChar(cArray[n + i]);
        }
    }

    @Override
    public void writeIntegerArray(Integer[] integerArray) throws IOException {
        if (integerArray == null || integerArray.length == 0) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(integerArray.length);
        for (Integer n : integerArray) {
            this.writeInt(n);
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        if (string == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        int n = string.length();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    @Override
    public void writeUTFArray(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(stringArray.length);
        for (String string : stringArray) {
            this.writeUTF(string);
        }
    }

    @Override
    public void writeConversation(Conversation conversation) throws IOException {
        if (conversation == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        conversation.writeFields(this);
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public abstract byte readByte() throws IOException;

    @Override
    public short readShort() throws IOException {
        short s = (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        return s;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public int readInt() throws IOException {
        int n = this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        return n;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.readByte() & 0xFF;
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        return l;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        ByteBufferWrapper byteBufferWrapper = BufferUtil.allocateDirect((int)n);
        for (int i = 0; i < n; ++i) {
            byteBufferWrapper.put(this.readByte());
        }
        byteBufferWrapper.rewind();
        return byteBufferWrapper.getBuffer();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        byte[] byArray = new byte[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.readByte();
        }
        return byArray;
    }

    @Override
    public char[] readCharArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.readChar();
        }
        return cArray;
    }

    @Override
    public Integer[] readIntegerArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = this.readInt();
        }
        return integerArray;
    }

    @Override
    public String readUTF() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.readChar());
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] readUTFArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    @Override
    public Conversation readConversation() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.readFields(this);
        return conversation;
    }
}

