/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.DataBufferInt;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.TranslucentWindowPainter;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.WToolkit;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

public class WWindowPeer
extends WPanelPeer
implements WindowPeer,
DisplayChangedListener {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.windows.WWindowPeer");
    private static final PlatformLogger screenLog = PlatformLogger.getLogger("sun.awt.windows.screen.WWindowPeer");
    private WWindowPeer modalBlocker = null;
    private boolean isOpaque;
    private TranslucentWindowPainter painter;
    private static final StringBuffer ACTIVE_WINDOWS_KEY = new StringBuffer("active_windows_list");
    private static PropertyChangeListener activeWindowListener = new ActiveWindowListener();
    private static final PropertyChangeListener guiDisposedListener = new GuiDisposedListener();
    private WindowListener windowListener;
    private Insets sysInsets;
    private volatile Window.Type windowType = Window.Type.NORMAL;
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;
    private float opacity = 1.0f;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeImpl() {
        Object object;
        AppContext appContext = SunToolkit.targetToAppContext(this.target);
        Object object2 = appContext;
        synchronized (object2) {
            object = (List)appContext.get(ACTIVE_WINDOWS_KEY);
            if (object != null) {
                object.remove(this);
            }
        }
        object2 = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)((GraphicsConfiguration)object2).getDevice()).removeDisplayChangedListener(this);
        object = this.getStateLock();
        synchronized (object) {
            TranslucentWindowPainter translucentWindowPainter = this.painter;
            if (translucentWindowPainter != null) {
                translucentWindowPainter.flush();
            }
        }
        super.disposeImpl();
    }

    @Override
    public void toFront() {
        this.updateFocusableWindowState();
        this._toFront();
    }

    private native void _toFront();

    @Override
    public native void toBack();

    private native void setAlwaysOnTopNative(boolean var1);

    public void setAlwaysOnTop(boolean bl) {
        if (bl && ((Window)this.target).isVisible() || !bl) {
            this.setAlwaysOnTopNative(bl);
        }
    }

    @Override
    public void updateAlwaysOnTopState() {
        this.setAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }

    @Override
    public void updateFocusableWindowState() {
        this.setFocusableWindow(((Window)this.target).isFocusableWindow());
    }

    native void setFocusableWindow(boolean var1);

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this._setTitle(string);
    }

    private native void _setTitle(String var1);

    public void setResizable(boolean bl) {
        this._setResizable(bl);
    }

    private native void _setResizable(boolean var1);

    WWindowPeer(Window window) {
        super(window);
        this.updateGC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initialize() {
        float f;
        super.initialize();
        this.sysInsets = (Insets)this.insets_.clone();
        this.updateInsets(this.insets_);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = defaultFont;
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
        WWindowPeer.initActiveWindowsTracking((Window)this.target);
        this.updateIconImages();
        Shape shape = ((Window)this.target).getShape();
        if (shape != null) {
            this.applyShape(Region.getInstance(shape, null));
        }
        if ((f = ((Window)this.target).getOpacity()) < 1.0f) {
            this.setOpacity(f);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.isOpaque = true;
            this.setOpaque(((Window)this.target).isOpaque());
        }
    }

    native void createAwtWindow(WComponentPeer var1);

    void preCreate(WComponentPeer wComponentPeer) {
        this.windowType = ((Window)this.target).getType();
    }

    @Override
    void create(WComponentPeer wComponentPeer) {
        this.preCreate(wComponentPeer);
        this.createAwtWindow(wComponentPeer);
    }

    @Override
    final WComponentPeer getNativeParent() {
        Window window = ((Window)this.target).getOwner();
        return (WComponentPeer)WToolkit.targetToPeer(window);
    }

    protected void realShow() {
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        this.updateFocusableWindowState();
        boolean bl = ((Window)this.target).isAlwaysOnTop();
        this.updateGC();
        this.realShow();
        this.updateMinimumSize();
        if (((Window)this.target).isAlwaysOnTopSupported() && bl) {
            this.setAlwaysOnTop(bl);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isOpaque) {
                this.updateWindow(true);
            }
        }
        object = this.getNativeParent();
        if (object != null && ((WComponentPeer)object).isLightweightFramePeer()) {
            Rectangle rectangle = this.getBounds();
            this.handleExpose(0, 0, rectangle.width, rectangle.height);
        }
    }

    native void updateInsets(Insets var1);

    @Override
    public Insets getSysInsets() {
        return (Insets)this.sysInsets.clone();
    }

    static native int getSysMinWidth();

    static native int getSysMinHeight();

    static native int getSysIconWidth();

    static native int getSysIconHeight();

    static native int getSysSmIconWidth();

    static native int getSysSmIconHeight();

    native void setIconImagesData(int[] var1, int var2, int var3, int[] var4, int var5, int var6);

    synchronized native void reshapeFrame(int var1, int var2, int var3, int var4);

    native Dimension getNativeWindowSize();

    public Dimension getScaledWindowSize() {
        return this.getNativeWindowSize();
    }

    public boolean requestWindowFocus(CausedFocusEvent.Cause cause) {
        if (!this.focusAllowedFor()) {
            return false;
        }
        return this.requestWindowFocus(cause == CausedFocusEvent.Cause.MOUSE_EVENT);
    }

    private native boolean requestWindowFocus(boolean var1);

    public boolean focusAllowedFor() {
        Window window = (Window)this.target;
        if (!(window.isVisible() && window.isEnabled() && window.isFocusableWindow())) {
            return false;
        }
        return !this.isModalBlocked();
    }

    @Override
    void hide() {
        WindowListener windowListener = this.windowListener;
        if (windowListener != null) {
            windowListener.windowClosing(new WindowEvent((Window)this.target, 201));
        }
        super.hide();
    }

    @Override
    void preprocessPostEvent(AWTEvent aWTEvent) {
        WindowListener windowListener;
        if (aWTEvent instanceof WindowEvent && (windowListener = this.windowListener) != null) {
            switch (aWTEvent.getID()) {
                case 201: {
                    windowListener.windowClosing((WindowEvent)aWTEvent);
                    break;
                }
                case 203: {
                    windowListener.windowIconified((WindowEvent)aWTEvent);
                }
            }
        }
    }

    synchronized void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    @Override
    public void updateMinimumSize() {
        Dimension dimension = null;
        if (((Component)this.target).isMinimumSizeSet()) {
            dimension = ((Component)this.target).getMinimumSize();
        }
        if (dimension != null) {
            int n = WWindowPeer.getSysMinWidth();
            int n2 = WWindowPeer.getSysMinHeight();
            int n3 = dimension.width >= n ? dimension.width : n;
            int n4 = dimension.height >= n2 ? dimension.height : n2;
            this.setMinSize(n3, n4);
        } else {
            this.setMinSize(0, 0);
        }
    }

    @Override
    public void updateIconImages() {
        List<Image> list = ((Window)this.target).getIconImages();
        if (list == null || list.size() == 0) {
            this.setIconImagesData(null, 0, 0, null, 0, 0);
        } else {
            int n = WWindowPeer.getSysIconWidth();
            int n2 = WWindowPeer.getSysIconHeight();
            int n3 = WWindowPeer.getSysSmIconWidth();
            int n4 = WWindowPeer.getSysSmIconHeight();
            DataBufferInt dataBufferInt = SunToolkit.getScaledIconData(list, n, n2);
            DataBufferInt dataBufferInt2 = SunToolkit.getScaledIconData(list, n3, n4);
            if (dataBufferInt != null && dataBufferInt2 != null) {
                this.setIconImagesData(dataBufferInt.getData(), n, n2, dataBufferInt2.getData(), n3, n4);
            } else {
                this.setIconImagesData(null, 0, 0, null, 0, 0);
            }
        }
    }

    native void setMinSize(int var1, int var2);

    public boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModalBlocked(Dialog dialog, boolean bl) {
        Object object = ((Component)this.getTarget()).getTreeLock();
        synchronized (object) {
            WWindowPeer wWindowPeer = (WWindowPeer)dialog.getPeer();
            if (bl) {
                this.modalBlocker = wWindowPeer;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).blockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).blockWindow(this);
                } else {
                    this.modalDisable(dialog, wWindowPeer.getHWnd());
                }
            } else {
                this.modalBlocker = null;
                if (wWindowPeer instanceof WFileDialogPeer) {
                    ((WFileDialogPeer)wWindowPeer).unblockWindow(this);
                } else if (wWindowPeer instanceof WPrintDialogPeer) {
                    ((WPrintDialogPeer)wWindowPeer).unblockWindow(this);
                } else {
                    this.modalEnable(dialog);
                }
            }
        }
    }

    native void modalDisable(Dialog var1, long var2);

    native void modalEnable(Dialog var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getActiveWindowHandles(Component component) {
        AppContext appContext = SunToolkit.targetToAppContext(component);
        if (appContext == null) {
            return null;
        }
        AppContext appContext2 = appContext;
        synchronized (appContext2) {
            List list = (List)appContext.get(ACTIVE_WINDOWS_KEY);
            if (list == null) {
                return null;
            }
            long[] lArray = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                lArray[i] = ((WWindowPeer)list.get(i)).getHWnd();
            }
            return lArray;
        }
    }

    void draggedToNewScreen() {
        SunToolkit.executeOnEventHandlerThread((Component)this.target, new Runnable(){

            @Override
            public void run() {
                WWindowPeer.this.displayChanged();
            }
        });
    }

    public void updateGC() {
        int n = this.getScreenImOn();
        if (screenLog.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("Screen number: " + n);
        }
        Win32GraphicsDevice win32GraphicsDevice = this.winGraphicsConfig.getDevice();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Win32GraphicsDevice win32GraphicsDevice2 = n >= graphicsDeviceArray.length ? (Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice() : (Win32GraphicsDevice)graphicsDeviceArray[n];
        this.winGraphicsConfig = (Win32GraphicsConfig)win32GraphicsDevice2.getDefaultConfiguration();
        if (screenLog.isLoggable(PlatformLogger.Level.FINE) && this.winGraphicsConfig == null) {
            screenLog.fine("Assertion (winGraphicsConfig != null) failed");
        }
        if (win32GraphicsDevice != win32GraphicsDevice2) {
            win32GraphicsDevice.removeDisplayChangedListener(this);
            win32GraphicsDevice2.addDisplayChangedListener(this);
        }
        AWTAccessor.getComponentAccessor().setGraphicsConfiguration((Component)this.target, this.winGraphicsConfig);
    }

    @Override
    public void displayChanged() {
        this.updateGC();
    }

    @Override
    public void paletteChanged() {
    }

    private native int getScreenImOn();

    public final native void setFullScreenExclusiveModeState(boolean var1);

    public void grab() {
        this.nativeGrab();
    }

    public void ungrab() {
        this.nativeUngrab();
    }

    private native void nativeGrab();

    private native void nativeUngrab();

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    @Override
    public native void repositionSecurityWarning();

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.sysX = n;
        this.sysY = n2;
        this.sysW = n3;
        this.sysH = n4;
        super.setBounds(n, n2, n3, n4, n5);
    }

    @Override
    public void print(Graphics graphics) {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            graphics.setClip(shape);
        }
        super.print(graphics);
    }

    private void replaceSurfaceDataRecursively(Component component) {
        Component[] componentArray;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            for (int i = 0; i < n; ++i) {
                Component component2 = componentArray[i];
                this.replaceSurfaceDataRecursively(component2);
            }
        }
        if ((componentArray = component.getPeer()) instanceof WComponentPeer) {
            ((WComponentPeer)componentArray).replaceSurfaceDataLater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Graphics getTranslucentGraphics() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.isOpaque ? null : this.painter.getBackBuffer(false).getGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isOpaque && ((Window)this.target).isVisible()) {
                this.updateWindow(true);
            }
        }
    }

    private native void setOpacity(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOpacity(float f) {
        if (!((SunToolkit)((Window)this.target).getToolkit()).isWindowOpacitySupported()) {
            return;
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The value of opacity should be in the range [0.0f .. 1.0f].");
        }
        if ((this.opacity == 1.0f && f < 1.0f || this.opacity < 1.0f && f == 1.0f) && !Win32GraphicsEnvironment.isVistaOS()) {
            this.replaceSurfaceDataRecursively((Component)this.getTarget());
        }
        this.opacity = f;
        int n = (int)(f * 255.0f);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        this.setOpacity(n);
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isOpaque && ((Window)this.target).isVisible()) {
                this.updateWindow(true);
            }
        }
    }

    private native void setOpaqueImpl(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOpaque(boolean bl) {
        SunToolkit sunToolkit;
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isOpaque == bl) {
                return;
            }
        }
        object = (Window)this.getTarget();
        if (!(bl || (sunToolkit = (SunToolkit)((Window)object).getToolkit()).isWindowTranslucencySupported() && sunToolkit.isTranslucencyCapable(((Component)object).getGraphicsConfiguration()))) {
            return;
        }
        boolean bl2 = Win32GraphicsEnvironment.isVistaOS();
        if (this.isOpaque != bl && !bl2) {
            this.replaceSurfaceDataRecursively((Component)object);
        }
        Object object2 = this.getStateLock();
        synchronized (object2) {
            this.isOpaque = bl;
            this.setOpaqueImpl(bl);
            if (bl) {
                TranslucentWindowPainter translucentWindowPainter = this.painter;
                if (translucentWindowPainter != null) {
                    translucentWindowPainter.flush();
                    this.painter = null;
                }
            } else {
                this.painter = TranslucentWindowPainter.createInstance(this);
            }
        }
        if (bl2 && (object2 = ((Window)object).getShape()) != null) {
            ((Window)object).setShape((Shape)object2);
        }
        if (((Component)object).isVisible()) {
            this.updateWindow(true);
        }
    }

    native void updateWindowImpl(int[] var1, int var2, int var3);

    @Override
    public void updateWindow() {
        this.updateWindow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWindow(boolean bl) {
        Window window = (Window)this.target;
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isOpaque || !window.isVisible() || window.getWidth() <= 0 || window.getHeight() <= 0) {
                return;
            }
            TranslucentWindowPainter translucentWindowPainter = this.painter;
            if (translucentWindowPainter != null) {
                translucentWindowPainter.updateWindow(bl);
            } else if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("Translucent window painter is null in updateWindow");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initActiveWindowsTracking(Window window) {
        AppContext appContext;
        AppContext appContext2 = appContext = AppContext.getAppContext();
        synchronized (appContext2) {
            LinkedList linkedList = (LinkedList)appContext.get(ACTIVE_WINDOWS_KEY);
            if (linkedList == null) {
                linkedList = new LinkedList();
                appContext.put(ACTIVE_WINDOWS_KEY, linkedList);
                appContext.addPropertyChangeListener("guidisposed", guiDisposedListener);
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.addPropertyChangeListener("activeWindow", activeWindowListener);
            }
        }
    }

    static {
        WWindowPeer.initIDs();
    }

    private static class ActiveWindowListener
    implements PropertyChangeListener {
        private ActiveWindowListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AppContext appContext;
            Window window = (Window)propertyChangeEvent.getNewValue();
            if (window == null) {
                return;
            }
            AppContext appContext2 = appContext = SunToolkit.targetToAppContext(window);
            synchronized (appContext2) {
                WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
                List list = (List)appContext.get(ACTIVE_WINDOWS_KEY);
                if (list != null) {
                    list.remove(wWindowPeer);
                    list.add(wWindowPeer);
                }
            }
        }
    }

    private static class GuiDisposedListener
    implements PropertyChangeListener {
        private GuiDisposedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AppContext appContext;
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (!bl && log.isLoggable(PlatformLogger.Level.FINE)) {
                log.fine(" Assertion (newValue != true) failed for AppContext.GUI_DISPOSED ");
            }
            AppContext appContext2 = appContext = AppContext.getAppContext();
            synchronized (appContext2) {
                appContext.remove(ACTIVE_WINDOWS_KEY);
                appContext.removePropertyChangeListener("guidisposed", this);
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.removePropertyChangeListener("activeWindow", activeWindowListener);
            }
        }
    }
}

