/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Utilities;
import sun.swing.SwingUtilities2;

public class PasswordView
extends FieldView {
    static char[] ONE = new char[1];
    private final boolean drawEchoCharacterOverridden;

    public PasswordView(Element element) {
        super(element);
        final Class<?> clazz = this.getClass();
        final Class<Integer> clazz2 = Integer.TYPE;
        final Class<Float> clazz3 = Float.TYPE;
        final Class<Character> clazz4 = Character.TYPE;
        this.drawEchoCharacterOverridden = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class[] classArray = new Class[]{Graphics.class, clazz2, clazz2, clazz4};
                Class[] classArray2 = new Class[]{Graphics2D.class, clazz3, clazz3, clazz4};
                return PlainView.isFPMethodOverriden("drawEchoCharacter", clazz, classArray, classArray2);
            }
        });
    }

    @Override
    @Deprecated
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return (int)this.drawUnselectedTextImpl(graphics, n, n2, n3, n4, false);
    }

    @Override
    protected float drawUnselectedText(Graphics2D graphics2D, float f, float f2, int n, int n2) throws BadLocationException {
        return this.drawUnselectedTextImpl(graphics2D, f, f2, n, n2, true);
    }

    private float drawUnselectedTextImpl(Graphics graphics, float f, float f2, int n, int n2, boolean bl) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                boolean bl2 = bl && this.drawUnselectedTextOverridden && graphics instanceof Graphics2D;
                return bl2 ? super.drawUnselectedText((Graphics2D)graphics, f, f2, n, n2) : (float)super.drawUnselectedText(graphics, (int)f, (int)f2, n, n2);
            }
            if (jPasswordField.isEnabled()) {
                graphics.setColor(jPasswordField.getForeground());
            } else {
                graphics.setColor(jPasswordField.getDisabledTextColor());
            }
            char c = jPasswordField.getEchoChar();
            int n3 = n2 - n;
            boolean bl3 = bl && this.drawEchoCharacterOverridden && graphics instanceof Graphics2D;
            for (int i = 0; i < n3; ++i) {
                f = bl3 ? this.drawEchoCharacter((Graphics2D)graphics, f, f2, c) : (float)this.drawEchoCharacter(graphics, (int)f, (int)f2, c);
            }
        }
        return f;
    }

    @Override
    @Deprecated
    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        return (int)this.drawSelectedTextImpl(graphics, n, n2, n3, n4, false);
    }

    @Override
    protected float drawSelectedText(Graphics2D graphics2D, float f, float f2, int n, int n2) throws BadLocationException {
        return this.drawSelectedTextImpl(graphics2D, f, f2, n, n2, true);
    }

    private float drawSelectedTextImpl(Graphics graphics, float f, float f2, int n, int n2, boolean bl) throws BadLocationException {
        graphics.setColor(this.selected);
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                boolean bl2 = bl && this.drawSelectedTextOverridden && graphics instanceof Graphics2D;
                return bl ? super.drawSelectedText((Graphics2D)graphics, f, f2, n, n2) : (float)super.drawSelectedText(graphics, (int)f, (int)f2, n, n2);
            }
            char c = jPasswordField.getEchoChar();
            int n3 = n2 - n;
            boolean bl3 = bl && this.drawEchoCharacterOverridden && graphics instanceof Graphics2D;
            for (int i = 0; i < n3; ++i) {
                f = bl3 ? this.drawEchoCharacter((Graphics2D)graphics, f, f2, c) : (float)this.drawEchoCharacter(graphics, (int)f, (int)f2, c);
            }
        }
        return f;
    }

    @Deprecated
    protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c) {
        return (int)this.drawEchoCharacterImpl(graphics, n, n2, c, false);
    }

    protected float drawEchoCharacter(Graphics2D graphics2D, float f, float f2, char c) {
        return this.drawEchoCharacterImpl(graphics2D, f, f2, c, true);
    }

    private float drawEchoCharacterImpl(Graphics graphics, float f, float f2, char c, boolean bl) {
        PasswordView.ONE[0] = c;
        SwingUtilities2.drawChars(Utilities.getJComponent(this), graphics, ONE, 0, 1, f, f2);
        if (bl) {
            return f + (float)graphics.getFontMetrics().charWidth(c);
        }
        FontRenderContext fontRenderContext = graphics.getFontMetrics().getFontRenderContext();
        return f + (float)graphics.getFont().getStringBounds(ONE, 0, 1, fontRenderContext).getWidth();
    }

    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.modelToView(n, shape, bias);
            }
            char c = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = this.adjustAllocation(shape).getBounds();
            int n2 = (n - this.getStartOffset()) * fontMetrics.charWidth(c);
            rectangle.x += n2;
            rectangle.width = 1;
            return rectangle;
        }
        return null;
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        int n = 0;
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            if (!jPasswordField.echoCharIsSet()) {
                return super.viewToModel(f, f2, shape, biasArray);
            }
            char c = jPasswordField.getEchoChar();
            int n2 = jPasswordField.getFontMetrics(jPasswordField.getFont()).charWidth(c);
            Rectangle rectangle = (shape = this.adjustAllocation(shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            int n3 = n = n2 > 0 ? ((int)f - rectangle.x) / n2 : Integer.MAX_VALUE;
            if (n < 0) {
                n = 0;
            } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                n = this.getDocument().getLength() - this.getStartOffset();
            }
        }
        return this.getStartOffset() + n;
    }

    @Override
    public float getPreferredSpan(int n) {
        switch (n) {
            case 0: {
                JPasswordField jPasswordField;
                Container container = this.getContainer();
                if (!(container instanceof JPasswordField) || !(jPasswordField = (JPasswordField)container).echoCharIsSet()) break;
                char c = jPasswordField.getEchoChar();
                FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
                Document document = this.getDocument();
                return fontMetrics.charWidth(c) * this.getDocument().getLength();
            }
        }
        return super.getPreferredSpan(n);
    }
}

